/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmeta.Action;
import org.xmeta.ActionContext;
import org.xmeta.Thing;
import org.xmeta.World;
import org.xmeta.util.UtilMap;

public class ActionContainer {
    private static Logger log = LoggerFactory.getLogger(ActionContainer.class);
    static World world = World.getInstance();
    private Thing actions;
    private ActionContext actionContext;

    public ActionContainer(Thing actions, ActionContext actionContext) {
        this.actionContext = actionContext;
        this.actions = actions;
    }

    public Thing getThing() {
        return this.actions;
    }

    public <T> T doAction(String name) {
        block2: {
            try {
                Thing actionThing = this.getActionThing(name);
                if (actionThing == null) break block2;
                Action action = world.getAction(actionThing.getMetadata().getPath());
                return action.run(this.actionContext);
            }
            catch (Throwable e) {
                log.error("Container do action " + name, e);
                return null;
            }
        }
        return null;
    }

    public <T> T doAction(String name, ActionContext context) {
        block2: {
            try {
                Thing actionThing = this.getActionThing(name);
                if (actionThing == null) break block2;
                Action action = world.getAction(actionThing.getMetadata().getPath());
                return action.run(this.actionContext);
            }
            catch (Throwable e) {
                log.error("Container do action " + name, e);
                return null;
            }
        }
        return null;
    }

    public <T> T doAction(String name, Map<String, Object> parameters) {
        block2: {
            try {
                Thing actionThing = this.getActionThing(name);
                if (actionThing == null) break block2;
                Action action = world.getAction(actionThing.getMetadata().getPath());
                return action.run(this.actionContext, parameters);
            }
            catch (Throwable e) {
                log.error("Container do action " + name, e);
                return null;
            }
        }
        return null;
    }

    public <T> T doAction(String name, ActionContext context, Map<String, Object> parameters) {
        block2: {
            try {
                Thing actionThing = this.getActionThing(name);
                if (actionThing == null) break block2;
                Action action = world.getAction(actionThing.getMetadata().getPath());
                return action.run(this.actionContext, parameters);
            }
            catch (Throwable e) {
                log.error("Container do action [" + name + "] exception, actions=" + this.actions.getMetadata().getPath(), e);
                return null;
            }
        }
        return null;
    }

    public <T> T doAction(String name, ActionContext context, Object ... parameters) {
        return this.doAction(name, context, UtilMap.toMap(parameters));
    }

    public Thing getActionThing(String name) {
        Thing child2;
        for (Thing child2 : this.actions.getAllChilds()) {
            if (!child2.getMetadata().getName().equals(name)) continue;
            return child2;
        }
        child2 = this.actions.getActionThing(name);
        if (child2 == null) {
            log.warn("action is not found : " + this.actions.getMetadata().getPath() + "/@" + name);
            return null;
        }
        return child2;
    }

    public List<Thing> getActionThings() {
        ArrayList<Thing> list = new ArrayList<Thing>();
        for (Thing child : this.actions.getAllChilds()) {
            list.add(child);
        }
        for (Thing ac : this.actions.getActionsThings()) {
            list.add(ac);
        }
        return list;
    }

    public ActionContext getActionContext() {
        return this.actionContext;
    }

    public String toString() {
        String str = "ActionContainer: path=" + this.actions.getMetadata().getPath() + "\n    actions=";
        for (Thing ac : this.getActionThings()) {
            str = String.valueOf(str) + ac.getMetadata().getName() + ",";
        }
        return str;
    }

    public <T> T execute(String name, Object ... parameters) {
        block2: {
            try {
                Thing actionThing = this.getActionThing(name);
                if (actionThing == null) break block2;
                Action action = world.getAction(actionThing.getMetadata().getPath());
                return action.run(this.actionContext, parameters);
            }
            catch (Throwable e) {
                log.error("Container do action [" + name + "] exception, actions=" + this.actions.getMetadata().getPath(), e);
                return null;
            }
        }
        return null;
    }
}

