/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import ognl.Ognl;
import ognl.OgnlException;
import org.xmeta.Thing;

public class OgnlUtil {
    private static String CACHE = "__ognl_attrPathCache_";

    public static Object getValue(Thing thing, String pathAttributeName, Object root) throws OgnlException {
        PathCache pathCache = OgnlUtil.getPathCache(thing, pathAttributeName);
        if (pathCache == null) {
            return null;
        }
        return Ognl.getValue((Object)pathCache.expression, (Object)root);
    }

    public static Object getValue(Thing thing, String pathAttributeName, String pathAttributeValue, Object root) throws OgnlException {
        PathCache pathCache = OgnlUtil.getPathCache(thing, pathAttributeName);
        if (pathCache == null) {
            return null;
        }
        return Ognl.getValue((Object)pathCache.expression, (Object)root);
    }

    public static PathCache getPathCache(Thing thing, String attributeName) throws OgnlException {
        String key = String.valueOf(CACHE) + attributeName;
        PathCache pathCache = (PathCache)thing.getData(key);
        if (pathCache == null || pathCache.lastModified != thing.getMetadata().getLastModified()) {
            String path = thing.getStringBlankAsNull(attributeName);
            if (path == null) {
                return null;
            }
            if (pathCache == null) {
                pathCache = new PathCache();
            }
            pathCache.lastModified = thing.getMetadata().getLastModified();
            if (path.startsWith("ognl:")) {
                path = path.substring(5, path.length());
            }
            pathCache.expression = Ognl.parseExpression((String)path);
            thing.setData(key, pathCache);
        }
        return pathCache;
    }

    public static Object getCachedExpression(Thing thing, String attributeName) throws OgnlException {
        PathCache pathCache = OgnlUtil.getPathCache(thing, attributeName);
        return pathCache.expression;
    }

    public static void setValue(Thing thing, String pathAttributeName, String pathAttributeValue, Object value, Object root) throws OgnlException {
        if (pathAttributeValue == null || "".equals(pathAttributeValue)) {
            return;
        }
        String key = String.valueOf(CACHE) + pathAttributeName;
        PathCache pathCache = (PathCache)thing.getData(key);
        if (pathCache == null || pathCache.lastModified != thing.getMetadata().getLastModified()) {
            if (pathCache == null) {
                pathCache = new PathCache();
                thing.setData(key, pathCache);
            }
            pathCache.lastModified = thing.getMetadata().getLastModified();
            pathCache.expression = Ognl.parseExpression((String)pathAttributeValue);
        }
        Ognl.setValue((Object)pathCache.expression, (Object)root, (Object)value);
    }

    static class PathCache {
        long lastModified;
        Object expression;

        PathCache() {
        }
    }
}

