/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ResizeableByteBuffer {
    ByteBuffer[] buffers = new ByteBuffer[1];
    int index = 0;
    int DEFAULT_SIZE = 20480;

    public ResizeableByteBuffer() {
        this.buffers[this.index] = ByteBuffer.allocate(this.DEFAULT_SIZE);
    }

    public ByteBuffer[] getByteBuffers() {
        return this.buffers;
    }

    public Buffer flip() {
        return this.buffers[this.index].flip();
    }

    private void checkAllocate() {
        if (this.buffers[this.index].hasRemaining()) {
            return;
        }
        this.buffers[this.index].flip();
        ByteBuffer[] tmpBuffers = new ByteBuffer[this.buffers.length + 1];
        int i = 0;
        while (i < this.buffers.length) {
            tmpBuffers[i] = this.buffers[i];
            ++i;
        }
        tmpBuffers[this.index].flip();
        tmpBuffers[this.index + 1] = ByteBuffer.allocate(this.DEFAULT_SIZE);
        ++this.index;
    }

    public ByteBuffer put(byte b) {
        this.checkAllocate();
        return this.buffers[this.index].put(b);
    }

    public ByteBuffer put(byte[] src) {
        this.checkAllocate();
        return this.buffers[this.index].put(src);
    }

    public ByteBuffer put(byte[] src, int offset, int length) {
        this.checkAllocate();
        return this.buffers[this.index].put(src, offset, length);
    }

    public ByteBuffer put(ByteBuffer src) {
        this.checkAllocate();
        return this.buffers[this.index].put(src);
    }

    public ByteBuffer put(int index_, byte b) {
        this.checkAllocate();
        return this.buffers[this.index].put(index_, b);
    }

    public ByteBuffer putChar(char value) {
        this.checkAllocate();
        return this.buffers[this.index].putChar(value);
    }

    public ByteBuffer putChar(int index, char value) {
        this.checkAllocate();
        return this.buffers[index].putChar(index, value);
    }

    public ByteBuffer putDouble(double value) {
        this.checkAllocate();
        return this.buffers[this.index].putDouble(value);
    }

    public ByteBuffer putDouble(int index, double value) {
        this.checkAllocate();
        return this.buffers[index].putDouble(index, value);
    }

    public ByteBuffer putFloat(float value) {
        this.checkAllocate();
        return this.buffers[this.index].putFloat(this.index);
    }

    public ByteBuffer putFloat(int index, float value) {
        this.checkAllocate();
        return this.buffers[index].putFloat(index, value);
    }

    public ByteBuffer putInt(int value) {
        this.checkAllocate();
        return this.buffers[this.index].putInt(this.index);
    }

    public ByteBuffer putInt(int index, int value) {
        this.checkAllocate();
        return this.buffers[index].putInt(index, value);
    }

    public ByteBuffer putLong(int index, long value) {
        this.checkAllocate();
        return this.buffers[index].putLong(index, value);
    }

    public ByteBuffer putLong(long value) {
        this.checkAllocate();
        return this.buffers[this.index].putLong(value);
    }

    public ByteBuffer putShort(int index, short value) {
        this.checkAllocate();
        return this.buffers[index].putShort(index, value);
    }

    public ByteBuffer putShort(short value) {
        this.checkAllocate();
        return this.buffers[this.index].putShort(value);
    }
}

