/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.util.Locale;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmeta.World;

public class Resources {
    private static Logger log = LoggerFactory.getLogger(Resources.class);
    ResourceBundle messages;
    Locale locale;
    String name;
    ClassLoader bundleLoader;

    public Resources(String name, Locale local) {
        this.name = name;
        if (local == null) {
            local = Locale.getDefault();
        }
        this.locale = local;
        this.messages = ResourceBundle.getBundle(name, local, World.getInstance().getClassLoader());
        this.bundleLoader = World.getInstance().getClassLoader();
    }

    public String get(String name) {
        try {
            return this.messages.getString(name);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u6e90" + this.name + "\u951f\u63ed\u8be7\u62f7\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u6e90\u951f\u65a4\u62f7\u606f\u951f\u65a4\u62f7" + name);
            }
            return null;
        }
    }

    public String get(String name, String defaultValue) {
        String message = this.get(name);
        if (message == null) {
            return defaultValue;
        }
        return message;
    }

    public void clear() {
        ResourceBundle.clearCache(this.bundleLoader);
    }
}

