/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Startup {
    public static void initJars(File file, List<URL> urlList) {
        block5: {
            block4: {
                if (!file.exists()) {
                    return;
                }
                if (!file.isDirectory()) break block4;
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File childFile = fileArray[n2];
                    Startup.initJars(childFile, urlList);
                    ++n2;
                }
                break block5;
            }
            if (!file.getName().toLowerCase().endsWith(".jar") && !file.getName().toLowerCase().endsWith(".zip")) break block5;
            try {
                urlList.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getHome(String name) {
        String home = Startup.getHomeFromSystem(name = name.toUpperCase());
        if (home == null) {
            home = Startup.getHomeFromSystem(name.toLowerCase());
        }
        return home;
    }

    public static String getHomeFromSystem(String name) {
        String home = System.getProperty(name);
        if (home == null) {
            home = System.getenv(name);
        }
        return home;
    }

    public static String testFileHome(String filePath) {
        if (new File(filePath).exists()) {
            return filePath;
        }
        return null;
    }

    public static String getHomeFormSytsem() {
        String home = Startup.getHome("XMETA_HOME");
        if (home == null) {
            home = Startup.getHome("XWORKER_HOME");
        }
        if (home == null) {
            home = System.getenv("xmeta_home");
        }
        if (home == null) {
            home = System.getenv("XMETA_HOME");
        }
        if (home == null) {
            home = Startup.testFileHome("/usr/local/xworker/");
        }
        return home;
    }

    public static List<String> getClassThingConfig() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        Properties p = new Properties();
        InputStream fin = Startup.class.getResourceAsStream("/META-INF/MANIFEST.MF");
        if (fin != null) {
            p.load(fin);
            String thing = p.getProperty("Start-Thing");
            System.out.println(p);
            if (thing != null) {
                list.add(thing);
                list.add("run");
                return list;
            }
            fin.close();
        }
        if ((fin = Startup.class.getResourceAsStream("/dml.properties")) != null) {
            p.load(fin);
            list.add(p.getProperty("thing"));
            list.add(p.getProperty("action"));
            fin.close();
            return list;
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            File localConfig;
            URL[] urls = null;
            ArrayList<URL> urlList = new ArrayList<URL>();
            if (args.length < 1) {
                String home = Startup.getHomeFormSytsem();
                if (home == null) {
                    System.out.println("Please set xworker home");
                    return;
                }
                List<String> dmlCfg = Startup.getClassThingConfig();
                if (dmlCfg == null) {
                    System.out.println("Can not found dml.properties");
                    return;
                }
                dmlCfg.add(0, home);
                args = new String[dmlCfg.size()];
                dmlCfg.toArray(args);
            }
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                if (arg.length() >= 2 && arg.charAt(0) == '\"' && arg.charAt(arg.length()) == '\"') {
                    args[i] = arg.substring(1, arg.length() - 1);
                }
                ++i;
            }
            String OS = null;
            String PROCESSOR_ARCHITECTURE = null;
            try {
                OS = System.getenv("OS").toLowerCase();
            }
            catch (Exception e) {
                OS = System.getProperty("os.name").toLowerCase();
            }
            PROCESSOR_ARCHITECTURE = "bit" + System.getProperty("sun.arch.data.model");
            InputStream osin = Startup.class.getResourceAsStream("/xworker_os.properties");
            if (osin != null) {
                Properties p = new Properties();
                p.load(osin);
                osin.close();
                String value = p.getProperty(OS);
                if (value != null && !"".equals(value)) {
                    OS = value;
                }
                if ((value = p.getProperty(PROCESSOR_ARCHITECTURE)) != null && !"".equals(value)) {
                    PROCESSOR_ARCHITECTURE = value;
                }
            }
            if ((localConfig = new File("./config/")).exists() && localConfig.isDirectory()) {
                urlList.add(localConfig.toURI().toURL());
            }
            Startup.initJars(new File("./lib_" + OS), urlList);
            Startup.initJars(new File("./lib_" + OS + "_" + PROCESSOR_ARCHITECTURE), urlList);
            Startup.initJars(new File("./lib/"), urlList);
            urlList.add(new File(String.valueOf(args[0]) + "/config/").toURI().toURL());
            Startup.initJars(new File(String.valueOf(args[0]) + "/lib_" + OS), urlList);
            Startup.initJars(new File(String.valueOf(args[0]) + "/lib_" + OS + "_" + PROCESSOR_ARCHITECTURE), urlList);
            Startup.initJars(new File(String.valueOf(args[0]) + "/lib/"), urlList);
            urls = new URL[urlList.size()];
            urlList.toArray(urls);
            URLClassLoader classLoader = new URLClassLoader(urls);
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> trCls = classLoader.loadClass("org.xmeta.util.ThingRunner");
            Method method = trCls.getDeclaredMethod("run", String[].class);
            method.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

