/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmeta.Category;
import org.xmeta.Thing;
import org.xmeta.ThingManager;
import org.xmeta.World;

public class ThingUtil {
    private static Logger logger = LoggerFactory.getLogger(ThingUtil.class);
    static World world = World.getInstance();

    public static void pasteAsChild(Thing thing, Thing forPasteThing) {
        String oldPath = forPasteThing.getStringBlankAsNull("__ORIGIN_THING_PATH__");
        thing.addChild(forPasteThing);
        if (oldPath != null) {
            String newPath = forPasteThing.getMetadata().getPath();
            ThingUtil.replaceThing(forPasteThing, oldPath, newPath);
        }
    }

    public static void paste(Thing thing, Thing forPasteThing) {
        String oldPath = forPasteThing.getStringBlankAsNull("__ORIGIN_THING_PATH__");
        thing.cognize(forPasteThing);
        if (oldPath != null) {
            String newPath = thing.getMetadata().getPath();
            ThingUtil.replaceThing(thing, oldPath, newPath);
        }
    }

    public static void replaceCategory(Category category, String replaceFor, String replaceWidth) {
        Iterator<Thing> iter = category.iterator(true);
        while (iter.hasNext()) {
            Thing thing = iter.next();
            logger.info("replace " + thing.getMetadata().getPath());
            ThingUtil.replaceThing(thing, replaceFor, replaceWidth);
            thing.getMetadata().setLastModified(System.currentTimeMillis());
            thing.save();
        }
    }

    public static void replaceThingManager(ThingManager tm, String replaceFor, String replaceWidth) {
        Iterator<Thing> iter = tm.iterator("", true);
        while (iter.hasNext()) {
            Thing thing = iter.next();
            logger.info("replace " + thing.getMetadata().getPath());
            ThingUtil.replaceThing(thing, replaceFor, replaceWidth);
            thing.getMetadata().setLastModified(System.currentTimeMillis());
            thing.save();
        }
    }

    public static void replaceThing(Thing thing, String replaceFor, String replaceWith) {
        Map<String, Object> attrs = thing.getAttributes();
        for (String key : attrs.keySet()) {
            Object value = attrs.get(key);
            if (value == null || !(value instanceof String)) continue;
            String str = (String)value;
            attrs.put(key, str.replaceAll("(" + replaceFor + ")", replaceWith));
        }
        for (Thing child : thing.getChilds()) {
            ThingUtil.replaceThing(child, replaceFor, replaceWith);
        }
    }

    public static Thing getThing(File file) {
        File wfile = new File(world.getPath());
        Stack<String> stack = new Stack<String>();
        while (!file.getParentFile().equals(wfile)) {
            stack.push(file.getName());
            file = file.getParentFile();
        }
        String thingPath = "";
        int count = 0;
        while (stack.size() > 0) {
            thingPath = ++count == 1 ? (String)stack.pop() : (count == 2 || count == 3 ? String.valueOf(thingPath) + ":" + (String)stack.pop() : String.valueOf(thingPath) + "." + (String)stack.pop());
        }
        return world.getThing(thingPath);
    }

    public static List<Thing> getAllDescriptorsAndExtends(Thing thing) {
        String path;
        ArrayList<Thing> list = new ArrayList<Thing>();
        HashMap<String, String> context = new HashMap<String, String>();
        for (Thing des : thing.getAllDescriptors()) {
            path = des.getMetadata().getPath();
            if (context.get(path) != null) continue;
            list.add(des);
            context.put(path, path);
        }
        for (Thing ext : thing.getExtends()) {
            path = ext.getMetadata().getPath();
            if (context.get(path) != null) continue;
            list.add(ext);
            context.put(path, path);
        }
        return list;
    }
}

