/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class UtilDate {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String TIMESTAMP = "yyyy-MM-dd HH:mm:ss";
    static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    static SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    static SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String getLastTimeInfo(long time) {
        long day = 86400000L;
        long hour = 3600000L;
        long minute = 60000L;
        String info = "";
        long d1 = time / day;
        long d2 = time % day;
        if (d1 > 0L) {
            info = String.valueOf(info) + d1 + "\u5929";
        }
        if (d2 > 0L) {
            d1 = d2 / hour;
            d2 %= hour;
            if (d1 > 0L) {
                info = String.valueOf(info) + d1 + "\u5c0f\u65f6";
            }
            if (d2 > 0L) {
                d1 = d2 / minute;
                d2 %= minute;
                if (d1 > 0L) {
                    info = String.valueOf(info) + d1 + "\u5206\u949f";
                }
                if (d2 > 0L && (d2 /= 1000L) > 0L) {
                    info = String.valueOf(info) + d2 + "\u79d2";
                }
            }
        }
        return info;
    }

    public static Date getWeekStart() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(5, calendar.get(5) - calendar.get(7) + 1);
        return calendar.getTime();
    }

    public static Date getWeekEnd() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(5, calendar.get(5) - calendar.get(7) + 7);
        return calendar.getTime();
    }

    public static Date getMonthStart() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(5, calendar.get(5) - calendar.get(5) + 1);
        return calendar.getTime();
    }

    public static Date getMonthEnd() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(5, 1);
        calendar.set(2, calendar.get(2) + 1);
        calendar.set(5, calendar.get(5) - 1);
        return calendar.getTime();
    }

    public static Date getYearStart() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(5, 1);
        calendar.set(2, 0);
        return calendar.getTime();
    }

    public static Date getYearEnd() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(5, 31);
        calendar.set(2, 11);
        return calendar.getTime();
    }

    public static int getMonthDayCount(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(2, calendar.get(2) + 1);
        calendar.set(5, calendar.get(5) - 1);
        return calendar.get(5);
    }

    public static String getDateString(Date date, String format) {
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.format(date);
    }

    public static boolean isBetween(Date adate, Date start, Date end) {
        if (adate == null) {
            return false;
        }
        if (start != null && start.getTime() <= adate.getTime()) {
            return true;
        }
        return end != null && end.getTime() >= adate.getTime();
    }

    public static boolean isToday(Date date) {
        SimpleDateFormat sf = new SimpleDateFormat(DATE_FORMAT);
        Date now = new Date();
        return sf.format(now).equals(sf.format(date));
    }

    public static Date getDate(Date date1, long interval) {
        if (date1 == null) {
            return null;
        }
        long time = date1.getTime();
        return new Date(time + interval);
    }

    public static Date getDate(Date date, double interval) {
        if (date == null) {
            return null;
        }
        return new Date(date.getTime() + (long)(interval * 8.64E7));
    }

    public static Date getYesterday() {
        Date date = new Date();
        date = new Date(date.getTime() - 86400000L);
        try {
            return UtilDate.getDate(UtilDate.getDateString(date, DATE_FORMAT), DATE_FORMAT);
        }
        catch (ParseException e) {
            return date;
        }
    }

    public static Date getTomorrow() {
        Date date = new Date();
        date = new Date(date.getTime() + 86400000L);
        try {
            return UtilDate.getDate(UtilDate.getDateString(date, DATE_FORMAT), DATE_FORMAT);
        }
        catch (ParseException e) {
            return date;
        }
    }

    public static Date getDate(String dateStr) {
        Date date = null;
        if ("current_date".equals(dateStr)) {
            date = new Date();
        } else {
            try {
                date = dateFormat.parse(dateStr);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public static Date getTime(String timeStr) throws ParseException {
        Date date = null;
        date = "current_time".equals(timeStr) ? new Date() : timeFormat.parse(timeStr);
        return date;
    }

    public static Date getTimestamp(String timeStr) throws ParseException {
        Date date = null;
        if ("current_date".equals(timeStr)) {
            date = new Date();
        } else {
            try {
                date = timestampFormat.parse(timeStr);
            }
            catch (Exception e) {
                try {
                    date = dateFormat.parse(timeStr);
                }
                catch (Exception ee) {
                    date = timestampFormat.parse("1970-01-01 " + timeStr);
                }
            }
        }
        return date;
    }

    public static Date getDate(String dateStr, String format) throws ParseException {
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.parse(dateStr);
    }

    public static long getInterval(Date date1, Date date2) {
        long t2;
        if (date1 == null || date2 == null) {
            return 0L;
        }
        long t1 = date1.getTime();
        if (t1 > (t2 = date2.getTime())) {
            return t1 - t2;
        }
        return t2 - t1;
    }
}

