/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmeta.ActionContext;
import org.xmeta.ActionException;
import org.xmeta.ThingCoder;
import org.xmeta.World;
import org.xmeta.thingManagers.FileThingManager;
import org.xmeta.util.FileCopyMonitor;

public class UtilFile {
    private static Logger logger = LoggerFactory.getLogger(UtilFile.class);

    public static void delete(File afile) {
        if (afile.isDirectory()) {
            File[] fileArray = afile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                UtilFile.delete(subFile);
                ++n2;
            }
            afile.delete();
        } else {
            afile.delete();
        }
    }

    public static void copyFile(File src, File target, FileCopyMonitor monitor) throws IOException {
        if (!src.exists()) {
            throw new IOException(String.valueOf(src.getAbsolutePath()) + " is not exists!");
        }
        if (!target.exists()) {
            File parent = target.getParentFile();
            if (!parent.mkdirs()) {
                throw new IOException("can not create dir " + parent.getAbsolutePath());
            }
        } else if (monitor != null && (target = monitor.onOverWrite(src, target)) == null && monitor.cancel()) {
            return;
        }
        if (src.isFile()) {
            if (target != null && target.isDirectory()) {
                throw new IOException("source is file but target is directory!");
            }
            UtilFile.copy(src, target);
            if (monitor != null) {
                monitor.onCopyed(src, target);
            }
        } else {
            if (!target.exists() && !target.mkdirs()) {
                throw new IOException("can not create dir " + target.getAbsolutePath());
            }
            File[] fileArray = src.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                UtilFile.copyFile(child, new File(target, child.getName()), monitor);
                ++n2;
            }
        }
    }

    private static void copy(File src, File target) throws IOException {
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            fin = new FileInputStream(src);
            fout = new FileOutputStream(target);
            WritableByteChannel outChannel = Channels.newChannel(fout);
            fin.getChannel().transferTo(0L, fin.available(), outChannel);
        }
        finally {
            if (fin != null) {
                fin.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }

    public static String toXWorkerFilePath(String fileName) {
        File worldFile;
        String worldFilePath;
        File file = new File(fileName);
        String filePath = file.getAbsolutePath();
        if (filePath.startsWith(worldFilePath = (worldFile = new File(World.getInstance().getPath())).getAbsolutePath())) {
            filePath = "world|" + filePath.substring(worldFilePath.length(), filePath.length());
            return filePath;
        }
        return filePath;
    }

    public static String getFilePath(String fileName) {
        String path = null;
        if (fileName == null) {
            return fileName;
        }
        if (fileName.startsWith("world|")) {
            path = String.valueOf(World.getInstance().getPath()) + "/" + fileName.substring(6, fileName.length());
        } else if (fileName.startsWith("project|") || fileName.indexOf(":") != -1) {
            int index = fileName.indexOf(":");
            String projectName = null;
            projectName = fileName.startsWith("project|") ? fileName.substring(8, index) : fileName.substring(0, index);
            fileName = fileName.substring(index + 1, fileName.length());
        } else {
            path = fileName;
        }
        if (path != null) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    public static Object getFileOrInputStream(String path, ActionContext actionContext) {
        String filePath = path;
        try {
            URL url = new URL(path);
            if (url.getProtocol() != null && url.getProtocol().startsWith("http")) {
                URLConnection con = url.openConnection();
                try {
                    con.connect();
                    return con.getInputStream();
                }
                catch (Exception ee) {
                    logger.warn("Create image from http error", (Throwable)ee);
                }
            }
        }
        catch (Exception url) {
            // empty catch block
        }
        World world = World.getInstance();
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            filePath = String.valueOf(world.getPath()) + "/" + path;
            file = new File(filePath);
        }
        if (!file.exists() || !file.isFile()) {
            String webRoot = world.getWebFileRoot();
            if (webRoot == null) {
                webRoot = String.valueOf(world.getPath()) + "/webroot";
            }
            filePath = String.valueOf(webRoot) + "/" + path;
            file = new File(filePath);
        }
        if (!file.exists() || !file.isFile()) {
            try {
                filePath = !path.startsWith("/") || !path.startsWith("\\") ? "/" + path : path;
                InputStream rin = world.getResourceAsStream(filePath);
                if (rin != null) {
                    return rin;
                }
            }
            catch (IOException rin) {
                // empty catch block
            }
            Object obj = actionContext.get(path);
            return obj;
        }
        return file;
    }

    public static String getThingPathByFile(File file) throws IOException {
        if (!file.isFile()) {
            return null;
        }
        String name = file.getName();
        String ext = null;
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        ext = name.substring(index + 1, name.length());
        boolean isModel = false;
        for (ThingCoder coder : World.getInstance().getThingCoders()) {
            if (!coder.acceptType(ext)) continue;
            isModel = true;
            break;
        }
        if (!isModel) {
            return null;
        }
        File rootFile = UtilFile.getThingsRootAndInitProject(file.getParentFile());
        if (rootFile == null) {
            rootFile = file.getParentFile();
            if (rootFile == null) {
                return null;
            }
            String tname = UtilFile.getThingManagerNameByDir(rootFile);
            World world = World.getInstance();
            if (world.getThingManager(tname) == null) {
                World.getInstance().addThingManagerFirst(new FileThingManager(tname, rootFile, false));
            }
        }
        return UtilFile.getThingPath(rootFile, file);
    }

    public static String getThingPath(File projectDir, File thingFile) {
        String path = thingFile.getAbsolutePath();
        String prjPath = null;
        prjPath = projectDir != null ? projectDir.getAbsolutePath() : null;
        path = prjPath != null ? path.substring(prjPath.length() + 1, path.length()) : thingFile.getName();
        for (ThingCoder coder : World.getInstance().getThingCoders()) {
            String type = coder.getType();
            if (!path.endsWith(type)) continue;
            path = path.substring(0, path.length() - type.length() - 1);
            if ((path = path.replace(File.separatorChar, '.')).startsWith(".")) {
                path = path.substring(1, path.length());
            }
            return path;
        }
        return null;
    }

    public static File getThingsRootAndInitProject(File dir) throws IOException {
        if (dir == null) {
            return null;
        }
        File prj = new File(dir, ".dmlprj");
        if (prj.exists()) {
            UtilFile.initProject(prj);
            return dir;
        }
        prj = new File(dir, "dml.prj");
        if (prj.exists()) {
            UtilFile.initProject(prj);
            return dir;
        }
        prj = new File(dir, "xworker.properties");
        if (prj.exists()) {
            UtilFile.initProject(prj);
            return new File(dir, "things");
        }
        File parent = dir.getParentFile();
        if (parent != null) {
            return UtilFile.getThingsRootAndInitProject(parent);
        }
        return null;
    }

    public static void initProject(File prjFile) throws IOException {
        World world;
        Properties p = new Properties();
        try {
            FileInputStream fin = new FileInputStream(prjFile);
            p.load(fin);
            fin.close();
        }
        catch (Exception e) {
            throw new ActionException("Read project error, file=" + prjFile.getAbsolutePath(), e);
        }
        String name = p.getProperty("projectName");
        if (name == null || "".equals(name.trim())) {
            name = UtilFile.getThingManagerNameByDir(prjFile.getParentFile());
        }
        if ((world = World.getInstance()).getThingManager(name) == null) {
            world.initThingManager(prjFile.getParentFile(), name);
        }
    }

    public static String getThingManagerNameByDir(File dir) throws IOException {
        String name = dir.getCanonicalPath();
        name = name.replace(':', '_');
        name = name.replace('/', '_');
        name = name.replace('\\', '_');
        if ((name = name.replace('.', '_')).length() > 45) {
            name = String.valueOf(name.substring(0, 20)) + "_" + name.substring(name.length() - 20, name.length());
        }
        return name;
    }

    public static boolean isParent(File parentFile, File childFile) throws IOException {
        if (parentFile == null || childFile == null) {
            return false;
        }
        return childFile.getCanonicalPath().startsWith(parentFile.getCanonicalPath());
    }
}

