/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import org.xmeta.ActionException;
import org.xmeta.Thing;
import org.xmeta.World;

public class UtilThing {
    public static Thing getThingFromAttributeOrChilds(Thing thing, String attributeName, String childThingPath) {
        Thing t = null;
        String attrValue = thing.getString(attributeName);
        if (attrValue != null && !"".equals(attrValue)) {
            t = World.getInstance().getThing(attrValue);
        }
        if (t == null) {
            t = thing.getThing(childThingPath);
            t = t != null && t.getChilds().size() > 0 ? t.getChilds().get(0) : null;
        }
        return t;
    }

    public static Thing getThingFromAttributeOrChild(Thing thing, String attributeName, String childThingPath) {
        Thing t = null;
        String attrValue = thing.getString(attributeName);
        if (attrValue != null && !"".equals(attrValue)) {
            t = World.getInstance().getThing(attrValue);
        }
        if (t == null) {
            return thing.getThing(childThingPath);
        }
        return t;
    }

    public static boolean isDescriptorEquals(Thing descriptorThing, String descriptor) {
        if (descriptorThing == null) {
            return false;
        }
        if (descriptorThing.getMetadata().getPath().equals(descriptor)) {
            return true;
        }
        for (Thing ext : descriptorThing.getAllExtends()) {
            if (!ext.getMetadata().getPath().equals(descriptor)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDescriptorEquals1(String descriptorFor, String descriptor) {
        return UtilThing.isDescriptorEquals(World.getInstance().getThing(descriptorFor), descriptor);
    }

    public static Thing getThingIfNotExistsCreate(String path, String thingManager, String descriptorForCreate) {
        Thing thing = World.getInstance().getThing(path);
        if (thing == null) {
            thing = new Thing(descriptorForCreate);
            thing.saveAs(thingManager, path);
        }
        return thing;
    }

    public static Thing getThingIfNotExistsCreate(String path, String thingManager, Thing forReplace) {
        Thing thing = World.getInstance().getThing(path);
        if (thing == null) {
            thing = forReplace.detach();
            thing.saveAs(thingManager, path);
        }
        return thing;
    }

    public static Thing getQuoteThing(Thing thing, String attribute) {
        Thing root;
        int index;
        String path = thing.getStringBlankAsNull(attribute);
        if (path == null) {
            return null;
        }
        World world = World.getInstance();
        Thing qthing = world.getThing(path);
        if (qthing == null && (index = path.indexOf("/@")) != -1 && (qthing = world.getThing(path = (root = thing.getRoot()) + path.substring(index, path.length()))) != null) {
            thing.set(attribute, path);
        }
        return qthing;
    }

    public static Thing getSelfQuoteThing(Thing thing, String attribute) {
        String path = thing.getStringBlankAsNull(attribute);
        if (path == null) {
            return null;
        }
        Thing root = thing.getRoot();
        if ("_root".equals(path)) {
            return root;
        }
        if ("_parent".equals(path)) {
            return thing.getParent();
        }
        World world = World.getInstance();
        if (path.startsWith(String.valueOf(root.getMetadata().getPath()) + "/@")) {
            return world.getThing(path);
        }
        int index = path.indexOf("/@");
        if (index == -1) {
            return root;
        }
        path = String.valueOf(root.getMetadata().getPath()) + path.substring(index, path.length());
        Thing qthing = world.getThing(path);
        if (qthing != null) {
            thing.set(attribute, path);
        }
        return qthing;
    }

    public static void changeCoder(Thing thing, String coder) {
        if (coder != null && !coder.equals(thing.getMetadata().getCoderType())) {
            if (World.getInstance().getThingCoder(coder) == null) {
                throw new ActionException("Thing coder not exists, type=" + coder);
            }
            thing = thing.getRoot();
            thing.remove();
            thing.getMetadata().setCoderType(coder);
            thing.save();
        }
    }
}

