/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.xmeta.ActionContext;
import org.xmeta.annotation.ActionClass;
import org.xmeta.annotation.ActionField;
import org.xmeta.annotation.ActionParams;

public class ActionAnnotationHelper {
    private Field[] fields;
    private ActionField[] fieldAnnotations;
    private String[] params;
    private Method creator;
    private Class<?> actionClass;
    private Method actionMethod;
    private boolean isActionClass = false;

    public static ActionAnnotationHelper parse(Class<?> cls, Method method) throws NoSuchMethodException, SecurityException {
        ActionAnnotationHelper helper = new ActionAnnotationHelper();
        helper.actionMethod = method;
        ActionParams actionParams = method.getAnnotation(ActionParams.class);
        if (actionParams != null) {
            helper.params = actionParams.names().split("[,]");
            for (int i = 0; i < helper.params.length; ++i) {
                if (helper.params[i] == null) continue;
                helper.params[i] = helper.params[i].trim();
            }
        }
        helper.actionClass = cls;
        ActionClass actionClass = cls.getAnnotation(ActionClass.class);
        if (actionClass != null && (method.getModifiers() & 8) != 8) {
            helper.isActionClass = true;
            if (!actionClass.creator().isEmpty()) {
                helper.creator = cls.getMethod(actionClass.creator(), ActionContext.class);
            }
        }
        ArrayList<Field> allFieldList = new ArrayList<Field>();
        for (Class<?> tempClass = cls; tempClass != null; tempClass = tempClass.getSuperclass()) {
            allFieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        ArrayList<ActionField> fieldAnnotations_ = new ArrayList<ActionField>();
        for (Field field : allFieldList) {
            ActionField actionField = field.getAnnotation(ActionField.class);
            if (actionField == null) continue;
            fieldList.add(field);
            fieldAnnotations_.add(actionField);
        }
        if (fieldList.size() > 0) {
            Field[] fields = new Field[fieldList.size()];
            fieldList.toArray(fields);
            helper.fields = fields;
            helper.fieldAnnotations = new ActionField[fieldList.size()];
            fieldAnnotations_.toArray(helper.fieldAnnotations);
        }
        if (helper.params != null || helper.creator != null || helper.fields != null) {
            return helper;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createObject(ActionContext actionContext) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException, NoSuchMethodException, SecurityException {
        Object obj = null;
        if (this.creator != null) {
            obj = this.creator.invoke(null, actionContext);
        } else if (this.fields != null || (this.actionMethod.getModifiers() & 8) != 8) {
            if (this.isActionClass) {
                obj = actionContext.get(this.actionClass.getName());
            }
            if (obj == null) {
                obj = this.actionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (this.isActionClass) {
                actionContext.g().put(this.actionClass.getName(), obj);
            }
        }
        if (obj != null && this.fields != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                Field field = this.fields[i];
                String name = field.getName();
                String vname = this.fieldAnnotations[i].name();
                if (vname == null || "".equals(vname)) {
                    vname = name;
                }
                boolean accessChanged = false;
                try {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                        accessChanged = true;
                    }
                    field.set(obj, actionContext.get(vname));
                    continue;
                }
                finally {
                    if (accessChanged) {
                        field.setAccessible(false);
                    }
                }
            }
        }
        return obj;
    }

    public Object[] getParamValues(ActionContext actionContext) {
        Object[] values = new Object[this.actionMethod.getParameterCount()];
        if (this.params != null) {
            for (int i = 0; i < this.params.length && i <= values.length - 1; ++i) {
                values[i] = actionContext.get(this.params[i]);
            }
        }
        if (values.length > 0 && (this.params == null || this.params.length < values.length)) {
            values[values.length - 1] = actionContext;
        }
        return values;
    }
}

