/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.cache;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xmeta.Thing;

public class ThingCache {
    private static Map<String, SoftReference<Thing>> cache = new ConcurrentHashMap<String, SoftReference<Thing>>(600);

    public static Thing get(String path) {
        SoftReference<Thing> wr = cache.get(path);
        if (wr == null) {
            return null;
        }
        Thing thing = wr.get();
        if (thing == null) {
            cache.remove(path);
        } else if (thing.getMetadata().isRemoved()) {
            cache.remove(path);
            thing = null;
        }
        return thing;
    }

    public static void put(String path, Thing thing) {
        SoftReference<Thing> wr = cache.get(path);
        if (wr == null || wr.get() == null) {
            wr = new SoftReference<Thing>(thing);
            cache.put(path, wr);
        }
    }

    public static void remove(String path) {
        cache.remove(path);
    }

    public static void clear() {
        cache.clear();
    }
}

