/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.cache;

import java.lang.ref.WeakReference;
import org.xmeta.Thing;
import org.xmeta.World;

public class ThingEntry {
    protected String path;
    protected long lastmodified;
    protected WeakReference<Thing> thingReference = null;
    protected Object data = null;

    public ThingEntry(Thing thing) {
        this(thing.getMetadata().getPath(), thing);
    }

    public ThingEntry(String path, Thing thing) {
        this.path = path;
        this.lastmodified = thing.getMetadata().getLastModified();
        this.thingReference = new WeakReference<Thing>(thing);
    }

    public String getPath() {
        return this.path;
    }

    public Thing getThing() {
        Thing thing = (Thing)this.thingReference.get();
        if (thing != null && !thing.getMetadata().isRemoved() && this.lastmodified == thing.getMetadata().getLastModified()) {
            return thing;
        }
        thing = World.getInstance().getThing(this.path);
        if (thing != null) {
            this.lastmodified = thing.getMetadata().getLastModified();
            this.thingReference = new WeakReference<Thing>(thing);
        }
        return thing;
    }

    public boolean isChanged() {
        Thing thing = (Thing)this.thingReference.get();
        return thing == null || thing.getMetadata().isRemoved() || this.lastmodified != thing.getMetadata().getLastModified();
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }
}

