/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.index;

import java.util.ArrayList;
import java.util.List;
import org.xmeta.Category;
import org.xmeta.Index;
import org.xmeta.ThingManager;
import org.xmeta.World;
import org.xmeta.index.IndexFactory;
import org.xmeta.index.WorldIndex;

public class CategoryIndex
extends Index {
    List<Index> childs = null;
    Index parent = null;
    Category category = null;

    public CategoryIndex(Index parent, Category category) {
        this.parent = parent;
        this.category = category;
    }

    @Override
    public Object getIndexObject() {
        return this.category;
    }

    @Override
    public Index getParent() {
        return this.parent;
    }

    @Override
    public List<Index> getChilds() {
        if (!this.indexed) {
            this.refresh();
        }
        return this.childs;
    }

    @Override
    public String getDescription() {
        return this.category.getName();
    }

    @Override
    public String getLabel() {
        return this.category.getSimpleName();
    }

    @Override
    public String getName() {
        return this.category.getSimpleName();
    }

    @Override
    public String getPath() {
        return this.category.getName();
    }

    @Override
    public String getType() {
        return "category";
    }

    @Override
    public synchronized boolean refresh() {
        this.indexed = true;
        ThingManager thingManager = World.getInstance().getThingManager(this.category.getThingManager().getName());
        if (thingManager == null) {
            return false;
        }
        if (thingManager.getCategory(this.category.getName()) == null) {
            return false;
        }
        if (this.childs == null) {
            this.childs = new ArrayList<Index>();
        }
        ArrayList<Category> categorys = new ArrayList<Category>();
        this.category.refresh();
        for (Category cat : this.category.getCategorys()) {
            if (cat.getName() == null || "".equals(cat.getName())) continue;
            categorys.add(cat);
        }
        IndexFactory.addOrRemoveChilds(this, this.childs, categorys, IndexFactory.categoryIndexFactory, "category");
        IndexFactory.addOrRemoveChilds(this, this.childs, this.category.getThingIndexs(), IndexFactory.thingIndexFactory, "thing");
        WorldIndex.sort(this.childs);
        return true;
    }
}

