/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.thingManagers;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import org.xmeta.Category;
import org.xmeta.ThingCoder;
import org.xmeta.ThingIndex;
import org.xmeta.ThingManager;
import org.xmeta.World;
import org.xmeta.XMetaException;
import org.xmeta.thingManagers.CachedCategory;
import org.xmeta.thingManagers.FileThingManager;

public class FileCategory
extends CachedCategory {
    public FileCategory(String name, ThingManager thingManager, Category parent) {
        super(thingManager, parent, name);
    }

    @Override
    public void refresh() {
        try {
            String filePath;
            File categoryFile;
            String categoryName = this.name;
            if (categoryName == null) {
                categoryName = "";
            }
            if ((categoryFile = new File(filePath = ((FileThingManager)this.thingManager).getFilePath() + "/" + categoryName.replace('.', '/'))).isDirectory()) {
                ArrayList<Category> _childs = new ArrayList<Category>();
                ArrayList<ThingIndex> _thingIndexs = new ArrayList<ThingIndex>();
                if (categoryFile == null || !categoryFile.exists() || categoryFile.isFile()) {
                    // empty if block
                }
                for (File file : categoryFile.listFiles()) {
                    String childName = file.getName();
                    if (".svn".equals(childName)) continue;
                    String path = childName;
                    if (this.name != null && !"".equals(this.name)) {
                        path = this.name + "." + childName;
                    }
                    if (file.isDirectory()) {
                        Category child = null;
                        for (int i = 0; i < this.childCategorys.size(); ++i) {
                            Category c = (Category)this.childCategorys.get(i);
                            if (!c.getSimpleName().equals(childName)) continue;
                            child = c;
                            break;
                        }
                        if (child == null) {
                            child = new FileCategory(path, this.thingManager, this);
                        }
                        boolean added = false;
                        for (int i = 0; i < _childs.size(); ++i) {
                            Category c = (Category)_childs.get(i);
                            if (c.getSimpleName().compareTo(child.getSimpleName()) <= 0) continue;
                            _childs.add(i, child);
                            added = true;
                            break;
                        }
                        if (added) continue;
                        _childs.add(child);
                        continue;
                    }
                    int index = childName.indexOf(".");
                    if (index == -1) continue;
                    String type = childName.substring(index + 1, childName.length());
                    ThingCoder thingCoder = World.getInstance().getThingCoder(type);
                    if (thingCoder == null) continue;
                    ThingIndex child = null;
                    String thingName = childName.substring(0, index);
                    if ("".equals(thingName)) continue;
                    path = path.substring(0, path.lastIndexOf("."));
                    for (int i = 0; i < this.thingIndexs.size(); ++i) {
                        ThingIndex c = (ThingIndex)this.thingIndexs.get(i);
                        if (!c.getName().equals(thingName)) continue;
                        child = c;
                        break;
                    }
                    if (child == null) {
                        try (FileInputStream fin = new FileInputStream(file);){
                            child = new ThingIndex();
                            child.name = thingName;
                            child.path = this.name != null ? this.name + "." + thingName : thingName;
                            child.thingManager = this.thingManager;
                            child.lastModified = file.lastModified();
                        }
                    } else {
                        child.lastModified = file.lastModified();
                    }
                    if (child == null) continue;
                    boolean added = false;
                    for (int i = 0; i < _thingIndexs.size(); ++i) {
                        ThingIndex c = (ThingIndex)_thingIndexs.get(i);
                        if (c.getName().compareTo(child.getName()) <= 0) continue;
                        _thingIndexs.add(i, child);
                        added = true;
                        break;
                    }
                    if (added) continue;
                    _thingIndexs.add(child);
                }
                this.childCategorys = _childs;
                this.thingIndexs = _thingIndexs;
            }
        }
        catch (Exception e) {
            throw new XMetaException("refresh file category error", e);
        }
    }

    @Override
    public void refresh(boolean includeChilds) {
        this.refresh();
        if (includeChilds) {
            for (Category child : this.childCategorys) {
                child.refresh(includeChilds);
            }
        }
    }

    @Override
    public String getFilePath() {
        return ((FileThingManager)this.thingManager).getFilePath() + "/" + this.name.replace('.', '/');
    }
}

