/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.thingManagers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.xmeta.Thing;
import org.xmeta.ThingCoder;
import org.xmeta.ThingMetadata;
import org.xmeta.World;
import org.xmeta.XMetaException;
import org.xmeta.thingManagers.AbstractThingManager;
import org.xmeta.thingManagers.JarCategory;
import org.xmeta.util.ThingClassLoader;

public class JarThingManager
extends AbstractThingManager {
    JarFile jarFile;
    String name;
    String jarFilePath = null;
    boolean refreshed = false;
    ThingClassLoader classLoader;

    public JarThingManager(String name, File jarFile) {
        super(name);
        try {
            this.jarFile = new JarFile(jarFile);
            this.jarFilePath = jarFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new XMetaException("open jar error, jarFile=" + jarFile, e);
        }
        this.rootCategory = new JarCategory(this, null, null);
        try {
            this.classLoader = new ThingClassLoader(new URL[]{jarFile.toURI().toURL()}, (ClassLoader)World.getInstance().getClassLoader());
        }
        catch (MalformedURLException e) {
            this.classLoader = World.getInstance().getClassLoader();
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Thing doLoadThing(String thingName) {
        try {
            ThingCoder thingCoder;
            JarEntry jarEntry;
            JarThingManager jarThingManager = this;
            synchronized (jarThingManager) {
                if (!this.refreshed) {
                    this.refresh();
                    this.refreshed = true;
                }
            }
            String jarEntryName = thingName.replace('.', '/');
            Iterator<ThingCoder> iterator = World.getInstance().getThingCoders().iterator();
            do {
                if (!iterator.hasNext()) return null;
                thingCoder = iterator.next();
            } while ((jarEntry = this.jarFile.getJarEntry(jarEntryName + "." + thingCoder.getType())) == null);
            try (InputStream fin = this.jarFile.getInputStream(jarEntry);){
                Thing thing = new Thing(null, null, null, false);
                ThingMetadata metadata = thing.getMetadata();
                metadata.setPath(thingName);
                String category = null;
                String thingFileName = thingName;
                int lastDotIndex = thingName.lastIndexOf(".");
                if (lastDotIndex != -1) {
                    category = thingName.substring(0, lastDotIndex);
                    thingFileName = thingName.substring(lastDotIndex + 1, thingName.length());
                }
                metadata.setCategory(this.getCategory(category));
                metadata.setCoderType(thingCoder.getType());
                metadata.setReserve(thingFileName);
                long time = jarEntry.getTime();
                thingCoder.decode(thing, fin, time == -1L ? System.currentTimeMillis() : time);
                Thing thing2 = thing;
                return thing2;
            }
        }
        catch (IOException e) {
            throw new XMetaException("load thing from jar error, jarFile=" + this.jarFile, e);
        }
    }

    @Override
    public boolean doRemoveThing(Thing thing) {
        throw new XMetaException("remove thing is not supported by JarThingManager");
    }

    @Override
    public boolean doSaveThing(Thing thing) {
        throw new XMetaException("save thing is not supported by JarThingManager");
    }

    @Override
    public ThingClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void refresh() {
        this.rootCategory.refresh();
    }

    @Override
    public boolean remove() {
        return true;
    }

    @Override
    public boolean removeCategory(String categoryName) {
        throw new XMetaException("remove package is not supported by JarThingManager");
    }

    @Override
    public boolean createCategory(String categoryName) {
        throw new XMetaException("create category is not supported by JarThingManager");
    }

    @Override
    public String getClassPath() {
        return World.getInstance().getClassLoader().getClassPath();
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            JarEntry jarEntry = this.jarFile.getJarEntry(name);
            if (jarEntry != null) {
                return this.jarFile.getInputStream(jarEntry);
            }
        }
        catch (Exception e) {
            throw new XMetaException("get resource stream from jar error", e);
        }
        return null;
    }

    @Override
    public URL findResource(String name) {
        try {
            JarEntry jarEntry = this.jarFile.getJarEntry(name);
            if (jarEntry != null) {
                return new URL("jar:file:/" + this.jarFilePath + "!" + name);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    @Override
    public void init(Properties properties) {
    }

    @Override
    public boolean isSaveable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deflateResources() throws IOException {
        Properties p = this.getProperties();
        String resources = p.getProperty("resources");
        if (resources != null) {
            String[] ress;
            ArrayList<String[]> resList = new ArrayList<String[]>();
            for (String res : resources.split("[,]")) {
                ress = res.split(":");
                resList.add(ress);
            }
            if (resList.size() > 0) {
                FileInputStream fin = new FileInputStream(this.jarFilePath);
                JarInputStream jin = new JarInputStream(fin);
                try {
                    JarEntry entry = null;
                    while ((entry = jin.getNextJarEntry()) != null) {
                        File targetFile;
                        if (entry.isDirectory()) continue;
                        String name = entry.getName();
                        ress = null;
                        for (String[] res : resList) {
                            if (!name.startsWith(res[0]) && !name.startsWith("/" + res[0])) continue;
                            ress = res;
                            break;
                        }
                        if (ress == null) continue;
                        String target = World.getInstance().getPath();
                        if (ress.length > 1) {
                            target = target + "/" + ress[1];
                        }
                        if (!target.endsWith("/") && !target.endsWith("\\")) {
                            target = target + "/";
                        }
                        if (!(targetFile = new File(target = target + name)).exists()) {
                            targetFile.getParentFile().mkdirs();
                        }
                        try (FileOutputStream fout = new FileOutputStream(targetFile);){
                            byte[] bytes = new byte[262144];
                            int length = -1;
                            while ((length = jin.read(bytes)) != -1) {
                                fout.write(bytes, 0, length);
                            }
                        }
                        targetFile.setLastModified(entry.getLastModifiedTime().toMillis());
                    }
                }
                finally {
                    jin.close();
                    fin.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getProperties() {
        InputStream dmlIn = this.getResourceAsStream("/.dml");
        if (dmlIn == null) {
            dmlIn = this.getResourceAsStream("/dml.properties");
        }
        if (dmlIn == null) {
            dmlIn = this.getResourceAsStream(".dml");
        }
        if (dmlIn == null) {
            dmlIn = this.getResourceAsStream("dml.properties");
        }
        if (dmlIn == null) {
            return new Properties();
        }
        Properties p = new Properties();
        try {
            p.load(dmlIn);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                dmlIn.close();
            }
            catch (IOException iOException) {}
        }
        return p;
    }

    public String toString() {
        return "JarThingManager [jarFile=" + this.jarFile + ", name=" + this.name + ", jarFilePath=" + this.jarFilePath + ", refreshed=" + this.refreshed + "]";
    }
}

