/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.xmeta.Action;
import org.xmeta.ActionContext;
import org.xmeta.ActionException;
import org.xmeta.Thing;
import org.xmeta.World;
import org.xmeta.util.UtilMap;

public class ActionContainer {
    private static Logger logger = Logger.getLogger(ActionContainer.class.getName());
    static World world = World.getInstance();
    private Thing actions;
    private ActionContext actionContext;
    private List<Thing> actionThings = null;

    public ActionContainer(Thing actions, ActionContext actionContext) {
        this.actionContext = actionContext;
        this.actions = actions;
    }

    public Thing getThing() {
        return this.actions;
    }

    public void append(Thing action) {
        if (this.actionThings == null) {
            this.actionThings = new ArrayList<Thing>();
        }
        this.actionThings.add(action);
    }

    public List<Thing> getAppednActions() {
        return this.actionThings;
    }

    public <T> T doAction(String name) {
        try {
            Thing actionThing = this.getActionThing(name);
            if (actionThing != null) {
                Action action = world.getAction(actionThing.getMetadata().getPath());
                return action.run(this.actionContext);
            }
            return null;
        }
        catch (Throwable e) {
            throw new ActionException("Container do action [" + name + "] exception, actions=" + this.actions.getMetadata().getPath(), e);
        }
    }

    public <T> T doAction(String name, ActionContext context) {
        try {
            Thing actionThing = this.getActionThing(name);
            if (actionThing != null) {
                Action action = world.getAction(actionThing.getMetadata().getPath());
                return action.run(this.actionContext);
            }
            return null;
        }
        catch (Throwable e) {
            throw new ActionException("Container do action [" + name + "] exception, actions=" + this.actions.getMetadata().getPath(), e);
        }
    }

    public <T> T doAction(String name, Map<String, Object> parameters) {
        try {
            Thing actionThing = this.getActionThing(name);
            if (actionThing != null) {
                Action action = world.getAction(actionThing.getMetadata().getPath());
                return action.run(this.actionContext, parameters);
            }
            return null;
        }
        catch (Throwable e) {
            throw new ActionException("Container do action [" + name + "] exception, actions=" + this.actions.getMetadata().getPath(), e);
        }
    }

    public <T> T doAction(String name, ActionContext context, Map<String, Object> parameters) {
        try {
            Thing actionThing = this.getActionThing(name);
            if (actionThing != null) {
                Action action = world.getAction(actionThing.getMetadata().getPath());
                return action.run(this.actionContext, parameters);
            }
            return null;
        }
        catch (Throwable e) {
            throw new ActionException("Container do action [" + name + "] exception, actions=" + this.actions.getMetadata().getPath(), e);
        }
    }

    public <T> T doAction(String name, ActionContext context, Object ... parameters) {
        return this.doAction(name, context, UtilMap.toMap(parameters));
    }

    public Thing getActionThing(String name) {
        Thing thing = this.getActionThing(this.actions, name);
        if (thing == null && this.actionThings != null) {
            Thing actionThing;
            Iterator<Thing> iterator = this.actionThings.iterator();
            while (iterator.hasNext() && (thing = this.getActionThing(actionThing = iterator.next(), name)) == null) {
            }
        }
        if (thing == null && this.actions.getBoolean("log")) {
            logger.fine("ActionContainer: action is not found : " + this.actions.getMetadata().getPath() + "/@" + name);
            return null;
        }
        return thing;
    }

    private Thing getActionThing(Thing actionThing, String name) {
        for (Thing child : actionThing.getAllChilds()) {
            if (!child.getMetadata().getName().equals(name)) continue;
            return child;
        }
        Thing child = actionThing.getActionThing(name);
        if (child == null) {
            return null;
        }
        return child;
    }

    public List<Thing> getActionThings() {
        ArrayList<Thing> list = new ArrayList<Thing>();
        for (Thing child : this.actions.getAllChilds()) {
            list.add(child);
        }
        for (Thing ac : this.actions.getActionsThings()) {
            list.add(ac);
        }
        return list;
    }

    public ActionContext getActionContext() {
        return this.actionContext;
    }

    public String toString() {
        String str = "ActionContainer: path=" + this.actions.getMetadata().getPath() + "\n    actions=";
        for (Thing ac : this.getActionThings()) {
            str = str + ac.getMetadata().getName() + ",";
        }
        return str;
    }

    public <T> T execute(String name, Object ... parameters) {
        try {
            Thing actionThing = this.getActionThing(name);
            if (actionThing != null) {
                Action action = world.getAction(actionThing.getMetadata().getPath());
                return action.run(this.actionContext, parameters);
            }
            return null;
        }
        catch (Throwable e) {
            throw new ActionException("Container do action [" + name + "] exception, actions=" + this.actions.getMetadata().getPath(), e);
        }
    }
}

