/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ExceptionUtil {
    private static final String[] CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};

    public static String getRootMessage(Throwable t) {
        String message = t.getMessage();
        Throwable cause = t;
        while ((cause = cause.getCause()) != null) {
            message = cause.getMessage();
        }
        return message;
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable c;
        Throwable cause = t;
        while ((c = ExceptionUtil.getCause(cause)) != null) {
            cause = c;
        }
        return cause;
    }

    public static Throwable getCause(Throwable t) {
        for (String methodName : CAUSE_METHOD_NAMES) {
            Throwable th = ExceptionUtil.getCauseUsingMethodName(t, methodName);
            if (th == null) continue;
            return th;
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable, String methodName) {
        Method method = null;
        try {
            method = throwable.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (method != null && Throwable.class.isAssignableFrom(method.getReturnType())) {
            try {
                return (Throwable)method.invoke((Object)throwable, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String toString(Throwable t) {
        StringBuffer text = new StringBuffer();
        ExceptionUtil.toString(t, text);
        return text.toString();
    }

    private static void toString(Throwable t, StringBuffer text) {
        text.append(t.toString());
        text.append("\n");
        for (StackTraceElement st : t.getStackTrace()) {
            text.append("\tat ");
            String line = st.getClassName() + "." + st.getMethodName() + "(";
            line = line + st.getFileName() + ":" + st.getLineNumber();
            text.append(line);
            text.append(")\n");
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            ExceptionUtil.toString(cause, text);
        }
    }
}

