/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.xmeta.ActionContext;
import org.xmeta.Thing;
import org.xmeta.World;

public class JarRunner {
    static File tempDir = new File(System.getProperty("user.home"));

    public static File getXWorkerHome(String home) {
        if ("user.home".equals(home)) {
            return new File(tempDir, "/xworker/");
        }
        if ("xworker_home".equals(home)) {
            home = JarRunner.getHomeFormSytsem();
            return new File(home);
        }
        File file = new File(home);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private static String getHome(String name) {
        String home = JarRunner.getHomeFromSystem(name = name.toUpperCase());
        if (home == null) {
            home = JarRunner.getHomeFromSystem(name.toLowerCase());
        }
        return home;
    }

    private static String getHomeFromSystem(String name) {
        String home = System.getProperty(name);
        if (home == null) {
            home = System.getenv(name);
        }
        return home;
    }

    private static String getHomeFormSytsem() {
        String home = JarRunner.getHome("XMETA_HOME");
        if (home == null) {
            home = JarRunner.getHome("XWORKER_HOME");
        }
        if (home == null) {
            home = System.getenv("xmeta_home");
        }
        if (home == null) {
            home = System.getenv("XMETA_HOME");
        }
        if (home == null) {
            home = JarRunner.testFileHome("/usr/local/xworker/");
        }
        return home;
    }

    public static String testFileHome(String filePath) {
        if (new File(filePath).exists()) {
            return filePath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractXWorker(File root, JarFile jarFile, JarEntry xworkerJar) throws IOException {
        if (!root.exists()) {
            root.mkdirs();
        }
        if (xworkerJar == null) {
            return;
        }
        JarInputStream jin = new JarInputStream(jarFile.getInputStream(xworkerJar));
        JarEntry entry = null;
        while ((entry = jin.getNextJarEntry()) != null) {
            File target;
            if (!(entry.isDirectory() || (target = new File(root, entry.getName())).exists() && target.length() == entry.getSize())) {
                if (!target.exists()) {
                    target.getParentFile().mkdirs();
                }
                byte[] bytes = new byte[8192];
                int length = -1;
                try (FileOutputStream fout = new FileOutputStream(target);){
                    while ((length = jin.read(bytes)) != -1) {
                        fout.write(bytes, 0, length);
                    }
                }
            }
            jin.closeEntry();
        }
        jin.close();
    }

    public static void checkClean(String[] args) {
        boolean cleanTemp = false;
        for (int i = 0; i < args.length; ++i) {
            if (!"xworker-clean".equals(args[i])) continue;
            cleanTemp = true;
            break;
        }
        if (cleanTemp) {
            File xworkerDir = new File(tempDir, "/xworker/");
            JarRunner.delete(xworkerDir);
        }
    }

    public static void delete(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    JarRunner.delete(child);
                }
                file.delete();
            } else {
                file.delete();
            }
        }
    }

    public static String getJarFileName() {
        URL jarUrl = JarRunner.class.getProtectionDomain().getCodeSource().getLocation();
        String fileName = jarUrl.getFile();
        int index = fileName.indexOf("!");
        if (index != -1) {
            fileName = fileName.substring(0, index);
        }
        if (fileName.startsWith("file:")) {
            fileName = fileName.substring(5, fileName.length());
        }
        return fileName;
    }

    public static void main(String[] args) {
        try {
            JarFile jarFile = new JarFile(JarRunner.getJarFileName());
            Attributes attributes = jarFile.getManifest().getMainAttributes();
            String thingPath = attributes.getValue("XWorker-Thing");
            String action = attributes.getValue("XWorker-Action");
            if (action == null || "".equals(action)) {
                action = "run";
            }
            String xworker_home = attributes.getValue("XWorker-Home");
            String xworkerJar = attributes.getValue("XWorker-Jar");
            File xworkerRoot = JarRunner.getXWorkerHome(xworker_home);
            if (xworkerJar != null) {
                JarRunner.extractXWorker(xworkerRoot, jarFile, jarFile.getJarEntry(xworkerJar));
            }
            jarFile.close();
            World world = World.getInstance();
            if (xworkerRoot.exists()) {
                world.init(xworkerRoot.getPath());
            } else {
                world.init(".");
            }
            Thing thing = world.getThing(thingPath);
            if (thing == null) {
                System.out.println("Thing is null, path=" + thingPath);
            } else {
                thing.doAction(action, new ActionContext());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

