/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmeta.World;
import org.xmeta.thingManagers.JarThingManager;

public class JarThingManagerIniter
implements Runnable {
    private static Logger logger = Logger.getLogger(JarThingManagerIniter.class.getName());

    private boolean hasProtocol(String path) {
        try {
            URL purl = new URL(path);
            return purl.getProtocol() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void run() {
        try {
            World world = World.getInstance();
            for (String path : world.getClassLoader().getClassPath().split("[" + File.pathSeparator + "]")) {
                String lpath = path.toLowerCase();
                if (!lpath.endsWith(".jar")) continue;
                try {
                    String name;
                    Properties p = this.getProperties(path, ".dml");
                    if (p == null) {
                        p = this.getProperties(path, "dml.properties");
                    }
                    if (p == null) {
                        p = this.getProperties(path, "dml.prj");
                    }
                    if (p == null) {
                        p = this.getProperties(path, "META-INF/dml.properties");
                    }
                    if (p == null) {
                        p = this.getProperties(path, "META-INF/dml.prj");
                    }
                    if (p == null || (name = p.getProperty("name")) == null) continue;
                    JarThingManager jarThingManager = new JarThingManager(name, new File(path));
                    jarThingManager.init(p);
                    world.addThingManager(jarThingManager);
                }
                catch (Exception ee) {
                    logger.log(Level.FINE, "init jar file manager exception, jar=" + path + ", exception=" + ee.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Init jar file manager exception, " + e.getMessage());
        }
    }

    public Properties getProperties(String path, String dmlPrjFile) throws IOException {
        URL url = null;
        url = !this.hasProtocol(path) ? new URL("jar:file:" + path + "!/" + dmlPrjFile) : new URL("jar:" + path + "!/" + dmlPrjFile);
        try {
            InputStream in = url.openStream();
            if (in != null) {
                Properties p = new Properties();
                p.load(in);
                in.close();
                return p;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

