/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.lang.reflect.Array;
import org.xmeta.Action;
import org.xmeta.ActionContext;
import org.xmeta.Bindings;
import org.xmeta.Thing;
import org.xmeta.World;

public class UtilAction {
    public static String getActionCodeFilePath(Thing actionThing, String ext) {
        String cName;
        String className = "";
        Thing parent = actionThing.getParent();
        Thing rootParent = actionThing.getRoot();
        if (parent == null) {
            parent = actionThing;
        }
        if (rootParent != null) {
            className = className + ".p" + rootParent.getMetadata().getPath().hashCode();
        }
        if (parent != null && parent != rootParent) {
            className = className + ".p" + parent.getMetadata().getPath().hashCode();
        }
        className = (cName = actionThing.getString("className")) == null || "".equals(cName) ? className + "." + actionThing.getMetadata().getName() : className + "." + cName;
        className = Action.getClassName(className);
        String fileName = className.replace('.', '/');
        return World.getInstance().getPath() + "/actionSources/" + fileName + "." + ext;
    }

    public static void putVarByActioScope(Thing action, String varName, Object var, ActionContext actionContext) {
        Bindings bindings;
        if (varName != null && !"".equals(varName) && (bindings = UtilAction.getVarScope(action, actionContext)) != null) {
            bindings.put(varName, var);
        }
    }

    public static Bindings getVarScope(Thing action, ActionContext actionContext) {
        if (action == null) {
            return actionContext.getScope();
        }
        String varScope = action.getString("varScope");
        return UtilAction.getVarScope(varScope, actionContext);
    }

    public static Bindings getVarScope(String varScope, ActionContext actionContext) {
        Bindings binding = null;
        if (varScope == null || "".equals(varScope)) {
            binding = actionContext.getScope();
        } else if ("Global".equals(varScope)) {
            binding = actionContext.getScope(0);
        } else if ("Local".equals(varScope)) {
            binding = actionContext.getScope();
        } else {
            try {
                int scopeIndex = Integer.parseInt(varScope);
                binding = scopeIndex >= 0 ? actionContext.getScope(scopeIndex) : actionContext.getScope(actionContext.getScopesSize() + scopeIndex);
            }
            catch (Exception e) {
                binding = actionContext.getScope(varScope);
            }
        }
        return binding;
    }

    public static boolean getDebugLog(Thing actionThing, ActionContext actionContext) {
        return actionThing.getBoolean("debugLog");
    }

    public static Bindings getReservedVars(String reservedVars, ActionContext actionContext) {
        Bindings bindings = new Bindings();
        if (reservedVars != null) {
            for (String var : reservedVars.split("[,]")) {
                var = var.trim();
                bindings.put(var, actionContext.get(var));
            }
        }
        return bindings;
    }

    public static Class<?> parseClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        if ("int".equals(className)) {
            return Integer.TYPE;
        }
        if ("byte".equals(className)) {
            return Byte.TYPE;
        }
        if ("double".equals(className)) {
            return Double.TYPE;
        }
        if ("long".equals(className)) {
            return Long.TYPE;
        }
        if ("float".equals(className)) {
            return Float.TYPE;
        }
        if ("char".equals(className)) {
            return Character.TYPE;
        }
        if ("boolean".equals(className)) {
            return Boolean.TYPE;
        }
        boolean isArray = false;
        if (className.endsWith("[]")) {
            isArray = true;
            className = className.substring(0, className.length() - 2);
        }
        Class<?> cls = classLoader.loadClass(className);
        if (isArray) {
            return Array.newInstance(cls, 0).getClass();
        }
        return cls;
    }

    public static Class<?> parseClass(String className) throws ClassNotFoundException {
        return UtilAction.parseClass(World.getInstance().getClassLoader(), className);
    }

    public static Class<?>[] parseClasses(ClassLoader classLoader, String classNames) throws ClassNotFoundException {
        if (classNames == null || "".equals(classNames)) {
            return new Class[0];
        }
        String[] clNames = classNames.split("[,]");
        Class[] cls = new Class[clNames.length];
        for (int i = 0; i < clNames.length; ++i) {
            cls[i] = UtilAction.parseClass(classLoader, clNames[i]);
        }
        return cls;
    }

    public static Class<?>[] parseClasses(String classNames) throws ClassNotFoundException {
        return UtilAction.parseClasses(World.getInstance().getClassLoader(), classNames);
    }
}

