/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmeta.ActionClassLoader;
import org.xmeta.ActionContext;
import org.xmeta.ActionException;
import org.xmeta.ActionListener;
import org.xmeta.Bindings;
import org.xmeta.Thing;
import org.xmeta.ThingManager;
import org.xmeta.World;
import org.xmeta.annotation.ActionAnnotationHelper;
import org.xmeta.cache.ThingEntry;
import org.xmeta.thingManagers.ClassThingManager;
import org.xmeta.util.JavaCompiler15;
import org.xmeta.util.JavaCompiler16;
import org.xmeta.util.Semaphore;
import org.xmeta.util.ThingClassLoader;
import org.xmeta.util.UtilAction;
import org.xmeta.util.UtilString;

public class Action
extends Semaphore {
    private static final Logger log = Logger.getLogger(Action.class.getName());
    private static final World world = World.getInstance();
    private static final List<ThrowableRecord> throwables = new ArrayList<ThrowableRecord>();
    private static int throwableRecordCount = 0;
    private static final Map<String, SoftReference<ClassCompileTimeFile>> classTimeFiles = new HashMap<String, SoftReference<ClassCompileTimeFile>>();
    public static final String[] javaKeyWords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while", "#"};
    public static final String str_acContext = "acContext";
    public static final String str_parentContext = "parentContext";
    public static final String str_action = "action";
    public static final String str_actionThing = "actionThing";
    public static final byte SOURCE_LIB = 0;
    public static final byte SOURCE_THINGMANAGER = 1;
    public static final byte SOURCE_THING = 2;
    public ThingEntry thingEntry;
    private boolean isJava = false;
    private boolean throwException;
    private boolean isSynchronized;
    public long lastModified = 0L;
    private boolean useOtherAction;
    private boolean isSelfInterpretationType;
    private String otherActionPath;
    private List<ThingEntry> contexts;
    private ClassLoader classLoader = null;
    private String className;
    private String classFileName;
    private String packageName;
    private String fileName;
    private String code;
    private String methodName;
    private boolean attributeTemplate;
    private Class<?> actionClass = null;
    private boolean changed = false;
    private Action outerAction = null;
    private Method method = null;
    private boolean switchResult = false;
    private final Map<String, Object> userData = new HashMap<String, Object>();
    private List<ActionResult> results;
    private boolean saveReturn;
    private String returnVarName;
    private boolean isCreateLocalVarScope;
    private Map<String, Action> actionsDefiend = null;
    private ActionAnnotationHelper annotationHelper;
    private boolean hasVariables = false;
    private boolean codeInited = false;

    public Action(Thing thing) {
        this.thingEntry = new ThingEntry(thing);
        try {
            this.init();
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("init action error, action=");
            sb.append(thing.getMetadata().getPath());
            String initExceptionMessage = thing.getStringBlankAsNull("initExceptionMessage");
            if (initExceptionMessage != null) {
                sb.append("\n");
                sb.append(initExceptionMessage);
            }
            throw new ActionException(sb.toString(), e);
        }
    }

    public void checkChanged() {
        if (this.lastModified != this.thingEntry.getThing().getMetadata().getLastModified()) {
            if (this.lastModified != 0L) {
                this.changed = true;
            }
            try {
                this.init();
            }
            catch (Exception e) {
                throw new ActionException("", e);
            }
        }
    }

    public String getClassTargetDirectory() {
        String fileManagerName = this.thingEntry.getThing().getMetadata().getThingManager().getName();
        fileManagerName = fileManagerName == null ? "null" : UtilString.trimFileName(fileManagerName);
        return World.getInstance().getPath() + "/work/actionClasses/" + fileManagerName + "/";
    }

    private void init() throws ClassNotFoundException, IOException, SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Thing thing = this.thingEntry.getThing();
        this.throwException = thing.getAttribute("throwException") == null ? true : thing.getBoolean("throwException");
        this.isSynchronized = thing.getBoolean("isSynchronized");
        this.lastModified = thing.getMetadata().getLastModified();
        this.contexts = new ArrayList<ThingEntry>();
        Thing contextsThing = thing.getThing("contexts@0");
        if (contextsThing != null) {
            List<Thing> contextList = contextsThing.getChilds();
            for (Thing contextThing : contextList) {
                this.contexts.add(new ThingEntry(contextThing));
            }
        }
        this.attributeTemplate = thing.getBoolean("attributeTemplate");
        this.useOtherAction = thing.getBoolean("useOtherAction");
        this.otherActionPath = thing.getString("otherActionPath");
        this.isSelfInterpretationType = "Self".equals(thing.getString("interpretationType"));
        List<Thing> actionsThingList = thing.getChilds("ActionDefined");
        if (actionsThingList.size() > 0) {
            this.actionsDefiend = new HashMap<String, Action>();
            for (Thing actionsThing : actionsThingList) {
                for (Thing actionThing : actionsThing.getChilds()) {
                    this.actionsDefiend.put(actionThing.getMetadata().getName(), actionThing.getAction());
                }
            }
        } else {
            this.actionsDefiend = null;
        }
        if (thing.getChilds("Variables").size() > 0) {
            this.hasVariables = true;
        }
        this.returnVarName = thing.getString("returnVarName");
        this.saveReturn = thing.getBoolean("saveReturn");
        if (this.saveReturn && (this.returnVarName == null || "".equals(this.returnVarName))) {
            this.returnVarName = thing.getMetadata().getName();
        }
        this.switchResult = thing.getBoolean("switchResult");
        this.codeInited = false;
        this.actionClass = null;
        this.isJava = "JavaAction".equals(thing.getThingName());
        this.results = new ArrayList<ActionResult>();
        for (Thing child : thing.getAllChilds("Result")) {
            ActionResult result = new ActionResult(child);
            this.results.add(result);
        }
        this.isCreateLocalVarScope = thing.getBoolean("createLocalVarScope");
        if (this.isJava) {
            String javaClassName = null;
            byte sourceType = 0;
            if (thing.getBoolean("useOuterJava")) {
                javaClassName = thing.getString("outerClassName");
            } else if (thing.getBoolean("useInnerJava")) {
                sourceType = 1;
                javaClassName = thing.getString("outerClassName");
            } else {
                sourceType = 2;
                javaClassName = this.packageName + "." + thing.getString("className");
            }
            this.initJava(thing, sourceType, javaClassName);
        } else if (this.useOtherAction) {
            this.outerAction = world.getAction(this.otherActionPath);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initJava(Thing thing, byte sourceType, String javaClassName) throws ClassNotFoundException, IOException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.initClassAndCode();
        if (this.actionClass == null) {
            this.changed = false;
            if (sourceType == 0) {
                if (javaClassName == null || "".equals(javaClassName)) {
                    throw new ActionException("Out class name not setted, action=" + thing.getMetadata().getPath());
                }
                ThingClassLoader clsLoader = thing.getMetadata().getCategory().getClassLoader();
                this.actionClass = clsLoader.loadClass(javaClassName);
            } else {
                boolean recompile = this.isNeedRecompile();
                File classFile = new File(this.classFileName);
                if (!classFile.exists()) {
                    recompile = true;
                }
                ThingClassLoader pclssLoader = thing.getMetadata().getCategory().getClassLoader();
                String compleClassPath = pclssLoader.getCompileClassPath();
                if (recompile && world.getMode() == World.MODE_PROGRAMING) {
                    if (sourceType == 1) {
                        String javaFileName = javaClassName.replace('.', '/') + ".java";
                        ThingManager thingManager = thing.getMetadata().getThingManager();
                        URL sourceURL = thingManager.findResource(javaFileName);
                        if (sourceURL == null) {
                            thingManager.findResource("/" + javaFileName);
                        }
                        if (sourceURL == null) throw new ActionException("Code file not found, java=" + javaFileName + ", actionThing=" + thing.getMetadata().getPath());
                        String sourcePath = World.getInstance().getPath() + "/work/actionSources/" + thingManager.getName() + "/";
                        File codeFile = new File(sourcePath + javaFileName);
                        if (!codeFile.exists()) {
                            codeFile.getParentFile().mkdirs();
                        }
                        try (FileOutputStream fout = new FileOutputStream(codeFile);){
                            InputStream uin = sourceURL.openStream();
                            byte[] bytes = new byte[4096];
                            int length = -1;
                            while ((length = uin.read(bytes)) != -1) {
                                fout.write(bytes, 0, length);
                            }
                            uin.close();
                        }
                        boolean use16 = true;
                        boolean compiled = false;
                        try {
                            Class.forName("javax.tools.JavaCompiler");
                        }
                        catch (Exception e) {
                            use16 = false;
                        }
                        if (use16) {
                            compiled = JavaCompiler16.compile(compleClassPath, sourcePath, codeFile, this.getClassTargetDirectory());
                        }
                        if (!compiled) {
                            JavaCompiler15.compile(compleClassPath, sourcePath, codeFile.getAbsolutePath(), this.getClassTargetDirectory());
                        }
                    } else {
                        File codeFile = new File(this.fileName + ".java");
                        if (!codeFile.exists()) {
                            codeFile.getParentFile().mkdirs();
                        }
                        try (FileOutputStream fout = new FileOutputStream(codeFile);){
                            fout.write(("/*path:" + thing.getMetadata().getPath() + "*/\n").getBytes());
                            fout.write(("package " + this.packageName + ";\n\n").getBytes());
                            fout.write(this.code.getBytes());
                        }
                        File classDir = new File(world.getPath() + "/work/actionClasses");
                        if (!classDir.exists()) {
                            classDir.mkdirs();
                        }
                        boolean use16 = true;
                        boolean compiled = false;
                        try {
                            Class.forName("javax.tools.JavaCompiler");
                        }
                        catch (Exception e) {
                            use16 = false;
                        }
                        if (use16) {
                            compiled = JavaCompiler16.compile(compleClassPath, null, codeFile, this.getClassTargetDirectory());
                        }
                        if (!compiled) {
                            JavaCompiler15.compile(compleClassPath, null, this.fileName, this.getClassTargetDirectory());
                        }
                    }
                    this.updateCompileTime();
                }
                this.actionClass = this.getClassLoader().loadClass(javaClassName);
            }
            try {
                if (this.methodName == null || "".equals(this.methodName)) return;
                this.method = this.getDeclaredMethod(this.actionClass, this.methodName);
                if (this.method == null) {
                    throw new NoSuchMethodException(this.methodName);
                }
                this.annotationHelper = ActionAnnotationHelper.parse(this.actionClass, this.method);
                return;
            }
            catch (Throwable e) {
                throw new ActionException("load method error, class=" + this.actionClass.getName() + ", method=" + this.methodName + ",action=" + thing.getMetadata().getPath(), e);
            }
        }
        if (this.method != null) return;
        try {
            if (this.methodName == null || "".equals(this.methodName)) return;
            this.method = this.getDeclaredMethod(this.actionClass, this.methodName);
            if (this.method == null) {
                throw new NoSuchMethodException(this.methodName);
            }
            this.annotationHelper = ActionAnnotationHelper.parse(this.actionClass, this.method);
            return;
        }
        catch (Exception e) {
            throw new ActionException("", e);
        }
    }

    public ClassLoader getClassLoader() throws MalformedURLException {
        if (this.classLoader == null || this.changed) {
            Action action;
            Thing thing = this.thingEntry.getThing();
            String actionClassLoader = thing.getStringBlankAsNull("actionClassLoader");
            if (actionClassLoader != null && (action = World.getInstance().getAction(actionClassLoader)) != null) {
                this.classLoader = action.getClassLoader();
                return this.classLoader;
            }
            ThingClassLoader pclssLoader = thing.getMetadata().getCategory().getClassLoader();
            if (world.getMode() == World.MODE_WORKING) {
                this.classLoader = pclssLoader;
            } else {
                String fileManagerName = thing.getMetadata().getThingManager().getName();
                fileManagerName = fileManagerName == null ? "null" : UtilString.trimFileName(fileManagerName);
                File classDir = new File(world.getPath() + "/work/actionClasses/" + fileManagerName);
                if (!classDir.exists()) {
                    classDir.mkdirs();
                }
                this.classLoader = new ActionClassLoader(new URL[]{classDir.toURI().toURL()}, (ClassLoader)pclssLoader);
            }
        }
        return this.classLoader;
    }

    private Method getDeclaredMethod(Class<?> cls, String methodName) throws Exception {
        Exception exception = null;
        try {
            return cls.getDeclaredMethod(methodName, ActionContext.class);
        }
        catch (Exception e) {
            exception = e;
            for (Method method : cls.getMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return method;
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getActionClass(ActionContext actionContext) {
        Thing thing = this.thingEntry.getThing();
        if (this.lastModified != thing.getMetadata().getLastModified()) {
            if (this.lastModified != 0L) {
                this.changed = true;
            }
            try {
                this.init();
            }
            catch (Exception e) {
                throw new ActionException("", e);
            }
        }
        if (this.isJava) {
            return this.actionClass;
        }
        if (actionContext == null) {
            actionContext = new ActionContext();
        }
        try {
            actionContext.pushPoolBindings().put(str_actionThing, thing);
            Class clazz = (Class)thing.doAction("getActionClass", actionContext);
            return clazz;
        }
        finally {
            actionContext.pop();
        }
    }

    public void updateCompileTime() {
        Action.updateClassCompileTime(this.classFileName, this.className, this.lastModified);
    }

    public Method getMethod() {
        return this.method;
    }

    public final <T> T run() {
        return this.runArrayParams(new ActionContext(), null, null, false);
    }

    public final <T> T run(ActionContext actionContext) {
        return this.runMapParams(actionContext, null, null, false);
    }

    public final <T> T run(ActionContext actionContext, Object ... params) {
        return this.runArrayParams(actionContext, params, null, false);
    }

    public final <T> T exec(Object ... params) {
        return this.runArrayParams(null, params, null, false);
    }

    public final <T> T exec(ActionContext actionContext, Object ... params) {
        return this.runArrayParams(actionContext, params, null, false);
    }

    public final <T> T call(ActionContext actionContext, Object ... params) {
        return this.runArrayParams(actionContext, params, null, false);
    }

    public final <T> T call(ActionContext actionContext, Map<String, Object> parameters) {
        return this.runMapParams(actionContext, parameters, null, false);
    }

    public final <T> T run(ActionContext actionContext, Map<String, Object> parameters) {
        return this.runMapParams(actionContext, parameters, null, false);
    }

    public final <T> T run(ActionContext actionContext, Map<String, Object> parameters, boolean isSubAction) {
        return this.runMapParams(actionContext, parameters, null, isSubAction);
    }

    public final <T> T run(ActionContext actionContext, Map<String, Object> parameters, Object caller, boolean isSubAction) {
        return this.runMapParams(actionContext, parameters, caller, isSubAction);
    }

    public final <T> T runArrayParams(ActionContext actionContext, Object[] params_, Object caller, boolean isSubAction) {
        if (actionContext == null) {
            actionContext = new ActionContext();
        }
        Bindings bindings = new Bindings();
        bindings.setParameterScope(true);
        if (params_ != null) {
            for (int i = 0; i < params_.length - 1; ++i) {
                bindings.put((String)params_[i], params_[i + 1]);
                ++i;
            }
        }
        return this.dorun(actionContext, bindings, bindings, caller, isSubAction);
    }

    public final <T> T runMapParams(ActionContext actionContext, Map<String, Object> parameters, Object caller, boolean isSubAction) {
        if (actionContext == null) {
            actionContext = new ActionContext();
        }
        Bindings bindings = new Bindings();
        bindings.setParameterScope(true);
        if (parameters != null) {
            bindings.putAll(parameters);
        }
        return this.dorun(actionContext, bindings, parameters, caller, isSubAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T dorun(ActionContext actionContext, Bindings bindings, Map<String, Object> parameters, Object caller, boolean isSubAction) {
        Thing thing;
        if (!actionContext.isDisableGloableContext() && world.isHaveActionListener()) {
            ActionListener listener = world.getActionListener();
            try {
                listener.actionExecuted(this, caller, actionContext, parameters, -1L, true);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "ActionRecorder error", t);
            }
        }
        if (this.lastModified != (thing = this.thingEntry.getThing()).getMetadata().getLastModified()) {
            if (this.lastModified != 0L) {
                this.changed = true;
            }
            try {
                this.init();
            }
            catch (Exception e) {
                throw new ActionException("", e);
            }
        }
        boolean thisIsSynchronized = false;
        if (this.isSynchronized) {
            try {
                this.use();
                thisIsSynchronized = true;
            }
            catch (InterruptedException e) {
                throw new ActionException("try to synchronize action : " + thing.getMetadata().getPath(), e);
            }
        }
        actionContext.push(bindings);
        if (this.isCreateLocalVarScope) {
            bindings.setVarScopeFlag();
        }
        actionContext.pushAction(this);
        bindings.put("world", world);
        if (this.actionsDefiend != null) {
            bindings.putAll(this.actionsDefiend);
        }
        if (this.hasVariables) {
            for (Thing vars : thing.getChilds("Variables")) {
                for (Thing var : vars.getChilds()) {
                    String key = var.getMetadata().getName();
                    T value = var.getAction().run(actionContext, null, true);
                    bindings.put(key, value);
                }
            }
        }
        Object result = null;
        List<Thing> allContexts = this.getContextThings(actionContext);
        bindings.setCaller(this, null);
        bindings.world = world;
        try {
            Object object;
            Throwable exception;
            Bindings returnVarBindings;
            if (allContexts.size() > 0) {
                for (Thing contextThing : allContexts) {
                    Action.initContext(this, contextThing, actionContext);
                }
            }
            if (this.useOtherAction) {
                Bindings callerBindings = actionContext.getScope(actionContext.getScopesSize() - 2);
                try {
                    actionContext.push(callerBindings);
                    result = this.outerAction.run(actionContext, parameters, isSubAction);
                }
                finally {
                    actionContext.pop();
                }
            }
            if (this.isJava) {
                if (this.actionClass != null) {
                    if (this.method == null) throw new ActionException("Java action method not setted");
                    Object classInstance = null;
                    Object[] paramValues = null;
                    if (this.annotationHelper != null) {
                        if ((this.method.getModifiers() & 8) != 8) {
                            classInstance = this.annotationHelper.createObject(actionContext);
                        }
                        paramValues = this.annotationHelper.getParamValues(actionContext);
                    }
                    if (classInstance == null && (this.method.getModifiers() & 8) != 8) {
                        classInstance = this.actionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    if (paramValues == null) {
                        paramValues = this.method.getParameterCount() > 0 ? new Object[]{actionContext} : new Object[]{};
                    }
                    result = this.method.invoke(classInstance, paramValues);
                }
            } else if (this.isSelfInterpretationType) {
                if (this.attributeTemplate) {
                    Thing fthing = (Thing)thing.run("processAttributeTemplate", actionContext, (Map<String, Object>)null, isSubAction, true);
                    if (fthing != null) {
                        result = fthing.run("run", actionContext, (Map<String, Object>)null, isSubAction, true);
                    }
                } else {
                    result = thing.run("run", actionContext, (Map<String, Object>)null, isSubAction, true);
                }
            } else {
                Thing actionThing = thing.getActionThing("run");
                if (actionThing != null) {
                    Object ac = null;
                    try {
                        ac = actionThing.getAction();
                    }
                    catch (Exception e) {
                        throw new ActionException("Get run action error, thing=" + thing.getMetadata().getPath(), e);
                    }
                    result = ((Action)ac).run(actionContext, null, caller, isSubAction);
                }
            }
            if (this.saveReturn && this.returnVarName != null && !"".equals(this.returnVarName) && (returnVarBindings = UtilAction.getVarScope(this.thingEntry.getThing(), actionContext)) != null) {
                returnVarBindings.put(this.returnVarName, result);
            }
            if (this.switchResult) {
                String resultStr = String.valueOf(result);
                for (Thing switchs : thing.getChilds("ResultSwitch")) {
                    boolean ok = false;
                    for (Thing child : switchs.getChilds()) {
                        if (!resultStr.equals(child.getMetadata().getName())) continue;
                        result = child.getAction().run(actionContext, null, caller, isSubAction);
                        ok = true;
                        break;
                    }
                    if (!ok) continue;
                    break;
                }
            }
            if (actionContext.getStatus() == 5 && !isSubAction) {
                if (actionContext.getThrowedObject() instanceof Throwable) {
                    throw (Throwable)actionContext.getThrowedObject();
                }
                Object throwedObject = actionContext.getThrowedObject();
                if (throwedObject == null) throw new ActionException("action throw null");
                if (!(throwedObject instanceof Throwable)) throw new ActionException(throwedObject.toString());
                throw (Throwable)throwedObject;
            }
            String contxtMethod = "success";
            if ("failure".equals(result)) {
                contxtMethod = "failure";
            }
            if ((exception = Action.doContextMethod(allContexts, actionContext, contxtMethod, null, result)) == null) {
                object = result;
                return (T)object;
            }
            if (!this.throwException) {
                this.logHideenExceptionStackTrace(exception, actionContext);
                object = null;
                return (T)object;
            }
            try {
                throw exception;
            }
            catch (Throwable e) {
                exception = Action.doContextMethod(allContexts, actionContext, "exception", e, null);
                if (throwableRecordCount > 0) {
                    throwables.add(new ThrowableRecord(exception, actionContext));
                    while (throwables.size() > throwableRecordCount) {
                        throwables.remove(0);
                    }
                }
                if (exception == null) {
                    object = null;
                    return (T)object;
                }
                if (this.throwException) throw this.wrapToActionException(exception, actionContext);
                this.logHideenExceptionStackTrace(e, actionContext);
                object = null;
                return (T)object;
            }
        }
        finally {
            actionContext.pop();
            actionContext.popAction();
            if (!isSubAction) {
                actionContext.setStatus(0);
            }
            if (thisIsSynchronized) {
                this.finished();
            }
        }
    }

    private List<Thing> getContextThings(ActionContext actionContext) {
        if (actionContext.isDisableGloableContext()) {
            return Collections.emptyList();
        }
        ArrayList<Thing> allContexts = new ArrayList<Thing>();
        if (!actionContext.isDisableGloableContext()) {
            for (ThingEntry entry : Action.world.globalContexts) {
                this.addContextThing(allContexts, entry.getThing());
            }
        }
        if (this.contexts.size() > 0) {
            for (ThingEntry entry : this.contexts) {
                this.addContextThing(allContexts, entry.getThing());
            }
        }
        for (Bindings bindings : actionContext.getScopes()) {
            this.addContextThing(allContexts, bindings.getContextThing());
        }
        return allContexts;
    }

    private void addContextThing(List<Thing> contexts, Thing contextThing) {
        if (contextThing == null) {
            return;
        }
        contexts.add(contextThing);
    }

    private ActionException wrapToActionException(Throwable t, ActionContext actionContext) {
        Throwable cause;
        if (t instanceof InvocationTargetException && (cause = t.getCause()) != null) {
            t = cause;
        }
        if (t instanceof ActionException) {
            return (ActionException)t;
        }
        return new ActionException("Action exception: " + this.thingEntry.getPath(), t, actionContext);
    }

    private void logHideenExceptionStackTrace(Throwable t, ActionContext actionContext) {
        log.log(Level.WARNING, "action ActionContext stacktrace:" + this.thingEntry.getPath());
        log.log(Level.WARNING, actionContext.getStackTrace());
        if (t instanceof InvocationTargetException) {
            log.log(Level.WARNING, "action hidden throwable", t.getCause());
        } else {
            log.log(Level.WARNING, "action hidden throwable", t);
        }
    }

    private static final Throwable doContextMethod(List<Thing> contexts, ActionContext actionContext, String methodName, Throwable exception, Object result) {
        ArrayList<Thing> thingList = new ArrayList<Thing>();
        for (Thing thing : contexts) {
            thingList.add(thing);
        }
        return Action.doThingContextMethod(thingList, actionContext, methodName, exception, result);
    }

    public static final Throwable doThingContextMethod(List<Thing> contexts, ActionContext actionContext, String methodName, Throwable exception, Object result) {
        if (contexts.size() == 0) {
            return exception;
        }
        String tempMethodName = methodName;
        Bindings bindings = actionContext.peek();
        bindings.put("action-exception", exception);
        bindings.put("action-result", result);
        bindings.put("contexts", contexts);
        for (int i = contexts.size() - 1; i >= 0; --i) {
            Thing contextObj = contexts.get(i);
            ActionContext acContext = bindings.getContexts().get(contextObj);
            if (acContext != null) {
                acContext.peek().put("result", result);
                acContext.peek().put("exception", exception);
            }
            if (contextObj == null || acContext == null || acContext.getScope(0).getCaller() != contextObj) continue;
            String onError = contextObj.getString("onError");
            try {
                String preventError;
                contextObj.doAction(tempMethodName, acContext);
                if (!"exception".equals(methodName) || exception == null || !"true".equals(preventError = contextObj.getString("preventError"))) continue;
                exception = null;
                continue;
            }
            catch (Exception e) {
                log.log(Level.WARNING, "\u6267\u884c" + contextObj.getMetadata().getPath() + "\u4e0a\u4e0b\u6587\u65b9\u6cd5" + methodName + "\u5931\u8d25\uff1a", e);
                if ("exception".equals(onError)) {
                    tempMethodName = "exception";
                }
                if (exception != null) continue;
                exception = e;
            }
        }
        return exception;
    }

    public static void initContext(Action action, Thing context, ActionContext actionContext) {
        if (context == null || context.getBoolean("disable")) {
            return;
        }
        Bindings bindings = actionContext.peek();
        ActionContext acContext = new ActionContext();
        acContext.setDisableGloableContext(true);
        acContext.put(str_acContext, (Object)actionContext);
        acContext.put(str_parentContext, (Object)actionContext);
        acContext.put(str_action, (Object)action);
        acContext.put(str_actionThing, (Object)action.getThing());
        acContext.getScope(0).setCaller(context, "init");
        Object inheritObj = null;
        boolean needInherit = context.getBoolean("inherit");
        if (needInherit) {
            inheritObj = context.doAction("inherit", acContext);
        }
        if (inheritObj != null && inheritObj instanceof ActionContext) {
            bindings.getContexts().put(context, inheritObj);
        } else {
            bindings.getContexts().put(context, acContext);
            context.doAction("init", acContext);
        }
    }

    public String getCompileClassPath() {
        return this.getThing().getMetadata().getCategory().getClassLoader().getCompileClassPath();
    }

    public static String getClassName(String className) {
        String[] cns = className.split("[.]");
        String cName = "";
        for (int i = 0; i < cns.length; ++i) {
            for (int n = 0; n < javaKeyWords.length; ++n) {
                if (!cns[i].equals(javaKeyWords[n])) continue;
                cns[i] = "t" + cns[i];
                break;
            }
            cns[i] = cns[i].replaceAll("(-)", "_");
            cns[i] = cns[i].replace(' ', '_');
            cName = cName.length() == 0 ? cns[i] : cName + "." + cns[i];
        }
        return cName;
    }

    public void setData(String key, Object data) {
        this.userData.put(key, data);
    }

    public Object getData(String key) {
        return this.userData.get(key);
    }

    public Thing getThing() {
        return this.thingEntry.getThing();
    }

    public boolean isNeedRecompile() {
        this.initClassAndCode();
        long time = this.getClassCompileTime(this.thingEntry.getThing(), this.classFileName);
        return time != this.lastModified;
    }

    private long getClassCompileTime(Thing thing, String classFileName) {
        this.initClassAndCode();
        if (thing.getMetadata().getThingManager() instanceof ClassThingManager) {
            try {
                this.actionClass = this.getClassLoader().loadClass(this.className);
                if (this.actionClass != null) {
                    return this.lastModified;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        File file = new File(classFileName);
        String path = file.getParentFile().getAbsolutePath();
        ClassCompileTimeFile timeFile = Action.getClassCompileTimeFile(path);
        return timeFile.getTime(this.className);
    }

    public static void updateClassCompileTime(String classFileName, String className, long time) {
        File file = new File(classFileName);
        String path = file.getParentFile().getAbsolutePath();
        ClassCompileTimeFile timeFile = Action.getClassCompileTimeFile(path);
        timeFile.updateTime(className, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassCompileTimeFile getClassCompileTimeFile(String path) {
        Map<String, SoftReference<ClassCompileTimeFile>> map = classTimeFiles;
        synchronized (map) {
            SoftReference<ClassCompileTimeFile> fileRef = classTimeFiles.get(path);
            ClassCompileTimeFile file = null;
            if (fileRef != null) {
                file = fileRef.get();
            }
            if (file == null) {
                file = new ClassCompileTimeFile(path);
                fileRef = new SoftReference<ClassCompileTimeFile>(file);
                classTimeFiles.put(path, fileRef);
            }
            return file;
        }
    }

    public static int getThrowableRecordCount() {
        return throwableRecordCount;
    }

    public static void setThrowableRecordCount(int throwableRecordCount) {
        Action.throwableRecordCount = throwableRecordCount;
    }

    public static List<ThrowableRecord> getThrowables() {
        return throwables;
    }

    public Class<?> getActionClass() {
        this.initClassAndCode();
        return this.actionClass;
    }

    public void setActionClass(Class<?> actionClass) {
        this.actionClass = actionClass;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isJava() {
        return this.isJava;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getOtherActionPath() {
        return this.otherActionPath;
    }

    public String getClassName() {
        this.initClassAndCode();
        return this.className;
    }

    public String getClassFileName() {
        this.initClassAndCode();
        return this.classFileName;
    }

    public String getPackageName() {
        this.initClassAndCode();
        return this.packageName;
    }

    public String getFileName() {
        this.initClassAndCode();
        return this.fileName;
    }

    public String getCode() {
        this.initClassAndCode();
        return this.code;
    }

    public Action getOuterAction() {
        return this.outerAction;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    private synchronized void initClassAndCode() {
        String cName;
        String fileManagerName;
        if (this.codeInited) {
            return;
        }
        this.codeInited = true;
        Thing thing = this.thingEntry.getThing();
        Thing parent = thing.getParent();
        Thing rootParent = thing.getRoot();
        if (parent == null) {
            parent = thing;
        }
        fileManagerName = (fileManagerName = thing.getMetadata().getThingManager().getName()) == null ? "null" : UtilString.trimFileName(fileManagerName);
        this.className = rootParent.getMetadata().getPath();
        if (rootParent != thing) {
            this.className = this.className + ".p" + thing.getMetadata().getPath().hashCode();
            this.className = this.className.replace('-', '_');
        }
        this.className = (cName = thing.getString("className")) == null || "".equals(cName) ? this.className + "." + thing.getMetadata().getName() : this.className + "." + cName;
        this.className = Action.getClassName(this.className);
        int dotIndex = this.className.lastIndexOf(".");
        if (dotIndex != -1) {
            this.packageName = this.className.substring(0, dotIndex);
        }
        this.fileName = fileManagerName + "/" + this.className.replace('.', '/');
        this.classLoader = null;
        this.fileName = World.getInstance().getPath() + "/work/actionSources/" + this.fileName;
        this.classFileName = World.getInstance().getPath() + "/work/actionClasses/" + fileManagerName + "/" + this.className.replace('.', '/') + ".class";
        this.code = thing.getString("code");
        if (this.code == null) {
            this.code = "";
        }
        this.methodName = thing.getString("methodName");
    }

    public static class ThrowableRecord {
        public Throwable throwable;
        public String actionStackTrace;
        public Date date;
        public String threadName;

        public ThrowableRecord(Throwable throwable, ActionContext actionContext) {
            this.throwable = throwable;
            this.actionStackTrace = actionContext.getStackTrace();
            this.date = new Date();
            this.threadName = Thread.currentThread().getName();
        }
    }

    static class ActionResult {
        String name;
        String runType;
        String condition;
        ThingEntry resultObj;

        public ActionResult(Thing resultObj) {
            this.name = resultObj.getMetadata().getName();
            this.runType = resultObj.getString("type");
            this.resultObj = new ThingEntry(resultObj);
            this.condition = resultObj.getString("condition");
        }

        public Object run(ActionContext actionContext) throws Exception {
            Thing resultThing = this.resultObj.getThing();
            if (resultThing == null) {
                return null;
            }
            List<Thing> rchilds = resultThing.getAllChilds();
            if (this.runType != null && this.runType.startsWith("RANDOM")) {
                Collections.shuffle(rchilds, new Random(System.currentTimeMillis()));
            }
            ArrayList<Rate> rates = null;
            Random random = new Random();
            int maxRate = 0;
            if ("RANDOM_RATE".equals(this.runType)) {
                rates = new ArrayList<Rate>();
                for (Thing child : rchilds) {
                    int rate = 1;
                    try {
                        rate = child.getInt("rate");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (rate <= 0) {
                        rate = 1;
                    }
                    Rate r = new Rate();
                    r.minRate = maxRate;
                    r.maxRate = maxRate += rate;
                    rates.add(r);
                }
            }
            int runCount = rchilds.size() > 0 ? random.nextInt(rchilds.size()) : 0;
            int count = 0;
            Object result = null;
            while (count < rchilds.size()) {
                int sint;
                Exception aexception = null;
                boolean successed = false;
                Thing data = rchilds.get(count);
                try {
                    if ("RANDOM_RATE".equals(this.runType)) {
                        int rate = random.nextInt(maxRate);
                        Rate r = (Rate)rates.get(count);
                        if (r.minRate > rate || r.maxRate <= rate) continue;
                    }
                    if ((result = data.getAction().run(actionContext, null, true)) instanceof String) {
                        if ("success".equals(result)) {
                            successed = true;
                        }
                    } else {
                        successed = true;
                    }
                }
                catch (Exception ee) {
                    aexception = ee;
                }
                if (successed) {
                    if ("SUCCESS".equals(this.runType) || "RANDOM_SUCCESS".equals(this.runType)) {
                        break;
                    }
                } else if ("SUCCESS".equals(this.runType) || "RANDOM_SUCCESS".equals(this.runType)) {
                    if (aexception != null) {
                        log.log(Level.WARNING, "run script method", aexception);
                    }
                } else if (aexception != null) {
                    throw aexception;
                }
                if ("RANDOM_RATE".equals(this.runType) || "RANDOM_ONE".equals(this.runType) || "RANDOM_RANDOM".equals(this.runType) && runCount == count || (sint = actionContext.getStatus()) == 1 || sint == 3 || sint == 4) break;
                if (sint == 2) {
                    actionContext.setStatus(0);
                    break;
                }
                ++count;
            }
            return result;
        }
    }

    static class Rate {
        int minRate;
        int maxRate;

        Rate() {
        }
    }

    static class ClassCompileTimeFile {
        Map<String, Long> classTimes = new HashMap<String, Long>();
        String timeFileName = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClassCompileTimeFile(String path) {
            File file = new File(path);
            File timeFile = new File(file, "_classTime.txt");
            this.timeFileName = timeFile.getAbsolutePath();
            if (timeFile.exists()) {
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(timeFile);
                    BufferedReader br = new BufferedReader(new InputStreamReader(fin));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        String[] strs;
                        if ("".equals(line = line.trim()) || (strs = line.split("[|]")).length != 2) continue;
                        this.classTimes.put(strs[0], Long.parseLong(strs[1]));
                    }
                    br.close();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "init class compile time file error, " + this.timeFileName, e);
                }
                finally {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        public long getTime(String className) {
            Long time = this.classTimes.get(className);
            if (time != null) {
                return time;
            }
            return 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void updateTime(String className, long time) {
            this.classTimes.put(className, time);
            FileOutputStream fout = null;
            try {
                File file = new File(this.timeFileName);
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                }
                fout = new FileOutputStream(this.timeFileName);
                for (String key : this.classTimes.keySet()) {
                    Long ctime = this.classTimes.get(key);
                    fout.write((key + "|" + ctime + "\n").getBytes());
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "update class compile time file error, " + this.timeFileName, e);
            }
            finally {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

