/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.codes;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmeta.Thing;
import org.xmeta.ThingMetadata;
import org.xmeta.util.UtilString;

public class PropertyCoder {
    public static final char TYPE_LASTMODIFIED = '%';
    public static final char TYPE_NODE = '@';
    public static final char TYPE_STRING = 's';
    public static final char TYPE_STRINGS = 'S';
    public static final char TYPE_BIGDECIMAL = 'D';
    public static final char TYPE_BIGINTEGER = 'I';
    public static final char TYPE_BOOLEAN = 'L';
    public static final char TYPE_BYTE = 'b';
    public static final char TYPE_BYTES = 'B';
    public static final char TYPE_INT = 'i';
    public static final char TYPE_DOUBLE = 'd';
    public static final char TYPE_FLOAT = 'f';
    public static final char TYPE_CHAR = 'c';
    public static final char TYPE_SHORT = 'h';
    public static final char TYPE_OBJECT = 'o';
    public static final char TYPE_DATE = 't';
    public static final char TYPE_LONG = 'l';
    public static final String STRING_ENCODING = "UTF-8";
    private static final String STRING_TAG = "#$@text#$@";

    public static void encode(Thing thing, PrintWriter out, Map<Thing, String> context) throws IOException {
        PropertyCoder.encode(thing, out, context, "");
    }

    private static void encode(Thing thing, PrintWriter out, Map<Thing, String> context, String ident) throws IOException {
        if (context == null) {
            context = new HashMap<Thing, String>();
        }
        if (context.get(thing) != null) {
            return;
        }
        context.put(thing, "aaa");
        ThingMetadata meta = thing.getMetadata();
        if (thing.getParent() == null || ident == null || ident.equals("")) {
            out.print(ident);
            out.println('%' + String.valueOf(meta.getLastModified()));
        }
        String rootPath = thing.getRoot().getMetadata().getPath();
        String path = meta.getPath();
        out.print(ident);
        out.println('@' + path.substring(rootPath.length(), path.length()));
        List<Thing> fields = thing.getAllAttributesDescriptors();
        if (thing.getString("name") == null || "".equals(thing.getString("name"))) {
            thing.put("name", thing.getMetadata().getName());
        }
        boolean idSetted = false;
        boolean descriptorsSetted = false;
        boolean nameSetted = false;
        boolean labelSetted = false;
        HashMap<String, String> atrContext = new HashMap<String, String>();
        for (Thing field : fields) {
            String name = field.getMetadata().getName();
            if (atrContext.get(name) != null) continue;
            atrContext.put(name, name);
            String type = field.getString("type");
            if (name.equals("url")) {
                // empty if block
            }
            if (!idSetted && "id".equals(name)) {
                idSetted = true;
            }
            if (!descriptorsSetted && "descriptors".equals(name)) {
                descriptorsSetted = true;
            }
            if (!nameSetted && "name".equals(name)) {
                nameSetted = true;
            }
            if (!labelSetted && "label".equals(name)) {
                labelSetted = true;
            }
            if ("int".equals(type)) {
                try {
                    int value = thing.getInt(name);
                    PropertyCoder.encodeName(out, name, 'i', ident);
                    out.println(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("long".equals(type)) {
                try {
                    long value = thing.getLong(name);
                    PropertyCoder.encodeName(out, name, 'l', ident);
                    out.println(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("double".equals(type)) {
                try {
                    double value = thing.getDouble(name);
                    PropertyCoder.encodeName(out, name, 'd', ident);
                    out.println(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("float".equals(type)) {
                try {
                    float value = thing.getFloat(name);
                    PropertyCoder.encodeName(out, name, 'f', ident);
                    out.println(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("bigDecimal".equals(type)) {
                try {
                    BigDecimal value = thing.getBigDecimal(name);
                    if (value == null) continue;
                    PropertyCoder.encodeName(out, name, 'D', ident);
                    out.println(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("bigInteger".equals(type)) {
                try {
                    BigInteger value = thing.getBigInteger(name);
                    if (value == null) continue;
                    PropertyCoder.encodeName(out, name, 'I', ident);
                    out.println(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("boolean".equals(type)) {
                try {
                    boolean value = thing.getBoolean(name);
                    PropertyCoder.encodeName(out, name, 'L', ident);
                    out.println(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("byte".equals(type)) {
                try {
                    byte value = thing.getByte(name);
                    PropertyCoder.encodeName(out, name, 'b', ident);
                    out.println(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("bytes".equals(type)) {
                try {
                    byte[] value = thing.getBytes(name);
                    PropertyCoder.encodeName(out, name, 'B', ident);
                    if (value != null) {
                        out.println(UtilString.toHexString(value));
                        continue;
                    }
                    out.println();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("char".equals(type)) {
                try {
                    char value = thing.getChar(name);
                    PropertyCoder.encodeName(out, name, 'c', ident);
                    out.println(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("short".equals(type)) {
                try {
                    short value = thing.getShort(name);
                    PropertyCoder.encodeName(out, name, 'h', ident);
                    out.println(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("date".equals(type) || "datetime".equals(type) || "time".equals(type)) {
                try {
                    Date value = thing.getDate(name);
                    if (value == null) continue;
                    long dvalue = value.getTime();
                    PropertyCoder.encodeName(out, name, 't', ident);
                    out.println(dvalue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("object".equals(type)) {
                Object value = thing.getAttribute(name);
                if (value == null || !(value instanceof Serializable)) continue;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try {
                    ObjectOutputStream oout = new ObjectOutputStream(bout);
                    oout.writeObject(value);
                    oout.flush();
                    byte[] bs = bout.toByteArray();
                    PropertyCoder.encodeName(out, name, 'o', ident);
                    out.println(UtilString.toHexString(bs));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            String value = thing.getString(name);
            if (value == null) continue;
            PropertyCoder.encodeString(name, value, out, ident);
        }
        if (!idSetted) {
            PropertyCoder.encodeString("id", thing.getMetadata().getId(), out, ident);
        }
        if (!descriptorsSetted) {
            PropertyCoder.encodeString("descriptors", thing.getString("descriptors"), out, ident);
        }
        if (!nameSetted) {
            PropertyCoder.encodeString("name", thing.getMetadata().getName(), out, ident);
        }
        if (!labelSetted) {
            PropertyCoder.encodeString("label", thing.getMetadata().getLabel(), out, ident);
        }
        for (Thing child : thing.getChilds()) {
            if (child.getParent() != thing) continue;
            PropertyCoder.encode(child, out, context, ident + "  ");
        }
        out.flush();
    }

    protected static void encodeName(PrintWriter out, String name, char type, String ident) throws IOException {
        out.print(ident);
        out.print(type);
        out.print(name);
        out.print("=");
    }

    protected static void encodeString(String name, String value, PrintWriter out, String ident) throws IOException {
        if (value == null || "".equals(value)) {
            return;
        }
        if (value.indexOf("\n") != -1) {
            PropertyCoder.encodeName(out, name, 'S', ident);
            out.println();
            out.println(STRING_TAG);
            ByteArrayInputStream bin = new ByteArrayInputStream(value.getBytes());
            BufferedReader br = new BufferedReader(new InputStreamReader(bin));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.length() == STRING_TAG.length() && line.equals(STRING_TAG)) {
                    line = "\\" + line;
                }
                out.println(line);
            }
            br.close();
            bin.close();
            out.println(STRING_TAG);
        } else {
            PropertyCoder.encodeName(out, name, 's', ident);
            out.println(value);
        }
    }

    private static String getId(String path) {
        int index = path.lastIndexOf("@");
        if (index != -1) {
            return path.substring(index + 1, path.length());
        }
        index = path.lastIndexOf(".");
        if (index != -1) {
            return path.substring(index + 1, path.length());
        }
        return path;
    }

    public static Thing decode(Thing thing, InputStream input, boolean full, long lastModified) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(input, STRING_ENCODING));
        String line = null;
        String path = br.readLine().trim();
        if (path.charAt(0) == '\ufeff') {
            path = path.substring(1, path.length());
        }
        if ('%' == path.charAt(0)) {
            lastModified = Long.parseLong(path.substring(1, path.length()));
            path = br.readLine().trim();
        }
        if (path != null) {
            Thing current = thing;
            Map<String, Object> attributes = current.getAttributes();
            if ((path = path.substring(1, path.length())) != null && !"".equals(path)) {
                thing.getMetadata().setPath(path);
            }
            thing.getMetadata().setLastModified(lastModified);
            current.getMetadata().setId(PropertyCoder.getId(path));
            while ((line = br.readLine()) != null) {
                Object values;
                if ((line = line.trim()).length() == 0) continue;
                char type = line.charAt(0);
                String name = line.substring(1, line.length()).intern();
                if (type == '@') {
                    if (!full) break;
                    if ((current = PropertyCoder.getPathParent(current, name)) == null) continue;
                    Thing childThing = new Thing(null, null, null, false);
                    ThingMetadata childMetadata = childThing.getMetadata();
                    childMetadata.setPath(name);
                    childMetadata.setLastModified(lastModified);
                    childMetadata.setId(PropertyCoder.getId(name));
                    current.addChild(childThing);
                    current = childThing;
                    attributes = current.getAttributes();
                    continue;
                }
                int index = name.indexOf("=");
                String value = name.substring(index + 1, name.length());
                name = name.substring(0, index);
                if (type == 'i') {
                    try {
                        attributes.put(name, Integer.parseInt(value));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (type == 'l') {
                    try {
                        attributes.put(name, Long.parseLong(value));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (type == 'd') {
                    try {
                        attributes.put(name, Double.parseDouble(value));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (type == 'f') {
                    try {
                        attributes.put(name, Float.valueOf(Float.parseFloat(value)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (type == 'D') {
                    try {
                        attributes.put(name, new BigDecimal(value));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (type == 'I') {
                    try {
                        attributes.put(name, new BigInteger(value));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (type == 'L') {
                    try {
                        attributes.put(name, Boolean.parseBoolean(value));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (type == 'b') {
                    try {
                        attributes.put(name, Byte.parseByte(value));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (type == 'B') {
                    try {
                        values = UtilString.hexStringToByteArray(value);
                        attributes.put(name, values);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (type == 'c') {
                    try {
                        attributes.put(name, Character.valueOf((char)Integer.parseInt(value)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (type == 'h') {
                    try {
                        attributes.put(name, Short.parseShort(value));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (type == 't') {
                    try {
                        values = new Date(Long.parseLong(value));
                        attributes.put(name, values);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (type == 'o') {
                    String hexstring = value;
                    if (hexstring == null || "".equals(hexstring.trim())) continue;
                    try {
                        byte[] bytes = UtilString.hexStringToByteArray(hexstring);
                        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
                        ObjectInputStream oin = new ObjectInputStream(bin);
                        Object values2 = oin.readObject();
                        attributes.put(name, values2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (type == 'S') {
                    br.readLine();
                    String l = null;
                    value = null;
                    while ((l = br.readLine()) != null) {
                        if (l.length() == 1 && '\r' == l.charAt(0)) continue;
                        if (l.length() == STRING_TAG.length() && l.equals(STRING_TAG)) break;
                        if (l.length() == STRING_TAG.length() + 1 && l.equals("\\#$@text#$@")) {
                            if (value != null) {
                                value = value + "\n" + l.substring(1, l.length());
                                continue;
                            }
                            value = l.substring(1, l.length());
                            continue;
                        }
                        if (value != null) {
                            value = value + "\n" + l;
                            continue;
                        }
                        value = l;
                    }
                    attributes.put(name, value);
                    continue;
                }
                if (type != 's') continue;
                attributes.put(name, value);
            }
        }
        return thing;
    }

    private static Thing getPathParent(Thing current, String path) {
        String subpath;
        String currentPath = current.getMetadata().getPath();
        if (path == null || "".equals(path)) {
            path = current.getRoot().getMetadata().getPath();
        } else if (path.startsWith("/@")) {
            path = current.getRoot().getMetadata().getPath() + path;
        }
        if (path.startsWith(currentPath + "/") && (subpath = path.substring(currentPath.length(), path.length())).lastIndexOf("/") == 0) {
            return current;
        }
        if ((current = current.getParent()) == null) {
            return null;
        }
        return PropertyCoder.getPathParent(current, path);
    }
}

