/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import org.xmeta.ActionContext;
import org.xmeta.Thing;
import org.xmeta.annotation.ActionField;

public class ThingLoader {
    private static final Logger logger = Logger.getLogger(ThingLoader.class.getName());
    private static final ThreadLocal<Stack<Object>> objectLocal = new ThreadLocal();

    public static void push(Object object) {
        Stack<Object> stack = objectLocal.get();
        if (stack == null) {
            stack = new Stack();
            objectLocal.set(stack);
        }
        stack.push(object);
    }

    public static void pop() {
        Stack<Object> stack = objectLocal.get();
        if (stack != null) {
            stack.pop();
        }
    }

    public static <T> T load(Object object, ActionContext actionContext, Class<? extends Annotation> ... annotations) {
        return ThingLoader.load(object, (Thing)null, actionContext, new Class[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T load(Object object, Thing thing, ActionContext actionContext, Class<? extends Annotation> ... annotations) {
        Stack<Object> stack = objectLocal.get();
        if (stack == null) {
            stack = new Stack();
            objectLocal.set(stack);
        }
        stack.push(object);
        T result = null;
        try {
            if (thing != null) {
                result = thing.doAction("create", actionContext);
            }
            ThingLoader.init(object, false, actionContext, annotations);
        }
        finally {
            stack.pop();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T load(Object object, List<Thing> things, ActionContext actionContext, Class<? extends Annotation> ... annotations) {
        Stack<Object> stack = objectLocal.get();
        if (stack == null) {
            stack = new Stack();
            objectLocal.set(stack);
        }
        stack.push(object);
        T result = null;
        try {
            for (Thing thing : things) {
                result = thing.doAction("create", actionContext);
            }
            ThingLoader.init(object, false, actionContext, annotations);
        }
        finally {
            stack.pop();
        }
        return result;
    }

    public static void init(Object object, boolean doInitMethod, ActionContext actionContext, Class<? extends Annotation> ... annotations) {
        ArrayList<Field> allFieldList = new ArrayList<Field>();
        for (Class<?> tempClass = object.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
            allFieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        block1: for (Field field : allFieldList) {
            ActionField actionField = field.getAnnotation(ActionField.class);
            if (actionField != null) {
                String name = field.getName();
                String vname = actionField.name();
                if ("".equals(vname)) {
                    vname = name;
                }
                ThingLoader.setFieldValue(object, field, vname, actionContext);
                continue;
            }
            if (annotations == null) continue;
            for (Class<? extends Annotation> annotationClass : annotations) {
                Annotation annotationField = field.getAnnotation(annotationClass);
                if (annotationField == null) continue;
                String name = field.getName();
                ThingLoader.setFieldValue(object, field, name, actionContext);
                continue block1;
            }
        }
        if (doInitMethod) {
            ThingLoader.init(object);
        }
    }

    public static void init(Object object) {
        if (object == null) {
            return;
        }
        try {
            Method method = object.getClass().getMethod("init", new Class[0]);
            method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            logger.warning("Execute init() mtehod  exception, " + e);
        }
    }

    public static void setFieldValues(Object object, Class<? extends Annotation> annotationClass, ActionContext actionContext) {
        ArrayList<Field> allFieldList = new ArrayList<Field>();
        for (Class<?> tempClass = object.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
            allFieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        for (Field field : allFieldList) {
            Annotation annotationField = field.getAnnotation(annotationClass);
            if (annotationField == null) continue;
            String name = field.getName();
            ThingLoader.setFieldValue(object, field, name, actionContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setFieldValue(Object object, Field field, String valueName, ActionContext actionContext) {
        if (valueName == null || "".equals(valueName)) {
            valueName = field.getName();
        }
        boolean accessChanged = false;
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
                accessChanged = true;
            }
            field.set(object, actionContext.get(valueName));
        }
        catch (IllegalAccessException e) {
            logger.warning("Set field value exception, field=" + field.getName() + ", valueName=" + valueName + ", " + e);
        }
        finally {
            if (accessChanged) {
                field.setAccessible(false);
            }
        }
    }

    public static Object getObject() {
        Stack<Object> stack = objectLocal.get();
        if (stack != null && stack.size() > 0) {
            return stack.peek();
        }
        return null;
    }

    public static Object getObjectForLoad(Thing thing, ActionContext actionContext) {
        Object objectForLoad = thing.doAction("getObjectForLoad", actionContext);
        if (objectForLoad != null) {
            return objectForLoad;
        }
        Class objectForLoadClass = (Class)thing.doAction("getObjectForLoadClass", actionContext);
        if (objectForLoadClass != null) {
            try {
                return objectForLoadClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.warning("NewInstance error, thing=" + thing.getMetadata().getPath() + ", " + e);
            }
        }
        return null;
    }

    public static Object create(ActionContext actionContext) {
        Thing self = (Thing)actionContext.getObject("self");
        Object objectForLoad = ThingLoader.getObjectForLoad(self, actionContext);
        Object result = null;
        if (objectForLoad != null) {
            result = ThingLoader.load(objectForLoad, self.getChilds(), actionContext, new Class[0]);
            if (self.getBoolean("init")) {
                ThingLoader.init(objectForLoad);
            }
        } else {
            for (Thing child : self.getChilds()) {
                result = child.doAction("create", actionContext);
            }
        }
        actionContext.g().put(self.getMetadata().getName(), objectForLoad);
        return result;
    }
}

