/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.codes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xmeta.Thing;
import org.xmeta.ThingCoderException;
import org.xmeta.cache.ThingCache;
import org.xmeta.codes.CoderUtils;
import org.xmeta.util.UtilData;
import org.xml.sax.SAXException;

public class XmlCoder {
    public static final String NODE_NAME = "__node__name__";
    public static final String NEW_LINE = "\n";

    public static String encodeToString(Thing thing) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            XmlCoder.encode(thing, bout);
            String string = new String(bout.toByteArray());
            return string;
        }
        catch (Exception e) {
            System.out.println(bout.toString());
            throw new ThingCoderException(e);
        }
        finally {
            try {
                bout.close();
            }
            catch (IOException e) {
                throw new ThingCoderException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encode(Thing thing, OutputStream out) throws XMLStreamException, IOException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try (XMLStreamWriter writer = factory.createXMLStreamWriter(out, "utf-8");){
            writer.writeStartDocument("utf-8", "1.0");
            writer.writeCharacters(NEW_LINE);
            XmlCoder.encode(thing, null, writer, "", false, out);
            writer.writeEndDocument();
        }
    }

    public static String encodeToString(Thing thing, boolean includeDefaultValue) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            XmlCoder.encode(thing, bout, includeDefaultValue);
            String string = new String(bout.toByteArray());
            return string;
        }
        catch (Exception e) {
            throw new ThingCoderException(e);
        }
        finally {
            try {
                bout.close();
            }
            catch (IOException e) {
                throw new ThingCoderException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encode(Thing thing, OutputStream out, boolean includeDefaultValue) throws XMLStreamException, IOException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try (XMLStreamWriter writer = factory.createXMLStreamWriter(out, "utf-8");){
            writer.writeStartDocument("utf-8", "1.0");
            writer.writeCharacters(NEW_LINE);
            XmlCoder.encode(thing, null, writer, "", includeDefaultValue, out);
            writer.writeEndDocument();
        }
    }

    private static void encode(Thing thing, Thing parentDescriptors, XMLStreamWriter writer, String ident, boolean includeDefaultValue, OutputStream out) throws XMLStreamException, IOException {
        int lineStartIndex;
        writer.writeCharacters(NEW_LINE + ident);
        HashMap<String, String> attrContext = new HashMap<String, String>();
        String thingName = thing.getThingName();
        if (thingName.startsWith("#")) {
            thingName = thingName.replace('#', '_');
        }
        writer.writeStartElement(thingName);
        int lineWidth = lineStartIndex = ident.length() + 4;
        String name = thing.getMetadata().getName();
        if (!name.equals(thingName) || thing.getChilds().size() == 0) {
            writer.writeAttribute("name", name);
            lineWidth = lineWidth + name.length() + 8;
        }
        attrContext.put("name", name);
        String id = thing.getMetadata().getId();
        if (!(includeDefaultValue || id == null || "".equals(id) || id.equals(name))) {
            writer.writeAttribute("_xmeta_id_", id);
            lineWidth = lineWidth + id.length() + 15;
        }
        boolean writeDescriptor = true;
        String descriptors = thing.getString("descriptors");
        Thing descriptor = thing.getDescriptor();
        if (parentDescriptors != null && descriptors != null && descriptors.split("[,]").length == 1) {
            for (Thing parentDescriptor : parentDescriptors.getAllChilds("thing")) {
                if (!parentDescriptor.getMetadata().getName().equals(thingName)) continue;
                if (!descriptor.getMetadata().getPath().equals(parentDescriptor.getMetadata().getPath())) break;
                writeDescriptor = false;
                break;
            }
        }
        if (writeDescriptor && descriptors != null) {
            writer.writeAttribute("descriptors", descriptors);
            lineWidth = lineWidth + descriptors.length() + 15;
        }
        attrContext.put("descriptors", descriptors);
        List<Thing> attributes = thing.getAllAttributesDescriptors();
        ArrayList<Thing> cDataAttributes = new ArrayList<Thing>();
        SimpleDateFormat dateFormater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (Thing attribute : attributes) {
            String attrname = attribute.getMetadata().getName();
            if (attrContext.get(attrname) != null) continue;
            attrContext.put(attrname, attrname);
            Object value = thing.getAttribute(attrname);
            String defaultValue = attribute.getStringBlankAsNull("default");
            if (defaultValue == null && (value == null || "".equals(value)) || defaultValue != null && CoderUtils.isDefault(attribute, value == null ? null : value.toString())) continue;
            if (value == null) {
                value = "";
            }
            if (includeDefaultValue) {
                defaultValue = null;
            }
            if ("label".equals(attrname) && name.equals(value)) continue;
            boolean isCdata = false;
            String type = attribute.getString("type");
            String strValue = null;
            if ("__PCDATA__".equals(attrname) || "__CDATA__".equals(attrname)) {
                cDataAttributes.add(attribute);
                isCdata = true;
            } else if ("int".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("long".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("double".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("float".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("bigDecimal".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("bigInteger".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("boolean".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("byte".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("bytes".equals(type)) {
                byte[] bytes = thing.getBytes(attrname);
                strValue = UtilData.bytesToHexString(bytes);
            } else if ("char".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("short".equals(type)) {
                strValue = String.valueOf(value);
            } else if ("date".equals(type)) {
                Date date = thing.getDate(attrname);
                strValue = dateFormater.format(date);
            } else if ("object".equals(type)) {
                if (value instanceof Serializable) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    ObjectOutputStream oout = new ObjectOutputStream(bout);
                    oout.writeObject(value);
                    oout.flush();
                    byte[] bs = bout.toByteArray();
                    strValue = UtilData.bytesToHexString(bs);
                }
            } else {
                strValue = String.valueOf(value);
                if (strValue.indexOf(NEW_LINE) != -1) {
                    cDataAttributes.add(attribute);
                    isCdata = true;
                }
            }
            if (isCdata) continue;
            if (strValue != null) {
                if (!includeDefaultValue && CoderUtils.isDefault(attribute, strValue)) continue;
                if (lineWidth > 80) {
                    writer.flush();
                    out.write(NEW_LINE.getBytes());
                    out.write((ident + "    ").getBytes());
                    lineWidth = lineStartIndex;
                }
                writer.writeAttribute(attrname, strValue);
                lineWidth = lineWidth + attrname.length() + strValue.length() + 3;
                continue;
            }
            if (defaultValue == null || "".equals(defaultValue)) continue;
            if (lineWidth > 80) {
                writer.flush();
                out.write(NEW_LINE.getBytes());
                out.write((ident + "    ").getBytes());
                lineWidth = lineStartIndex;
            }
            writer.writeAttribute(attrname, "");
            lineWidth = lineWidth + attrname.length() + 3;
        }
        String xmlns = thing.getStringBlankAsNull("xmlns");
        String xmlns_xsi = thing.getStringBlankAsNull("xmlns:xsi");
        String schemaLocation = thing.getStringBlankAsNull("xsi:schemaLocation");
        if (xmlns != null) {
            writer.writeAttribute("xmlns", xmlns);
        }
        if (xmlns_xsi != null) {
            writer.writeAttribute("xmlns:xsi", xmlns_xsi);
        }
        if (schemaLocation != null) {
            writer.writeAttribute("xsi:schemaLocation", schemaLocation);
        }
        for (Thing attribute : cDataAttributes) {
            String attrname = attribute.getMetadata().getName();
            String str = thing.getString(attrname);
            writer.writeCharacters(NEW_LINE + ident + "    ");
            writer.writeStartElement(attrname);
            writer.writeCData(str.replaceAll("\\]\\]>", "_xmeta_cdata_tag_"));
            writer.writeEndElement();
        }
        for (Thing child : thing.getChilds()) {
            XmlCoder.encode(child, descriptor, writer, ident + "    ", includeDefaultValue, out);
        }
        if (cDataAttributes.size() > 0 || thing.getChilds().size() > 0) {
            writer.writeCharacters(NEW_LINE + ident);
        }
        writer.writeEndElement();
    }

    public static void parse(Thing thing, String content) throws ParserConfigurationException, SAXException, IOException {
        XmlCoder.parse(thing, null, content);
    }

    public static void parse(Thing thing, Thing descriptor, String content) throws ParserConfigurationException, SAXException, IOException {
        if (content == null) {
            return;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(content.getBytes("UTF-8"));
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.parse(bis);
        Element root = document.getDocumentElement();
        ThingCache.put(thing.getMetadata().getPath(), thing);
        XmlCoder.parse(thing, descriptor, root, System.currentTimeMillis());
        XmlCoder.initDefaultValues(thing);
        XmlCoder.setLastModified(thing, System.currentTimeMillis());
    }

    public static void parse(Thing thing, InputStream input) throws SAXException, IOException, ParserConfigurationException {
        XmlCoder.parse(thing, null, input);
    }

    public static void parse(Thing thing, Thing descriptor, InputStream input) throws SAXException, IOException, ParserConfigurationException {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.parse(input);
        Element root = document.getDocumentElement();
        ThingCache.put(thing.getMetadata().getPath(), thing);
        XmlCoder.parse(thing, descriptor, root, System.currentTimeMillis());
        XmlCoder.initDefaultValues(thing);
        XmlCoder.setLastModified(thing, System.currentTimeMillis());
    }

    public static void initDefaultValues(Thing thing) {
        thing.initDefaultValue();
        for (Thing child : thing.getChilds()) {
            XmlCoder.initDefaultValues(child);
        }
    }

    public static void parse(Thing thing, Thing parentDescriptor, Element element, long lastModifyed) {
        Map<String, Object> attributes = thing.getAttributes();
        String thingName = element.getNodeName();
        String descriptors = element.getAttribute("descriptors");
        if (descriptors != null && !"".equals(descriptors.trim())) {
            attributes.put("descriptors", descriptors);
        } else if (parentDescriptor != null) {
            for (Thing descriptor : parentDescriptor.getAllChilds("thing")) {
                if (!thingName.equals(descriptor.getMetadata().getName())) continue;
                descriptors = descriptor.getMetadata().getPath();
                break;
            }
            if (descriptors != null) {
                attributes.put("descriptors", descriptors);
            }
        }
        descriptors = (String)attributes.get("descriptors");
        if (descriptors == null || descriptors.equals("")) {
            if ("actions".equals(thingName)) {
                attributes.put("descriptors", "MetaThing/@actions");
            } else if ("JavaAction".equals(thingName)) {
                attributes.put("descriptors", "MetaThing/@actions/@JavaAction");
            } else {
                attributes.put("descriptors", "MetaThing");
            }
        }
        NamedNodeMap nodes = element.getAttributes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node attributeNode = nodes.item(i);
            if ("descriptors".equals(attributeNode.getNodeName())) continue;
            attributes.put(attributeNode.getNodeName(), attributeNode.getNodeValue());
            attributes.put(NODE_NAME, attributeNode.getNodeValue());
        }
        Node node = element.getFirstChild();
        if (node != null) {
            do {
                if (node.getNodeType() != 1) continue;
                if (XmlCoder.isAttributeNode(node)) {
                    Node childNode = node.getFirstChild();
                    if (childNode.getNodeType() != 3 && childNode.getNodeType() != 4) continue;
                    String value = childNode.getNodeValue();
                    if (value != null) {
                        value = value.replaceAll("_xmeta_cdata_tag_", "\\]\\]>");
                    }
                    attributes.put(node.getNodeName().intern(), value);
                    continue;
                }
                Thing child = new Thing(null, null, null, false);
                child.setParent(thing);
                XmlCoder.parse(child, thing.getDescriptor(), (Element)node, lastModifyed);
                thing.addChild(child);
            } while ((node = node.getNextSibling()) != null);
        }
        attributes.putIfAbsent("name", thingName);
        if (attributes.get("_xmeta_id_") != null) {
            thing.getMetadata().setId(attributes.get("_xmeta_id_").toString());
        } else {
            thing.getMetadata().setId((String)attributes.get("name"));
        }
        thing.getMetadata().setLastModified(lastModifyed);
    }

    public static boolean isAttributeNode(Node node) {
        Node childNode;
        return node.getNodeType() == 1 && ((Element)node).getAttributes().getLength() == 0 && node.getChildNodes().getLength() == 1 && ((childNode = node.getFirstChild()).getNodeType() == 4 || childNode.getNodeType() == 3);
    }

    public static void setLastModified(Thing thing, long lastModified) {
        for (Thing child : thing.getChilds()) {
            XmlCoder.setLastModified(child, lastModified);
        }
        thing.getMetadata().setLastModified(lastModified);
    }
}

