/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xmeta.Category;
import org.xmeta.Index;
import org.xmeta.Thing;
import org.xmeta.ThingManager;
import org.xmeta.World;
import org.xmeta.XMetaException;
import org.xmeta.util.RefactorListener;

public class RefactorUtil {
    private static RefactorUtil instance = new RefactorUtil();

    private RefactorUtil() {
    }

    public static RefactorUtil getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refactor(String sourcePath, String targetPath, RefactorListener listener) {
        try {
            World world = World.getInstance();
            String[] sourcePaths = sourcePath.split("[:]");
            String[] targetPaths = targetPath.split("[:]");
            ThingManager sourceThingManager = world.getThingManager(sourcePaths[0]);
            ThingManager targetThingManager = world.getThingManager(targetPaths[0]);
            if (sourceThingManager == null) {
                throw new XMetaException("Source ThingManager is null, nmae=" + sourcePaths[0]);
            }
            if (targetThingManager == null) {
                throw new XMetaException("Target ThingManager is nul, name=" + targetPaths[0]);
            }
            Object source = sourceThingManager.getThing(sourcePaths[1]);
            if (source == null) {
                source = sourceThingManager.getCategory(sourcePaths[1]);
            }
            if (source == null) {
                throw new XMetaException("Source is not exists, path=" + sourcePath);
            }
            int count = 0;
            if (source instanceof Thing) {
                String targetCategory;
                Thing thing = (Thing)source;
                Thing target = targetThingManager.getThing(targetPaths[1]);
                if (target != null) {
                    throw new XMetaException("Target '" + targetPath + "' is already exists.");
                }
                count = 2;
                Index index = Index.getInstance();
                count += RefactorUtil.getThingCount(index, new HashMap<String, String>());
                if (listener != null) {
                    listener.onStart(count);
                }
                if ((targetCategory = targetPaths[1]).lastIndexOf(".") != -1) {
                    targetCategory = targetCategory.substring(0, targetCategory.lastIndexOf("."));
                }
                thing.copyTo(targetPaths[0], targetCategory);
                if (listener != null) {
                    listener.onCopy(sourcePaths[0], targetPaths[1]);
                }
                RefactorUtil.replaceAll(sourcePaths[1], targetPaths[1], listener);
                thing.remove();
                if (listener != null) {
                    listener.onDelete(sourcePath);
                }
            } else {
                Category srcCategory = (Category)source;
                Category target = targetThingManager.getCategory(targetPaths[1]);
                if (target != null) {
                    throw new XMetaException("Target category '" + targetPath + "' already exists.");
                }
                Iterator<Thing> iter = srcCategory.iterator(true);
                while (iter.hasNext()) {
                    ++count;
                    iter.next();
                }
                Index index = Index.getInstance();
                count += RefactorUtil.getThingCount(index, new HashMap<String, String>());
                if (listener != null) {
                    listener.onStart(count);
                }
                Iterator<Thing> iter2 = srcCategory.iterator(true);
                while (iter2.hasNext()) {
                    Thing tarThing = iter2.next();
                    String srcThingCategory = tarThing.getMetadata().getCategory().getName();
                    String tarThingCategory = srcThingCategory.substring(sourcePaths[1].length(), srcThingCategory.length());
                    if (tarThingCategory.startsWith(".")) {
                        tarThingCategory = tarThingCategory.substring(1, tarThingCategory.length());
                    }
                    if (!"".equals(tarThingCategory)) {
                        if (!"".equals(targetPaths[1])) {
                            tarThingCategory = targetPaths[1] + "." + tarThingCategory;
                        }
                    } else {
                        tarThingCategory = targetPaths[1];
                    }
                    tarThing.copyTo(targetPaths[0], tarThingCategory);
                    if (listener == null) continue;
                    listener.onCopy(tarThing.getMetadata().getPath(), tarThingCategory + "." + tarThing.getMetadata().getName());
                }
                RefactorUtil.replaceAll(sourcePaths[1], targetPaths[1], listener);
                iter2 = srcCategory.iterator(true);
                while (iter2.hasNext()) {
                    Thing thing = iter2.next();
                    thing.remove();
                    if (listener == null) continue;
                    listener.onDelete(thing.getMetadata().getPath());
                }
                srcCategory.getThingManager().removeCategory(srcCategory.getName());
            }
        }
        finally {
            if (listener != null) {
                listener.finish();
            }
        }
    }

    private static int getThingCount(Index index, Map<String, String> context) {
        int count = 0;
        if (index.getType().equals("thing")) {
            return 1;
        }
        if (index.getType().equals("thingManager")) {
            if (context.get(index.getName()) != null) {
                return 0;
            }
            context.put(index.getName(), index.getName());
        }
        if (index.getChilds() == null) {
            index.refresh();
        }
        if (index.getChilds() != null) {
            for (Index child : index.getChilds()) {
                count += RefactorUtil.getThingCount(child, context);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceAll(String replaceFor, String replaceWidth, RefactorListener listener) {
        World world = World.getInstance();
        try {
            for (ThingManager thingManager : world.getThingManagers()) {
                listener.notMidify(thingManager.getName());
                RefactorUtil.replaceThingManager(thingManager, replaceFor, replaceWidth, listener);
            }
        }
        finally {
            if (listener != null) {
                listener.finish();
            }
        }
    }

    private static void replaceThingManager(ThingManager tm, String replaceFor, String replaceWidth, RefactorListener listener) {
        tm.refresh();
        Iterator<Thing> iter = tm.iterator("", true);
        while (iter.hasNext()) {
            Thing thing = iter.next();
            if (thing.getMetadata().getPath().startsWith(replaceFor)) {
                // empty if block
            }
            if (RefactorUtil.replaceThing(thing, replaceFor, replaceWidth, listener)) {
                thing.getMetadata().setLastModified(System.currentTimeMillis());
                thing.save();
                if (listener == null) continue;
                listener.onUpdated(thing.getMetadata().getPath());
                continue;
            }
            if (listener == null) continue;
            listener.notMidify(thing.getMetadata().getPath());
        }
    }

    private static boolean replaceThing(Thing thing, String replaceFor, String replaceWith, RefactorListener listener) {
        Map<String, Object> attrs = thing.getAttributes();
        boolean updated = false;
        for (String key : attrs.keySet()) {
            Object value = attrs.get(key);
            if (value == null || !(value instanceof String)) continue;
            String str = (String)value;
            boolean have = str.indexOf(replaceFor) != -1;
            updated |= have;
            if (!have) continue;
            thing.getAttributes().put(key, str.replaceAll("(" + replaceFor + ")", replaceWith));
        }
        for (Thing child : thing.getChilds()) {
            updated |= RefactorUtil.replaceThing(child, replaceFor, replaceWith, listener);
        }
        return updated;
    }

    public static void changeOldPathToNewRule(RefactorListener listener) {
        World world = World.getInstance();
        ArrayList<Index> thingIndexs = new ArrayList<Index>();
        RefactorUtil.getAllThingIndexs(thingIndexs, Index.getInstance());
        for (Index index : thingIndexs) {
            String path = index.getPath();
            Thing thing = world.getThing(path);
            if (!RefactorUtil.changeOldNameToNew(thing)) continue;
            thing.save();
        }
    }

    private static boolean changeOldNameToNew(Thing thing) {
        Map<String, Object> attrs = thing.getAttributes();
        boolean updated = false;
        for (String key : attrs.keySet()) {
            Object value = attrs.get(key);
            if (value == null || !(value instanceof String)) continue;
            String newValue = null;
            String str = (String)value;
            for (String line : str.split("[\n]")) {
                String[] sp = line.split("[:]");
                String newLine = line;
                if (!(sp.length < 3 || sp[0].equals("jdbc") || sp[0].equals("http") || sp[1].equals("mm") || sp[1].indexOf(" ") != -1 || sp[1].equals("//") || "".equals(sp[2]))) {
                    for (int i = 0; i < sp.length; ++i) {
                        newLine = i == 0 ? sp[i] : (i < 3 ? newLine + "." + sp[i] : newLine + sp[i]);
                    }
                    System.out.println(line + " => " + newLine);
                    updated = true;
                }
                newValue = newValue == null ? newLine : newValue + "\n" + newLine;
            }
            if (!updated) continue;
            attrs.put(key, newValue);
        }
        for (Thing child : thing.getChilds()) {
            updated |= RefactorUtil.changeOldNameToNew(child);
        }
        return updated;
    }

    public static void getAllThingIndexs(List<Index> thingIndexs, Index index) {
        if (index.getType().equals("thing")) {
            thingIndexs.add(index);
        } else {
            for (Index child : index.getChilds()) {
                RefactorUtil.getAllThingIndexs(thingIndexs, child);
            }
        }
    }
}

