/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmeta.Action;
import org.xmeta.ActionContext;
import org.xmeta.ActionListener;
import org.xmeta.Category;
import org.xmeta.Help;
import org.xmeta.MetaThing;
import org.xmeta.Path;
import org.xmeta.Thing;
import org.xmeta.ThingCoder;
import org.xmeta.ThingManager;
import org.xmeta.ThingManagerListener;
import org.xmeta.ThingMetadata;
import org.xmeta.XMetaException;
import org.xmeta.annotation.ThingAnnotationUtils;
import org.xmeta.cache.ThingCache;
import org.xmeta.cache.ThingEntry;
import org.xmeta.codes.DmlThingCoder;
import org.xmeta.codes.DmwThingCoder;
import org.xmeta.codes.JsonThingCoder;
import org.xmeta.codes.PropertyThingCoder;
import org.xmeta.codes.TxtThingCoder;
import org.xmeta.codes.XerThingCoder;
import org.xmeta.codes.XmlThingCoder;
import org.xmeta.thingManagers.ClassThingManager;
import org.xmeta.thingManagers.FileMonitor;
import org.xmeta.thingManagers.FileThingManager;
import org.xmeta.thingManagers.JarThingManager;
import org.xmeta.thingManagers.TransientThingManager;
import org.xmeta.util.JarThingManagerIniter;
import org.xmeta.util.ThingClassLoader;
import org.xmeta.util.UtilFile;
import org.xmeta.util.UtilJava;

public class World {
    private static final Logger log = Logger.getLogger(World.class.getName());
    public static byte MODE_PROGRAMING = 0;
    public static byte MODE_WORKING = 1;
    public static String WEBROOT_TEMP_THINGMANAGER = "xworker_webroot_tmpthingmanager";
    private static final World worldInstance = new World();
    private final TransientThingManager transientThingManager = new TransientThingManager();
    private final ClassThingManager classThingManager = new ClassThingManager();
    public Thing metaThing = null;
    protected List<ThingEntry> globalContexts = new CopyOnWriteArrayList<ThingEntry>();
    private String worldPath = ".";
    private final Map<String, Object> userDatas = new HashMap<String, Object>();
    protected volatile ThreadLocal<Map<String, Object>> threadLocalDatas = null;
    private final Map<String, List<ThingManagerListener>> thingManagerListeners = new ConcurrentHashMap<String, List<ThingManagerListener>>();
    private ThingClassLoader worldClassLoader = null;
    private ActionListener actionListener = null;
    private final List<Help> helps = new ArrayList<Help>();
    public int helpSize = 100;
    private boolean verbose = false;
    private boolean inited = false;
    private byte mode = MODE_PROGRAMING;
    private Map<String, String> verboseThingCache = null;
    private final List<ThingManager> thingManagers = new CopyOnWriteArrayList<ThingManager>();
    private final List<ThingCoder> thingCoders = new ArrayList<ThingCoder>();
    private final List<String> failureThingManangers = new ArrayList<String>();
    private final List<String> libList = new ArrayList<String>();
    private String OS;
    private String PROCESSOR_ARCHITECTURE;
    private String webFileRoot = null;

    private World() {
        TxtThingCoder txtThingCoder = new TxtThingCoder();
        XmlThingCoder xmlThingCoder = new XmlThingCoder();
        PropertyThingCoder propertyCoder = new PropertyThingCoder();
        DmlThingCoder dmlThingCoder = new DmlThingCoder(xmlThingCoder, txtThingCoder, propertyCoder);
        DmwThingCoder dmwThingCoder = new DmwThingCoder(xmlThingCoder, txtThingCoder, propertyCoder);
        this.thingCoders.add(dmlThingCoder);
        this.thingCoders.add(dmwThingCoder);
        this.thingCoders.add(txtThingCoder);
        this.thingCoders.add(xmlThingCoder);
        this.thingCoders.add(new XerThingCoder());
        try {
            this.thingCoders.add(new JsonThingCoder());
        }
        catch (Throwable e) {
            log.log(Level.FINE, "JsonThingCoder init error, if need json, need Jackson, " + e.getMessage());
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    UtilJava.invokeMethod("org.xmeta.util.ThingOgnlAccessor", "init", new Class[0], new Object[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }).start();
        String worldClassPath = System.getenv("xworker.class.path");
        if (worldClassPath != null) {
            for (String path : worldClassPath.split("[" + File.pathSeparator + "]")) {
                this.addLib(path);
            }
        }
    }

    public static World getInstance() {
        return worldInstance;
    }

    public void setMode(byte mode) {
        this.mode = mode;
    }

    public byte getMode() {
        return this.mode;
    }

    public List<String> getLibList() {
        return this.libList;
    }

    public void addLib(String lib) {
        this.libList.add(lib);
    }

    public ThingManager createThingManager(String name, String link) {
        File managerRootFile = new File(this.getPath() + "/projects/" + name);
        return this.createThingManager(name, managerRootFile, link);
    }

    public ThingManager createThingManager(String name, File managerRootFile, String link) {
        if (managerRootFile.exists()) {
            throw new XMetaException("ThingManager already exists, name=" + name);
        }
        managerRootFile.mkdirs();
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(new File(managerRootFile, "config.properties"));
            fout.write(("link=" + link).getBytes());
        }
        catch (Exception e) {
            throw new XMetaException("create config.properties error, thingManager=" + name, e);
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.initThingManager(managerRootFile);
    }

    public List<String> getFailureThingManangers() {
        return this.failureThingManangers;
    }

    public boolean isFailureThingManager(String thingManager) {
        return this.failureThingManangers.contains(thingManager);
    }

    public void removeFailureThingManager(String thingManager) {
        this.failureThingManangers.remove(thingManager);
    }

    public void addGlobalContext(Thing contextThing, int index) {
        this.addGlobalActionListener(contextThing, index);
    }

    public void addGlobalActionListener(Thing listener) {
        this.addGlobalActionListener(listener, -1);
    }

    public void addGlobalActionListener(Thing listener, int index) {
        boolean have = false;
        for (ThingEntry entry : this.globalContexts) {
            Thing thing = entry.getThing();
            if (thing == null || !thing.getMetadata().getPath().equals(listener.getMetadata().getPath())) continue;
            have = true;
            break;
        }
        if (!have) {
            ThingEntry entry = new ThingEntry(listener);
            if (index == -1) {
                this.globalContexts.add(entry);
            } else {
                this.globalContexts.add(index, entry);
            }
        }
    }

    public void removeGlobalContext(Thing contextThing) {
        this.removeGlobalActionListener(contextThing);
    }

    public void removeGlobalActionListener(Thing listener) {
        ThingEntry forRemoved = null;
        for (ThingEntry entry : this.globalContexts) {
            Thing thing = entry.getThing();
            if (thing == null || !thing.getMetadata().getPath().equals(listener.getMetadata().getPath())) continue;
            forRemoved = entry;
            break;
        }
        if (forRemoved != null) {
            this.globalContexts.remove(forRemoved);
        }
    }

    public Object get(String pathStr) {
        String thingPath;
        if (pathStr == null || "".equals(pathStr)) {
            return this;
        }
        Path path = new Path(pathStr);
        Thing thing = ThingCache.get(path.getPath());
        if (thing != null && thing.getMetadata().isRemoved()) {
            thing = null;
        }
        if (thing == null) {
            if ("MetaThing".equals(path.getPath())) {
                thing = this.metaThing;
            } else {
                thingPath = path.getPath();
                for (int i = 0; i < this.thingManagers.size(); ++i) {
                    ThingManager thingManager = this.thingManagers.get(i);
                    thing = thingManager.getThing(thingPath);
                    if (thing == null) continue;
                    path.setType((byte)2);
                    break;
                }
                if (thing != null) {
                    ThingCache.put(path.getPath(), thing);
                } else {
                    Category category = null;
                    for (int i = 0; i < this.thingManagers.size(); ++i) {
                        ThingManager thingManager = this.thingManagers.get(i);
                        category = thingManager.getCategory(path.getPath());
                        if (category == null) continue;
                        path.setType((byte)1);
                        return category;
                    }
                }
            }
        }
        if (thing == null && (thing = this.loadThingFromClasspath(thingPath = path.getPath())) != null) {
            ThingCache.put(thingPath, thing);
        }
        if (thing != null) {
            return thing.get(path);
        }
        return null;
    }

    private void printVerbose(String thingPath) {
        if (this.verboseThingCache == null) {
            this.verboseThingCache = new HashMap<String, String>();
        }
        if (this.verboseThingCache.get(thingPath) == null) {
            this.verboseThingCache.put(thingPath, thingPath);
            System.out.println("[Loaded " + thingPath + " from X-Meta");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Thing loadThingFromClasspath(String thingPath) {
        Thing thing = null;
        for (ThingCoder coder : this.thingCoders) {
            String resource = thingPath.replace('.', '/') + "." + coder.getType();
            URL url = this.getClassLoader().getResource(resource);
            if (url == null) {
                url = this.getClassLoader().getResource("/" + resource);
            }
            if (url == null) continue;
            thing = new Thing(null, null, null, false);
            ThingMetadata metadata = thing.getMetadata();
            metadata.setPath(thingPath);
            String categoryPath = thingPath;
            if (thingPath.lastIndexOf(".") != -1) {
                categoryPath = thingPath.substring(0, thingPath.lastIndexOf("."));
            }
            Category category = this.classThingManager.getCategory(categoryPath);
            metadata.setCategory(category);
            try {
                InputStream fin = url.openStream();
                try {
                    File file;
                    thing.beginModify();
                    long lastModified = System.currentTimeMillis();
                    String fileName = url.getFile();
                    if (fileName != null && (file = new File(fileName)).exists()) {
                        lastModified = file.lastModified();
                    }
                    coder.decode(thing, fin, lastModified);
                }
                catch (Exception e) {
                    System.out.println("load thing error, thingPath=" + thingPath);
                    e.printStackTrace();
                    Thing thing2 = null;
                    return thing2;
                }
                finally {
                    thing.endModify(false);
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (url.getProtocol().toLowerCase().equals("file")) {
                    FileMonitor.getInstance().addFile(thingPath, thing, new File(url.getFile()), false);
                }
                ThingCache.put(metadata.getPath(), thing);
                return thing;
            }
            catch (IOException e) {
                log.log(Level.WARNING, "load thing from classpath error", e);
            }
        }
        try {
            Class<?> cls = this.worldClassLoader.loadClass(thingPath);
            if (cls == null) return null;
            thing = ThingAnnotationUtils.parse(cls);
            if (thing == null) return null;
            String pkg = cls.getName();
            int index = pkg.lastIndexOf(".");
            if (index > 0) {
                pkg = pkg.substring(0, index);
            }
            thing.getMetadata().setCategory(this.classThingManager.getCategory(pkg));
            thing.getMetadata().setPath(thingPath);
            ThingCache.put(thing.metadata.getPath(), thing);
            return thing;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public URL getResource(String path) throws IOException {
        if (path == null) {
            return null;
        }
        if ((path = path.replace('\\', '/')).startsWith("world|")) {
            path = World.getInstance().getPath() + "/" + path.substring(6);
            File file = new File(path);
            if (file.exists()) {
                return file.toURI().toURL();
            }
            return this.getClassLoader().getResource("/" + path.substring(6));
        }
        if (path.startsWith("project|") || path.contains(":")) {
            int index = path.indexOf(":");
            String projectName = null;
            projectName = path.startsWith("project|") ? path.substring(8, index) : path.substring(0, index);
            path = path.substring(index + 1);
            path = "/" + projectName + "/" + path;
            for (ThingManager thingManager : this.getThingManagers()) {
                URL in = thingManager.findResource(path);
                if (in == null) continue;
                return in;
            }
            return this.getClassLoader().getResource(path);
        }
        File file = new File(path);
        if (file.exists()) {
            return file.toURI().toURL();
        }
        file = new File(this.getPath() + "/webroot/" + path);
        if (file.exists()) {
            return file.toURI().toURL();
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        for (ThingManager thingManager : this.getThingManagers()) {
            URL in = thingManager.findResource(path);
            if (in == null) continue;
            return in;
        }
        URL in = this.getClassLoader().getResource(path);
        if (in == null) {
            in = path.startsWith("/") || path.startsWith("\\") ? this.getClassLoader().getResource(path.substring(1)) : this.getClassLoader().getResource("/" + path);
        }
        return in;
    }

    public InputStream getResourceAsStream(String path) throws IOException {
        if (path == null) {
            return null;
        }
        if ((path = path.replace('\\', '/')).startsWith("world|")) {
            path = World.getInstance().getPath() + "/" + path.substring(6);
            File file = new File(path);
            if (file.exists()) {
                return new FileInputStream(file);
            }
            return this.getClassLoader().getResourceAsStream("/" + path.substring(6));
        }
        if (path.startsWith("project|") || path.contains(":")) {
            int index = path.indexOf(":");
            String projectName = null;
            projectName = path.startsWith("project|") ? path.substring(8, index) : path.substring(0, index);
            path = path.substring(index + 1);
            path = "/" + projectName + "/" + path;
            for (ThingManager thingManager : this.getThingManagers()) {
                InputStream in = thingManager.getResourceAsStream(path);
                if (in == null) continue;
                return in;
            }
            return this.getClassLoader().getResourceAsStream(path);
        }
        File file = new File(path);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        file = new File(this.getPath() + "/webroot/" + path);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        for (ThingManager thingManager : this.getThingManagers()) {
            InputStream in = thingManager.getResourceAsStream(path);
            if (in == null) continue;
            return in;
        }
        InputStream in = this.getClassLoader().getResourceAsStream(path);
        if (in == null) {
            in = path.startsWith("/") || path.startsWith("\\") ? this.getClassLoader().getResourceAsStream(path.substring(1, path.length())) : this.getClassLoader().getResourceAsStream("/" + path);
        }
        return in;
    }

    public Action getAction(String actionPath) {
        Thing actionThing = this.getThing(actionPath);
        if (actionThing != null) {
            return actionThing.getAction();
        }
        return null;
    }

    public Class getActionClass(String actionPath, ActionContext actionContext) {
        return this.getActionClass(this.getThing(actionPath), actionContext);
    }

    public Class getActionClass(Thing actionThing, ActionContext actionContext) {
        if (actionThing != null) {
            return actionThing.getAction().getActionClass(actionContext);
        }
        return null;
    }

    public Action getAction(Thing actionThing) {
        return actionThing.getAction();
    }

    public <T> T getData(String key) {
        return (T)this.userDatas.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadData(String key, Object data) {
        Map<String, Object> dataMap;
        if (key == null) {
            return;
        }
        if (this.threadLocalDatas == null) {
            World world = this;
            synchronized (world) {
                if (this.threadLocalDatas == null) {
                    this.threadLocalDatas = new ThreadLocal();
                }
            }
        }
        if ((dataMap = this.threadLocalDatas.get()) == null) {
            dataMap = new HashMap<String, Object>();
            this.threadLocalDatas.set(dataMap);
        }
        dataMap.put(key, data);
    }

    public <T> T getThreadData(String key) {
        if (key == null) {
            return null;
        }
        if (this.threadLocalDatas == null) {
            return null;
        }
        Map<String, Object> dataMap = this.threadLocalDatas.get();
        if (dataMap == null) {
            return null;
        }
        return (T)dataMap.get(key);
    }

    public String getPath() {
        return this.worldPath;
    }

    public void debug(ActionContext actionContext) {
        Thing debugAction = this.getThing("xworker.ide.debug.action.DebugAction");
        if (debugAction != null) {
            debugAction.doAction("debug", actionContext);
        }
    }

    public Thing getThing(String path) {
        Object obj = this.get(path);
        if (obj instanceof Thing) {
            return (Thing)obj;
        }
        return null;
    }

    public Thing getThing(String path, String thingManager, String descriptor) {
        Thing thing = this.getThing(path);
        if (thing == null) {
            thing = new Thing(descriptor);
            thing.initDefaultValue();
            thing.saveAs(thingManager, path);
        }
        return thing;
    }

    public List<ThingManager> getThingManagers() {
        return this.thingManagers;
    }

    public List<ThingManagerListener> getThingManagerListeners(String thingManagerName) {
        ArrayList<ThingManagerListener> ls = new ArrayList<ThingManagerListener>();
        List<ThingManagerListener> listeners = this.thingManagerListeners.get(thingManagerName);
        if (listeners != null) {
            ls.addAll(listeners);
        }
        if ((listeners = this.thingManagerListeners.get("*")) != null) {
            ls.addAll(listeners);
        }
        return ls;
    }

    public ThingClassLoader getClassLoader() {
        return this.worldClassLoader;
    }

    private boolean isLibraryExists(String[] paths, String path) {
        File pathFile = new File(path);
        if (!pathFile.exists()) {
            return true;
        }
        for (int i = 0; i < paths.length; ++i) {
            File f = new File(paths[i]);
            if (!f.exists()) continue;
            try {
                if (f.getCanonicalPath().equals(pathFile.getCanonicalPath())) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (i >= 1) break;
        }
        return false;
    }

    private void initOsProperites() {
        try {
            try {
                this.OS = System.getenv("OS").toLowerCase();
            }
            catch (Exception e) {
                this.OS = System.getProperty("os.name").toLowerCase();
            }
            this.PROCESSOR_ARCHITECTURE = "bit" + System.getProperty("sun.arch.data.model");
            InputStream osin = World.class.getResourceAsStream("/xworker_os.properties");
            if (osin != null) {
                Properties p = new Properties();
                p.load(osin);
                osin.close();
                String value = p.getProperty(this.OS);
                if (value != null && !"".equals(value)) {
                    this.OS = value;
                }
                if ((value = p.getProperty(this.PROCESSOR_ARCHITECTURE)) != null && !"".equals(value)) {
                    this.PROCESSOR_ARCHITECTURE = value;
                }
            }
            log.log(Level.FINE, "OS=" + this.OS + ", sun.arch.data.model=" + this.PROCESSOR_ARCHITECTURE);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "init os info error", e);
        }
    }

    public String getHome(String name) {
        String home = this.getHomeFromSystem(name = name.toUpperCase());
        if (home == null) {
            home = this.getHomeFromSystem(name.toLowerCase());
        }
        return home;
    }

    public String getHomeFromSystem(String name) {
        String home = System.getProperty(name);
        if (home == null) {
            home = System.getenv(name);
        }
        return home;
    }

    public String testFileHome(String filePath) {
        if (new File(filePath).exists()) {
            return filePath;
        }
        return null;
    }

    public String getHomeFormSytsem() {
        String home = this.getHome("XMETA_HOME");
        if (home == null) {
            home = this.getHome("XWORKER_HOME");
        }
        if (home == null) {
            home = System.getenv("xmeta_home");
        }
        if (home == null) {
            home = System.getenv("XMETA_HOME");
        }
        if (home == null) {
            home = this.testFileHome("/usr/local/xworker/");
        }
        if (home == null) {
            home = ".";
        }
        return home;
    }

    public void init(String worldPath) {
        this.init(worldPath, World.class.getClassLoader());
    }

    public void init(String worldPath, ClassLoader classLoader) {
        if (worldPath == null) {
            worldPath = this.getHomeFormSytsem();
        }
        System.setProperty("XMETA_HOME", worldPath);
        ThingCache.clear();
        File f = new File(worldPath);
        File _local = new File(f, "projects/_local");
        if (!_local.exists() && f.canWrite()) {
            _local.mkdirs();
        }
        this.worldPath = f.getAbsolutePath();
        this.initOsProperites();
        this.worldClassLoader = new ThingClassLoader(classLoader);
        this.metaThing = new MetaThing();
        this.getClassLoader().initLibs();
        Thread.currentThread().setContextClassLoader(this.worldClassLoader);
        this.thingManagers.clear();
        this.refresh();
        this.thingManagers.add(this.transientThingManager);
        Thing baseClass = this.getThing("xworker.lang.MetaThing");
        if (baseClass != null) {
            baseClass = baseClass.detach();
            baseClass.getMetadata().setPath("xworker.lang.MetaThing");
            baseClass.initChildPath();
            this.metaThing = baseClass;
        }
        this.inited = true;
    }

    public boolean isInited() {
        return this.inited;
    }

    public void refresh() {
        HashMap<String, String> context = new HashMap<String, String>();
        for (ThingManager manager : this.thingManagers) {
            context.put(manager.getName(), manager.getName());
        }
        File projectsFiles = new File(this.worldPath, "projects");
        if (projectsFiles.exists()) {
            for (File projectFile : projectsFiles.listFiles()) {
                String name;
                if (projectFile.isFile() || context.get(name = projectFile.getName()) != null) continue;
                this.initThingManager(projectFile);
                context.put(name, name);
            }
        }
        new JarThingManagerIniter().run();
    }

    public void registThingManagerListener(String thingManagerName, ThingManagerListener listener) {
        List<ThingManagerListener> listeners = this.thingManagerListeners.get(thingManagerName);
        if (listeners == null) {
            listeners = new ArrayList<ThingManagerListener>();
            this.thingManagerListeners.put(thingManagerName, listeners);
        }
        if (listener != null && !listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public void runActionAsync(String actionPath, ActionContext actionContext) {
        this.runActionAsync(actionPath, actionContext, null);
    }

    public void runActionAsync(String actionPath, final ActionContext actionContext, final Map<String, Object> parameters) {
        final Action action = this.getAction(actionPath);
        if (action == null) {
            log.info("can not find the action : " + actionPath);
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    action.run(actionContext, parameters);
                }
            }).start();
        }
    }

    public Object runAction(String actionPath, ActionContext actionContext) {
        return this.runAction(actionPath, actionContext, null);
    }

    public Object runAction(String actionPath, ActionContext actionContext, Map<String, Object> parameters) {
        Action action = this.getAction(actionPath);
        if (action == null) {
            log.info("can not find the action : " + actionPath);
            return null;
        }
        return action.run(actionContext, parameters);
    }

    public void setData(String key, Object value) {
        if (value == null) {
            this.userDatas.remove(key);
        } else {
            this.userDatas.put(key, value);
        }
    }

    public void removeData(String key) {
        this.userDatas.remove(key);
    }

    public void unregistThingManagerListener(String thingManagerName, ThingManagerListener listener) {
        List<ThingManagerListener> listeners = this.thingManagerListeners.get(thingManagerName);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public boolean isHaveActionListener() {
        return this.actionListener != null;
    }

    public boolean isThingFile(String fileName) {
        for (ThingCoder coder : this.thingCoders) {
            if (!fileName.endsWith("." + coder.getType())) continue;
            return true;
        }
        return false;
    }

    public void addThingManager(ThingManager thingManager) {
        this.checkIfThingManagerExists(thingManager);
        this.thingManagers.add(thingManager);
    }

    public ClassThingManager getClassThingManager() {
        return this.classThingManager;
    }

    public void addThingManagerFirst(ThingManager thingManager) {
        this.checkIfThingManagerExists(thingManager);
        this.thingManagers.add(0, thingManager);
    }

    public void moveThingManagerToFirst(ThingManager thingManager) {
        if (this.thingManagers.remove(thingManager)) {
            this.thingManagers.add(0, thingManager);
        }
    }

    private void checkIfThingManagerExists(ThingManager thingManager) {
        for (ThingManager manager : this.thingManagers) {
            if (!manager.getName().equals(thingManager.getName())) continue;
            throw new XMetaException("ThingManager already exists, name=" + manager.getName());
        }
    }

    public ThingManager getThingManager(String name) {
        for (ThingManager manager : this.thingManagers) {
            if (!manager.getName().equals(name)) continue;
            return manager;
        }
        return null;
    }

    public void removeThingManager(ThingManager thingManager) {
        this.removeThingManager(thingManager, true);
    }

    public void removeThingManager(ThingManager thingManager, boolean deleteRes) {
        for (int i = 0; i < this.thingManagers.size(); ++i) {
            ThingManager tm = this.thingManagers.get(i);
            if (tm != thingManager && !tm.getName().equals(thingManager.getName())) continue;
            this.thingManagers.remove(i);
            break;
        }
        if (deleteRes && thingManager.getRootDir() != null) {
            UtilFile.delete(thingManager.getRootDir());
        }
    }

    public String getOS() {
        return this.OS;
    }

    public String getJVMBit() {
        return this.PROCESSOR_ARCHITECTURE;
    }

    public ThingManager initThingManager(File rootPath) {
        String name = rootPath.getName();
        return this.initThingManager(rootPath, name);
    }

    public ThingManager initThingManager(File rootPath, String name) {
        String thingManagerClass = null;
        String link = null;
        if (this.isFailureThingManager(name)) {
            return null;
        }
        try {
            if (rootPath.getCanonicalFile().equals(new File(this.getPath()).getCanonicalFile())) {
                return null;
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "XWorker home can not be a project", e);
        }
        boolean hasThingsDir = false;
        Properties properties = new Properties();
        if (rootPath.isDirectory()) {
            File configFile = new File(rootPath, "config.properties");
            hasThingsDir = true;
            if (!configFile.exists()) {
                configFile = new File(rootPath, "xworker.properties");
            }
            if (!configFile.exists() && (configFile = new File(rootPath, ".dml")).exists()) {
                hasThingsDir = false;
            }
            if (!configFile.exists() && (configFile = new File(rootPath, "dml.properties")).exists()) {
                hasThingsDir = false;
            }
            if (!configFile.exists() && (configFile = new File(rootPath, "dml.prj")).exists()) {
                hasThingsDir = false;
            }
            if (configFile.exists()) {
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(configFile);
                    properties.load(fin);
                    String pname = properties.getProperty("projectName");
                    if (pname == null || "".equals(pname)) {
                        pname = properties.getProperty("name");
                    }
                    if (pname != null && !"".equals(pname.trim())) {
                        name = pname.trim();
                    }
                    if ((link = properties.getProperty("link")) != null && link.trim().equals("") || "null".equals(link)) {
                        link = null;
                    }
                    if ("false".equals(properties.getProperty("hasThingsDir"))) {
                        hasThingsDir = false;
                    }
                    thingManagerClass = properties.getProperty("class");
                }
                catch (Exception e) {
                    this.failureThingManangers.add(name);
                    throw new XMetaException("init thing manager error, path=" + rootPath, e);
                }
                finally {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        boolean isLink = false;
        if (link != null) {
            File linkFile = new File(link);
            if (!linkFile.exists()) {
                linkFile = new File(this.worldPath, link);
            }
            if (!linkFile.exists()) {
                linkFile = new File(rootPath.getParentFile(), link);
            }
            if (linkFile.exists()) {
                isLink = true;
                String linkName = linkFile.getName().toLowerCase();
                if (linkFile.isFile() && (linkName.endsWith(".jar") || linkName.endsWith(".zip"))) {
                    JarThingManager thingManager = new JarThingManager(name, linkFile);
                    thingManager.init(properties);
                    this.addThingManager(thingManager);
                    this.getClassLoader().addJarOrZip(linkFile);
                    this.addJarOrZip(rootPath);
                    thingManager.setRootDir(rootPath);
                    return thingManager;
                }
                FileThingManager thingManager = new FileThingManager(name, linkFile);
                thingManager.init(properties);
                this.addThingManager(thingManager);
                this.addJarOrZip(linkFile);
                thingManager.setRootDir(rootPath);
                return thingManager;
            }
        }
        if (!isLink) {
            ThingManager thingManager = null;
            if (thingManagerClass != null) {
                Class<?> cls = null;
                try {
                    cls = Class.forName(thingManagerClass);
                    try {
                        Constructor<?> constructor = cls.getConstructor(String.class, File.class);
                        thingManager = (ThingManager)constructor.newInstance(name, rootPath);
                    }
                    catch (Exception eee) {
                        thingManager = (ThingManager)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "can not load thingManager", e);
                }
                if (thingManager == null) {
                    this.failureThingManangers.add(name);
                    return null;
                }
            } else {
                thingManager = new FileThingManager(name, rootPath, hasThingsDir);
            }
            try {
                thingManager.init(properties);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "init thingManager error", e);
                this.failureThingManangers.add(name);
                return null;
            }
            this.addThingManager(thingManager);
            this.addJarOrZip(rootPath);
            thingManager.setRootDir(rootPath);
            return thingManager;
        }
        return null;
    }

    private void addJarOrZip(File dir) {
        this.getClassLoader().addJarOrZip(new File(dir, "lib"));
        this.getClassLoader().addJarOrZip(new File(dir, "lib_" + this.OS));
        this.getClassLoader().addJarOrZip(new File(dir, "lib_" + this.OS + "_" + this.PROCESSOR_ARCHITECTURE));
        File webInfo = new File(dir, "WEB-INF");
        if (webInfo.exists() && webInfo.isDirectory()) {
            this.addJarOrZip(webInfo);
        }
    }

    public void addHelp(String title, String sourcePath, String helpPath) {
        Help help = new Help(title, sourcePath, helpPath);
        this.helps.add(help);
        if (this.helps.size() > this.helpSize) {
            this.helps.remove(0);
        }
    }

    public List<Help> getHelps() {
        return this.helps;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public TransientThingManager getTransientThingManager() {
        return this.transientThingManager;
    }

    public void registThingCoder(ThingCoder thingCoder) {
        this.thingCoders.add(thingCoder);
    }

    public List<ThingCoder> getThingCoders() {
        return this.thingCoders;
    }

    public ThingCoder getThingCoder(String type) {
        for (ThingCoder thingCoder : this.thingCoders) {
            if (!thingCoder.acceptType(type)) continue;
            return thingCoder;
        }
        return null;
    }

    public String getWebFileRoot() {
        return this.webFileRoot;
    }

    public void setWebFileRoot(String webFileRoot) {
        this.webFileRoot = webFileRoot;
    }

    public void addFileThingManager(String name, File dir, boolean hasThingDir, boolean first) throws IOException {
        File worldDir = new File(this.getPath());
        if (worldDir.getCanonicalFile().equals(dir.getCanonicalFile())) {
            return;
        }
        FileThingManager tm = new FileThingManager(name, dir, hasThingDir);
        Properties properties = new Properties();
        File configFile = new File(dir, "config.properties");
        if (!configFile.exists()) {
            configFile = new File(dir, "xworker.properties");
        }
        if (!configFile.exists()) {
            configFile = new File(dir, ".dml");
        }
        if (!configFile.exists()) {
            configFile = new File(dir, "dml.properties");
        }
        if (!configFile.exists()) {
            configFile = new File(dir, "dml.prj");
        }
        if (configFile.exists()) {
            try (FileInputStream fin = new FileInputStream(configFile);){
                properties.load(fin);
            }
        }
        tm.init(properties);
        if (first) {
            this.addThingManagerFirst(tm);
        } else {
            this.addThingManager(tm);
        }
    }

    public ThingManager getWorkDirThingManager() {
        return this.thingManagers.get(0);
    }
}

