/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xmeta.ActionContext;
import org.xmeta.Thing;
import org.xmeta.ThingManager;
import org.xmeta.World;
import org.xmeta.util.JavaAction;

public class JavaActionFactory {
    static final Map<String, JavaAction> actions = new HashMap<String, JavaAction>();

    public static void regist(String className, String methodName, JavaAction javaAction) {
        String key = className + "_" + methodName;
        actions.put(key, javaAction);
    }

    public static JavaAction getJavaAction(String className, String methodName) {
        String key = className + "_" + methodName;
        return actions.get(key);
    }

    public static void registAction(String actionPath, JavaAction javaAction) {
        actions.put(actionPath, javaAction);
    }

    public static JavaAction getActionJavaAction(String actionPath) {
        return actions.get(actionPath);
    }

    public static String genereateRegistJavaCode() {
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> context = new HashMap<String, String>();
        for (ThingManager thingManager : World.getInstance().getThingManagers()) {
            Iterator<Thing> iter = thingManager.iterator(null, true);
            while (iter.hasNext()) {
                Thing thing = iter.next();
                if (thing == null) continue;
                JavaActionFactory.registJavaAction(thing, sb, context);
            }
        }
        return sb.toString();
    }

    private static void registJavaAction(Thing thing, StringBuilder sb, Map<String, String> context) {
        if ("JavaAction".equals(thing.getThingName())) {
            String outerClassName = thing.getStringBlankAsNull("outerClassName");
            String methodName = thing.getStringBlankAsNull("methodName");
            String key = outerClassName + "_" + methodName;
            if (outerClassName != null && methodName != null && JavaActionFactory.getJavaAction(outerClassName, methodName) == null && context.get(key) == null) {
                context.put(key, key);
                boolean returnVoid = false;
                try {
                    Class<?> cls = World.getInstance().getClassLoader().loadClass(outerClassName);
                    Method method = cls.getMethod(methodName, ActionContext.class);
                    returnVoid = method.getReturnType().equals(Void.TYPE);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (returnVoid) {
                    sb.append("        JavaActionFactory.regist(\"").append(outerClassName).append("\", \"").append(methodName);
                    sb.append("\", actionContext -> {\n");
                    sb.append("            ").append(outerClassName).append(".").append(methodName).append("(actionContext);\n            return null;\n        });\n");
                } else {
                    sb.append("        JavaActionFactory.regist(\"").append(outerClassName).append("\", \"").append(methodName);
                    sb.append("\", ").append(outerClassName).append("::").append(methodName).append(");\n");
                }
            }
        } else {
            for (Thing child : thing.getChilds()) {
                JavaActionFactory.registJavaAction(child, sb, context);
            }
        }
    }

    public static void main(String[] args) {
        try {
            Method method = JavaActionFactory.class.getMethod("registAction", String.class, JavaAction.class);
            System.out.println(method.getReturnType());
            System.out.println(method.getReturnType().equals(Void.TYPE));
            System.out.println(method.getReturnType() == Void.TYPE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

