/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.xmeta.ActionContext;
import org.xmeta.Thing;
import org.xmeta.World;
import org.xmeta.util.UtilFile;

public class ThingRunner {
    public static final String working_project = "working_directory";

    public static void main(String[] args) {
        ThingRunner.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean loadXerFromJar(Properties p, File fileName) {
        try (JarFile jarFile = new JarFile(fileName);){
            JarEntry entry = jarFile.getJarEntry("dml.ini");
            if (entry == null) {
                boolean bl = false;
                return bl;
            }
            InputStream in = jarFile.getInputStream(entry);
            p.load(in);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void initProjects() {
        World world = World.getInstance();
        File projectsDir = new File("./projects/");
        File worldPrjDir = new File(world.getPath() + "/projects/");
        try {
            if (projectsDir.getCanonicalPath().equals(worldPrjDir.getCanonicalPath())) {
                return;
            }
        }
        catch (IOException e1) {
            return;
        }
        if (projectsDir.exists() && projectsDir.isDirectory()) {
            for (File prjDir : projectsDir.listFiles()) {
                if (!prjDir.isDirectory() || !ThingRunner.isProject(prjDir)) continue;
                try {
                    world.initThingManager(prjDir);
                }
                catch (Exception e) {
                    System.out.println("init project error, " + e);
                }
            }
        }
    }

    public static boolean isProject(File dir) {
        return new File(dir, "config.properties").exists() || new File(dir, "xworker.properties").exists() || new File(dir, "dml.prj").exists() || new File(dir, "dml.properties").exists() || new File(dir, ".dml").exists();
    }

    public static void run(String[] args) {
        try {
            try {
                Class<?> cls = Class.forName("xworker.io.SystemIoRedirector");
                cls.getMethod("init", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception cls) {
                // empty catch block
            }
            String worldPath = null;
            String thingPath = null;
            String actionName = null;
            if (args.length >= 1) {
                worldPath = args[0];
            }
            if (args.length >= 2) {
                thingPath = args[1];
            }
            if (args.length >= 3) {
                actionName = args[2];
            }
            if (actionName == null) {
                actionName = "run";
            }
            if (thingPath == null) {
                System.out.println("Please input thing path or thing file");
                System.exit(0);
            }
            System.setProperty("XWORKER_HOME", worldPath);
            System.setProperty("XMETA_HOME", worldPath);
            System.setProperty("MODEL", ThingRunner.getThingPathAsModelForLog(thingPath));
            String currentDir = new File(".").getAbsolutePath();
            currentDir = currentDir.replace('/', '_').replace('\\', '_').replace(':', '_');
            System.setProperty("currentDir", currentDir);
            File thingFile = new File(thingPath);
            if (thingFile.exists()) {
                System.setProperty("thing", thingFile.getName());
            } else {
                System.setProperty("thing", thingPath);
            }
            World world = World.getInstance();
            ClassLoader contextClassCloader = Thread.currentThread().getContextClassLoader();
            if (contextClassCloader != null) {
                world.init(worldPath, contextClassCloader);
            } else {
                world.init(worldPath);
            }
            ThingRunner.initProjects();
            for (String arg : args) {
                if (!arg.toLowerCase().equals("-verbose")) continue;
                world.setVerbose(true);
            }
            Thing thing = null;
            if (thing == null) {
                boolean isFile = false;
                if (!thingFile.exists()) {
                    thingFile = new File("./" + thingPath);
                }
                if (thingFile.exists()) {
                    if (".dml".equals(thingFile.getName())) {
                        ThingRunner.createThingEditor();
                        return;
                    }
                    thingPath = UtilFile.getThingPathByFile(thingFile.getAbsoluteFile());
                    if (thingPath == null) {
                        System.out.println("Cann't open, file is not a thing, file=" + thingPath);
                        return;
                    }
                    isFile = true;
                } else {
                    String tname;
                    File file = new File(".");
                    File rootFile = UtilFile.getThingsRootAndInitProject(file);
                    if (rootFile == null && world.getThingManager(tname = UtilFile.getThingManagerNameByDir(rootFile = file)) == null) {
                        world.addFileThingManager(tname, rootFile, false, true);
                    }
                }
                if (isFile) {
                    // empty if block
                }
                if ("XWORKER".equals(thingPath.toUpperCase())) {
                    thingPath = "XWorker";
                }
                thing = world.getThing(thingPath);
            }
            if (thing == null) {
                System.out.println("thing not exists : " + thingPath);
                System.exit(0);
            } else {
                ActionContext actionContext = new ActionContext();
                actionContext.put("args", (Object)args);
                actionContext.put("_args_", (Object)args);
                thing.doAction(actionName, actionContext);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private static void createThingEditor() {
        Thing thing = World.getInstance().getThing("xworker.tools.DmlConsole");
        thing.doAction("run");
    }

    private static boolean editThing(String thingPath) {
        Thing globalConfig = World.getInstance().getThing("_local.xworker.config.GlobalConfig");
        if (globalConfig == null) {
            System.out.println("XWorker has not run thing explorer, run thing......");
            return false;
        }
        String baseUrl = globalConfig.getString("webUrl") + "do?sc=xworker.ide.worldExplorer.swt.http.IDETools";
        try {
            URL checkIde = new URL(baseUrl + "&ac=isIdeOpened");
            URLConnection urlcon = checkIde.openConnection();
            InputStream in = urlcon.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String content = reader.readLine();
            if (!"true".equals(content)) {
                System.out.println("XWorker has not run thing explorer, run thing......");
                return false;
            }
        }
        catch (Exception e) {
            return ThingRunner.startExplorerAndEditThing(thingPath);
        }
        try {
            URL openThing = new URL(baseUrl + "&ac=oepenThing&path=" + URLEncoder.encode(thingPath, "utf-8"));
            openThing.openConnection().getContent();
            return true;
        }
        catch (Exception e) {
            System.out.println("Exception happend, run thing......, " + e.getLocalizedMessage());
            return false;
        }
    }

    private static boolean startExplorerAndEditThing(String filePath) {
        Thing explorer = World.getInstance().getThing("xworker.ide.worldExplorer.swt.SimpleExplorerRunner");
        if (explorer == null) {
            return false;
        }
        ActionContext actionContext = new ActionContext();
        actionContext.put("defaultOpenFile", (Object)new File(filePath));
        explorer.doAction("run", actionContext);
        return true;
    }

    public static String getThingPathAsModelForLog(String name) {
        name = name.replace(':', '_');
        name = name.replace('/', '_');
        if ((name = name.replace('\\', '_')).length() > 128) {
            name = name.substring(0, 64) + "_" + name.substring(name.length() - 64, name.length());
        }
        return name;
    }

    public static class WaiterForEnter
    extends Thread {
        boolean ctrPressed = false;
        boolean stoped = false;
        Thread waitThread = Thread.currentThread();

        public void waitForEnter() {
            try {
                while (!this.stoped) {
                    if (System.in.available() > 0) {
                        this.ctrPressed = true;
                    }
                    Thread.sleep(300L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            long timestart = System.currentTimeMillis();
            while (System.currentTimeMillis() - timestart < 3000L && !this.ctrPressed) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.stoped = true;
        }
    }
}

