/*******************************************************************************
* Copyright 2007-2013 See AUTHORS file.
 * 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* 
*   http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
******************************************************************************/
package org.xmeta.util;

/**
 * <p>重构监听器。</p>
 * 
 * 重构的流程是：
 *     1. 计算要移动和更新的模型总数，模型总数也是操作数量的总数。
 *     2. 进行拷贝操作，把原模型拷贝到目标模型。
 *     3. 更新所有的模型对原目标的引用到目标模型，操作可能是更新或未更新。
 *     4. 删除原模型。
 * 
 * @author zhangyuxiang
 *
 */
public interface RefactorListener {
	/**
	 * 开始重构。
	 * 
	 * @param count 可能需要改动的模型总数，包括重构的可以引用路径可能需要变动的。
	 */
	public void onStart(int count);
	
	/**
	 * 拷贝原模型到目标模型。
	 * 
	 * @param sourcePath 源路径
	 * @param targetPath 目标路径
	 */
	public void onCopy(String sourcePath, String targetPath);
	
	/**
	 * 删除原模型。
	 * 
	 * @param sourcePath 源路径
	 */
	public void onDelete(String sourcePath);
	
	/**
	 * 模型更新了，引用变更后模型更新。
	 * 		
	 * @param path 路径
	 */
	public void onUpdated(String path);
	
	/**
	 * 路径对应的模型没有更改。
	 * 
	 * @param path 路径
	 */
	public void notMidify(String path);	
	
	/**
	 * 重构结束了。
	 * 
	 */
	public void finish();
}