/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta;

import java.io.File;
import java.lang.reflect.Method;
import org.xmeta.ActionException;
import org.xmeta.World;
import org.xmeta.util.ProjectClassLoader;
import org.xmeta.util.ThingRunner;

public class Project {
    private final ProjectClassLoader classLoader;
    private final Object world;
    private final Method getThing;
    private final Method getAction;

    public Project(File projectDir) {
        this.classLoader = new ProjectClassLoader(projectDir);
        try {
            Class<?> worldCls = this.classLoader.loadClass("org.xmeta.World");
            Method getInstance = worldCls.getMethod("getInstance", new Class[0]);
            this.getThing = worldCls.getMethod("getThing", String.class);
            this.getAction = worldCls.getMethod("getAction", String.class);
            this.world = getInstance.invoke(null, new Object[0]);
            Method init = worldCls.getMethod("init", String.class);
            init.invoke(this.world, World.getInstance().getPath());
            this.initThingMangers(projectDir, 1);
        }
        catch (Exception e) {
            throw new ActionException("int project error", e);
        }
    }

    public ProjectClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Object getWorld() {
        return this.world;
    }

    public Object createActionContext() {
        try {
            Class<?> cls = this.classLoader.loadClass("org.xmeta.ActionContext");
            return cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ActionException("CreateActionContext eorr", e);
        }
    }

    private void initThingMangers(File dir, int level) {
        if (ThingRunner.isProject(dir)) {
            this.initThingManager(dir);
            return;
        }
        if (level > 3) {
            return;
        }
        for (File child : dir.listFiles()) {
            if (!child.isDirectory()) continue;
            this.initThingMangers(child, level + 1);
        }
    }

    public void initThingManager(File thingManagerDir) {
        try {
            Method initThingManager = this.world.getClass().getMethod("initThingManager", File.class);
            initThingManager.invoke(this.world, thingManagerDir);
        }
        catch (Exception e) {
            throw new ActionException("Init thing manager eorr", e);
        }
    }

    public Object getThing(String path) {
        try {
            return this.getThing.invoke(this.world, path);
        }
        catch (Exception e) {
            throw new ActionException("Get thing error", e);
        }
    }

    public Object getAction(String path) {
        try {
            return this.getAction.invoke(this.world, path);
        }
        catch (Exception e) {
            throw new ActionException("Get action error", e);
        }
    }
}

