/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.xmeta.ActionException;
import org.xmeta.Thing;
import org.xmeta.annotation.AAction;
import org.xmeta.annotation.AAttribute;
import org.xmeta.annotation.AChild;
import org.xmeta.annotation.AChildXml;
import org.xmeta.annotation.AThing;
import org.xmeta.annotation.AThingAttribute;
import org.xmeta.annotation.AThingChild;
import org.xmeta.util.UtilString;

public class ThingAnnotationUtils {
    /*
     * WARNING - void declaration
     */
    public static Thing parse(Class<?> cls) {
        void var7_16;
        AThing athing = cls.getAnnotation(AThing.class);
        if (athing == null) {
            return null;
        }
        Thing thing = new Thing(athing.descriptors());
        thing.set("extends", athing.extends_());
        String attrs = athing.attributes();
        if (attrs != null) {
            Object[] as = UtilString.getParams(attrs);
            for (String key : as.keySet()) {
                thing.set(key, as.get(key));
            }
        }
        for (AThingAttribute aThingAttribute : (AThingAttribute[])cls.getAnnotationsByType(AThingAttribute.class)) {
            thing.set(aThingAttribute.name(), aThingAttribute.value());
        }
        for (Annotation annotation : (AThingChild[])cls.getAnnotationsByType(AThingChild.class)) {
            Thing child = new Thing();
            child.set("name", annotation.name());
            child.set("extends", annotation.descriptors());
            thing.addChild(child);
        }
        for (Field field : cls.getDeclaredFields()) {
            AAttribute aatri = field.getAnnotation(AAttribute.class);
            if (aatri != null) {
                try {
                    if ((field.getModifiers() & 8) != 8) continue;
                    thing.set(field.getName(), field.get(null));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
                continue;
            }
            AChild achild = field.getAnnotation(AChild.class);
            if (achild != null) {
                if ((field.getModifiers() & 8) != 8) continue;
                try {
                    Object obj = field.get(null);
                    if (obj != null && obj instanceof Thing) {
                        thing.addChild((Thing)obj);
                        continue;
                    }
                    Thing child = ThingAnnotationUtils.parse(field.getType());
                    if (child == null) continue;
                    thing.addChild(child);
                }
                catch (IllegalArgumentException obj) {
                }
                catch (IllegalAccessException obj) {}
                continue;
            }
            AChildXml achildxml = field.getAnnotation(AChildXml.class);
            if (achildxml == null || (field.getModifiers() & 8) != 8) continue;
            try {
                String xml = (String)field.get(null);
                if (xml == null) continue;
                thing.addChild(xml);
            }
            catch (IllegalArgumentException xml) {
            }
            catch (IllegalAccessException xml) {
            }
            catch (Exception e) {
                throw new ActionException("Parse xml error, field=" + field, e);
            }
        }
        Thing actions = null;
        Method[] methodArray = cls.getDeclaredMethods();
        int n = methodArray.length;
        boolean bl = false;
        while (var7_16 < n) {
            Method method = methodArray[var7_16];
            AAction aaction = method.getAnnotation(AAction.class);
            if (aaction != null) {
                if (actions == null) {
                    actions = new Thing("actions");
                    thing.addChild(actions);
                }
                Thing javaAction = new Thing("JavaAction");
                javaAction.set("name", method.getName());
                javaAction.set("useOuterJava", "true");
                javaAction.set("outerClassName", cls.getName());
                javaAction.set("methodName", method.getName());
                actions.addChild(javaAction);
            }
            ++var7_16;
        }
        return thing;
    }
}

