/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.codes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmeta.ActionException;
import org.xmeta.Thing;
import org.xmeta.ThingMetadata;

public class XerCoder {
    public static final byte NODE_START = 120;
    public static final byte NODE_END = 121;
    public static final byte CHILD_NODE = 122;
    public static final byte ATTRIBUTE = 123;
    public static final byte VERSION = 124;
    public static final byte META = 125;
    public static final byte TYPE_STRING = 1;
    public static final byte TYPE_BIGDECIMAL = 2;
    public static final byte TYPE_BIGINTEGER = 3;
    public static final byte TYPE_BOOLEAN = 4;
    public static final byte TYPE_BYTE = 5;
    public static final byte TYPE_BYTES = 6;
    public static final byte TYPE_INT = 7;
    public static final byte TYPE_DOUBLE = 8;
    public static final byte TYPE_FLOAT = 9;
    public static final byte TYPE_CHAR = 10;
    public static final byte TYPE_SHORT = 11;
    public static final byte TYPE_OBJECT = 12;
    public static final byte TYPE_DATE = 13;
    public static final byte TYPE_LONG = 14;
    private static final String STRING_ENCODING = "UTF-8";
    private static final short version = 1;

    public static void encodeString(String str, OutputStream out) throws IOException {
        if (str == null) {
            str = "";
        }
        byte[] strBytes = str.getBytes(STRING_ENCODING);
        out.write(XerCoder.encodeInt32(strBytes.length));
        out.write(strBytes);
    }

    public static byte[] encodeInt16(int value) {
        byte[] bs = new byte[]{(byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return bs;
    }

    public static void encode1(Thing thing, OutputStream out, Map<Thing, String> context) throws IOException {
        if (context == null) {
            context = new HashMap<Thing, String>();
        }
        if (context.get(thing) != null) {
            return;
        }
        context.put(thing, "aaa");
        ThingMetadata meta = thing.getMetadata();
        out.write(125);
        ByteArrayOutputStream metaout = new ByteArrayOutputStream();
        metaout.write(XerCoder.encodeInt32(1));
        XerCoder.encodeString(meta.getId(), metaout);
        metaout.write(XerCoder.encodeLong64(meta.getLastModified()));
        XerCoder.encodeString(thing.getString("descriptors", ""), metaout);
        XerCoder.encodeString(thing.getString("extends", ""), metaout);
        byte[] metabytes = metaout.toByteArray();
        out.write(XerCoder.encodeInt32(metabytes.length));
        out.write(metabytes);
        out.write(new byte[]{120});
        List<Thing> fields = thing.getAllAttributesDescriptors();
        for (Thing field : fields) {
            String name = field.getMetadata().getName();
            String type = field.getString("type", "string").toLowerCase();
            if ("int".equals(type)) {
                int value = thing.getInt(name);
                XerCoder.encodeName(out, name);
                out.write(7);
                out.write(XerCoder.encodeInt32(value));
                continue;
            }
            if ("long".equals(type)) {
                long value = thing.getLong(name);
                XerCoder.encodeName(out, name);
                out.write(14);
                out.write(XerCoder.encodeLong64(value));
                continue;
            }
            if ("double".equals(type)) {
                double value = thing.getDouble(name);
                XerCoder.encodeName(out, name);
                out.write(8);
                long dvalue = Double.doubleToLongBits(value);
                out.write(XerCoder.encodeLong64(dvalue));
                continue;
            }
            if ("float".equals(type)) {
                float value = thing.getFloat(name);
                XerCoder.encodeName(out, name);
                out.write(9);
                long dvalue = Double.doubleToLongBits(value);
                out.write(XerCoder.encodeLong64(dvalue));
                continue;
            }
            if ("bigDecimal".equals(type)) {
                BigDecimal value = thing.getBigDecimal(name);
                if (value == null) continue;
                XerCoder.encodeName(out, name);
                out.write(2);
                String str = value.toString();
                out.write(str.length());
                out.write(str.getBytes());
                continue;
            }
            if ("bigInteger".equals(type)) {
                BigInteger value = thing.getBigInteger(name);
                if (value == null) continue;
                XerCoder.encodeName(out, name);
                out.write(3);
                byte[] bvalue = value.toByteArray();
                out.write(bvalue.length);
                out.write(bvalue);
                continue;
            }
            if ("boolean".equals(type)) {
                boolean value = thing.getBoolean(name);
                XerCoder.encodeName(out, name);
                out.write(4);
                out.write((byte)(value ? 1 : 0));
                continue;
            }
            if ("byte".equals(type)) {
                byte value = thing.getByte(name);
                XerCoder.encodeName(out, name);
                out.write(5);
                out.write(value);
                continue;
            }
            if ("bytes".equals(type)) {
                byte[] value = thing.getBytes(name);
                if (value == null) continue;
                XerCoder.encodeName(out, name);
                out.write(6);
                out.write(XerCoder.encodeInt32(value.length));
                out.write(value);
                continue;
            }
            if ("char".equals(type)) {
                char value = thing.getChar(name);
                XerCoder.encodeName(out, name);
                out.write(10);
                out.write(XerCoder.encodeInt16(value));
                continue;
            }
            if ("short".equals(type)) {
                short value = thing.getShort(name);
                XerCoder.encodeName(out, name);
                out.write(11);
                out.write(XerCoder.encodeInt16(value));
                out.write(new byte[]{(byte)value});
                continue;
            }
            if ("date".equals(type)) {
                Date value = thing.getDate(name);
                if (value == null) continue;
                XerCoder.encodeName(out, name);
                out.write(13);
                long dvalue = value.getTime();
                out.write(XerCoder.encodeLong64(dvalue));
                continue;
            }
            if ("object".equals(type)) {
                Object value = thing.getAttribute(name);
                if (value == null || !(value instanceof Serializable)) continue;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ObjectOutputStream oout = new ObjectOutputStream(bout);
                oout.writeObject(value);
                oout.flush();
                byte[] bs = bout.toByteArray();
                XerCoder.encodeName(out, name);
                out.write(12);
                out.write(XerCoder.encodeInt32(bs.length));
                out.write(bs);
                continue;
            }
            String value = thing.getString(name);
            if (value == null) continue;
            XerCoder.encodeName(out, name);
            out.write(1);
            XerCoder.encodeString(value, out);
        }
        List<Thing> childs = thing.getChilds();
        for (Thing child : childs) {
            out.write(122);
            XerCoder.encode1(child, out, context);
        }
        out.write(121);
    }

    public static void encode(Thing thing, OutputStream out, Map<Thing, String> context) throws IOException {
        if (context == null) {
            context = new HashMap<Thing, String>();
        }
        if (context.get(thing) != null) {
            return;
        }
        context.put(thing, "aaa");
        ThingMetadata meta = thing.getMetadata();
        int version = 3;
        boolean includeDefault = meta.isIncludeDefaultValue();
        out.write(new byte[]{124});
        out.write(XerCoder.encodeInt32(version));
        if (version >= 1) {
            if (includeDefault) {
                out.write(new byte[]{1});
            } else {
                out.write(new byte[]{0});
            }
        }
        if (version >= 2) {
            long lastTime = meta.getLastModified();
            if (lastTime == 0L) {
                lastTime = System.currentTimeMillis();
            }
            out.write(XerCoder.encodeLong64(lastTime));
        }
        if (version >= 3) {
            String value = thing.getMetadata().getId();
            if (value == null) {
                value = thing.getMetadata().getName();
            }
            String str = value.toString();
            byte[] bs = str.getBytes(STRING_ENCODING);
            out.write(XerCoder.encodeInt32(bs.length));
            out.write(bs);
        }
        out.write(new byte[]{120});
        List<Thing> fields = thing.getAllAttributesDescriptors();
        if (thing.getString("name") == null || "".equals(thing.getString("name"))) {
            thing.put("name", thing.getMetadata().getName());
        }
        boolean idSetted = false;
        boolean descriptorsSetted = false;
        boolean nameSetted = false;
        boolean labelSetted = false;
        HashMap<String, String> atrContext = new HashMap<String, String>();
        for (Thing field : fields) {
            byte[] vbytes;
            String name = field.getMetadata().getName();
            if (atrContext.get(name) != null) continue;
            atrContext.put(name, name);
            String type = field.getString("type");
            if (name.equals("url")) {
                // empty if block
            }
            if (!idSetted && "id".equals(name)) {
                idSetted = true;
            }
            if (!descriptorsSetted && "descriptors".equals(name)) {
                descriptorsSetted = true;
            }
            if (!nameSetted && "name".equals(name)) {
                nameSetted = true;
            }
            if (!labelSetted && "label".equals(name)) {
                labelSetted = true;
            }
            if ("int".equals(type)) {
                try {
                    int value = thing.getInt(name);
                    XerCoder.encodeName(out, name);
                    out.write(new byte[]{7});
                    out.write(XerCoder.encodeInt32(4));
                    out.write(XerCoder.encodeInt32(value));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("long".equals(type)) {
                try {
                    long value = thing.getLong(name);
                    XerCoder.encodeName(out, name);
                    out.write(new byte[]{14});
                    byte[] vbytes2 = BigInteger.valueOf(value).toByteArray();
                    out.write(XerCoder.encodeInt32(vbytes2.length));
                    out.write(vbytes2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("double".equals(type)) {
                try {
                    double value = thing.getDouble(name);
                    XerCoder.encodeName(out, name);
                    out.write(new byte[]{8});
                    long dvalue = Double.doubleToLongBits(value);
                    byte[] vbytes3 = BigInteger.valueOf(dvalue).toByteArray();
                    out.write(XerCoder.encodeInt32(vbytes3.length));
                    out.write(vbytes3);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("float".equals(type)) {
                try {
                    float value = thing.getFloat(name);
                    XerCoder.encodeName(out, name);
                    out.write(new byte[]{9});
                    long dvalue = Double.doubleToLongBits(value);
                    vbytes = BigInteger.valueOf(dvalue).toByteArray();
                    out.write(XerCoder.encodeInt32(vbytes.length));
                    out.write(vbytes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("bigDecimal".equals(type)) {
                try {
                    BigDecimal value = thing.getBigDecimal(name);
                    if (value == null) continue;
                    XerCoder.encodeName(out, name);
                    out.write(new byte[]{2});
                    String str = value.toString();
                    out.write(XerCoder.encodeInt32(str.length()));
                    out.write(str.getBytes());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("bigInteger".equals(type)) {
                try {
                    BigInteger value = thing.getBigInteger(name);
                    if (value == null) continue;
                    XerCoder.encodeName(out, name);
                    out.write(new byte[]{3});
                    byte[] bvalue = value.toByteArray();
                    out.write(XerCoder.encodeInt32(bvalue.length));
                    out.write(bvalue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("boolean".equals(type)) {
                try {
                    boolean value = thing.getBoolean(name);
                    XerCoder.encodeName(out, name);
                    out.write(new byte[]{4});
                    out.write(XerCoder.encodeInt32(1));
                    out.write(new byte[]{(byte)(value ? 1 : 0)});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("byte".equals(type)) {
                try {
                    byte value = thing.getByte(name);
                    XerCoder.encodeName(out, name);
                    out.write(new byte[]{5});
                    out.write(XerCoder.encodeInt32(1));
                    out.write(new byte[]{value});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("bytes".equals(type)) {
                try {
                    byte[] value = thing.getBytes(name);
                    XerCoder.encodeName(out, name);
                    out.write(new byte[]{6});
                    out.write(XerCoder.encodeInt32(value.length));
                    out.write(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("char".equals(type)) {
                try {
                    char value = thing.getChar(name);
                    XerCoder.encodeName(out, name);
                    out.write(new byte[]{10});
                    out.write(XerCoder.encodeInt32(1));
                    out.write(new byte[]{(byte)value});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("short".equals(type)) {
                try {
                    short value = thing.getShort(name);
                    XerCoder.encodeName(out, name);
                    out.write(new byte[]{11});
                    out.write(XerCoder.encodeInt32(1));
                    out.write(new byte[]{(byte)value});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("date".equals(type) || "datetime".equals(type) || "time".equals(type)) {
                try {
                    Date value = thing.getDate(name);
                    if (value == null) continue;
                    long dvalue = value.getTime();
                    XerCoder.encodeName(out, name);
                    out.write(new byte[]{13});
                    vbytes = BigInteger.valueOf(dvalue).toByteArray();
                    out.write(XerCoder.encodeInt32(vbytes.length));
                    out.write(vbytes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("object".equals(type)) {
                Object value = thing.getAttribute(name);
                if (value == null || !(value instanceof Serializable)) continue;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try {
                    ObjectOutputStream oout = new ObjectOutputStream(bout);
                    oout.writeObject(value);
                    oout.flush();
                    byte[] bs = bout.toByteArray();
                    XerCoder.encodeName(out, name);
                    out.write(new byte[]{12});
                    out.write(XerCoder.encodeInt32(bs.length));
                    out.write(bs);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            String value = thing.getString(name);
            if (value == null) continue;
            XerCoder.encodeName(out, name);
            out.write(new byte[]{1});
            String str = value.toString();
            byte[] bs = str.getBytes(STRING_ENCODING);
            out.write(XerCoder.encodeInt32(bs.length));
            out.write(bs);
        }
        if (!idSetted) {
            XerCoder.encode("id", thing.getMetadata().getId(), "string", out);
        }
        if (!descriptorsSetted) {
            XerCoder.encode("descriptors", thing.getString("descriptors"), "string", out);
        }
        if (!nameSetted) {
            XerCoder.encode("name", thing.getMetadata().getName(), "string", out);
        }
        if (!labelSetted) {
            XerCoder.encode("label", thing.getMetadata().getLabel(), "string", out);
        }
        List<Thing> childs = thing.getChilds();
        for (Thing child : childs) {
            out.write(new byte[]{122});
            XerCoder.encode(child, out, context);
        }
        out.write(new byte[]{121});
    }

    public static void encodeAllx(Thing thing, OutputStream out, Map<Thing, String> context) throws IOException {
        if (context == null) {
            context = new HashMap<Thing, String>();
        }
        if (context.get(thing) != null) {
            return;
        }
        context.put(thing, "aaa");
        int version = thing.getMetadata().getFileVersion();
        String includeDefault = "false";
        if (version != 0) {
            out.write(new byte[]{124});
            out.write(XerCoder.encodeInt32(version));
            switch (version) {
                case 1: {
                    if (includeDefault != null && includeDefault.equals("true")) {
                        out.write(new byte[]{1});
                        break;
                    }
                    out.write(new byte[]{0});
                }
            }
        }
        out.write(new byte[]{120});
        boolean idSetted = false;
        boolean descriptorsSetted = false;
        for (String key : thing.getAttributes().keySet()) {
            Object value = thing.getAttribute(key);
            if (!(value instanceof String)) continue;
            XerCoder.encode(key, value, "string", out);
        }
        if (!idSetted) {
            XerCoder.encode("id", thing.getMetadata().getId(), "string", out);
        }
        if (!descriptorsSetted) {
            XerCoder.encode("descriptors", thing.getString("descriptors"), "string", out);
        }
        List<Thing> childs = thing.getChilds();
        for (Thing child : childs) {
            out.write(new byte[]{122});
            XerCoder.encodeAllx(child, out, context);
        }
        out.write(new byte[]{121});
    }

    public static void encodeName(OutputStream out, String name) throws IOException {
        byte[] ns = name.getBytes(STRING_ENCODING);
        out.write(new byte[]{123});
        out.write(new byte[]{(byte)ns.length});
        out.write(ns);
    }

    public static void encode(String name, Object value, String type, OutputStream out) throws IOException {
        if (value == null) {
            return;
        }
        byte[] ns = name.getBytes(STRING_ENCODING);
        out.write(new byte[]{123});
        out.write(new byte[]{(byte)ns.length});
        out.write(ns);
        if ("string".equals(type) || type == null || "".equals(type)) {
            out.write(new byte[]{1});
            String str = (String)value;
            byte[] bs = str.getBytes(STRING_ENCODING);
            out.write(XerCoder.encodeInt32(bs.length));
            out.write(bs);
        } else if ("bigDecimal".equals(type)) {
            out.write(new byte[]{2});
        }
    }

    public static Thing decode(Thing thing, InputStream input) throws IOException {
        byte[] bytes = new byte[input.available()];
        byte[] buf = new byte[1024];
        int index = 0;
        int size = 0;
        while ((size = input.read(buf)) > 0) {
            System.arraycopy(buf, 0, bytes, index, size);
            index += size;
        }
        if (thing == null) {
            thing = new Thing(null, null, null, false);
        }
        XerCoder.decode(thing, bytes, 0);
        return thing;
    }

    public static int decode(Thing thing, byte[] bytes, int offset) throws IOException {
        if (thing == null) {
            thing = new Thing(null, null, null, false);
        }
        ThingMetadata meta = thing.getMetadata();
        meta.setFileVersion(0);
        while (true) {
            if (bytes[offset] == 124) {
                byte[] valueLS = new byte[4];
                System.arraycopy(bytes, ++offset, valueLS, 0, 4);
                offset += 4;
                int version = XerCoder.decodeInt32(valueLS);
                meta.setFileVersion(version);
                if (version >= 1) {
                    if (bytes[++offset] == 1) {
                        meta.setIncludeDefaultValue(true);
                    } else {
                        meta.setIncludeDefaultValue(false);
                    }
                }
                if (version >= 2) {
                    byte[] timeBytes = new byte[8];
                    System.arraycopy(bytes, offset, timeBytes, 0, 8);
                    offset += 8;
                    long lastModified = XerCoder.decodeLong64(timeBytes);
                    meta.setLastModified(lastModified);
                }
                if (version >= 3) {
                    valueLS = new byte[4];
                    System.arraycopy(bytes, offset, valueLS, 0, 4);
                    offset += 4;
                    int valueLength = XerCoder.decodeInt32(valueLS);
                    try {
                        byte[] valueBytes = new byte[valueLength];
                        System.arraycopy(bytes, offset, valueBytes, 0, valueLength);
                        offset += valueLength;
                        meta.setId(new String(valueBytes, STRING_ENCODING));
                    }
                    catch (Exception e) {
                        offset -= 4;
                    }
                    catch (Error e) {
                        offset -= 4;
                    }
                }
            }
            if (bytes[offset] == 120) {
                ++offset;
                break;
            }
            ++offset;
        }
        while (offset < bytes.length) {
            if (bytes[offset] == 123) {
                byte nameLength = bytes[++offset];
                byte[] nameBytes = new byte[nameLength];
                System.arraycopy(bytes, ++offset, nameBytes, 0, nameLength);
                String name = new String(nameBytes, STRING_ENCODING);
                byte type = bytes[offset += nameLength];
                byte[] valueLS = new byte[4];
                System.arraycopy(bytes, ++offset, valueLS, 0, 4);
                int valueLength = XerCoder.decodeInt32(valueLS);
                byte[] valueBytes = new byte[valueLength];
                System.arraycopy(bytes, offset += 4, valueBytes, 0, valueLength);
                offset += valueLength;
                Object value = null;
                switch (type) {
                    case 1: {
                        value = new String(valueBytes, STRING_ENCODING);
                        break;
                    }
                    case 7: {
                        value = XerCoder.decodeInt32(valueBytes);
                        break;
                    }
                    case 14: {
                        value = new BigInteger(valueBytes).longValue();
                        break;
                    }
                    case 8: {
                        long dv = new BigInteger(valueBytes).longValue();
                        value = Double.longBitsToDouble(dv);
                        break;
                    }
                    case 9: {
                        long dv = new BigInteger(valueBytes).longValue();
                        value = Float.valueOf((float)Double.longBitsToDouble(dv));
                        break;
                    }
                    case 2: {
                        value = new BigDecimal(new String(valueBytes));
                        break;
                    }
                    case 3: {
                        value = new BigInteger(valueBytes);
                        break;
                    }
                    case 4: {
                        if (valueBytes[0] == 1) {
                            value = true;
                            break;
                        }
                        value = false;
                        break;
                    }
                    case 5: {
                        value = valueBytes[0];
                        break;
                    }
                    case 6: {
                        value = valueBytes;
                        break;
                    }
                    case 10: {
                        value = Character.valueOf((char)valueBytes[0]);
                        break;
                    }
                    case 13: {
                        value = new Date(new BigInteger(valueBytes).longValue());
                        break;
                    }
                    case 11: {
                        value = (short)valueBytes[0];
                        break;
                    }
                    case 12: {
                        ByteArrayInputStream bin = new ByteArrayInputStream(valueBytes);
                        ObjectInputStream oin = new ObjectInputStream(bin);
                        try {
                            value = oin.readObject();
                            break;
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                thing.getAttributes().put(name, value);
                if (thing.getMetadata().getId() != null || !"id".equals(name) || value == null) continue;
                thing.getMetadata().setId(value.toString());
                continue;
            }
            if (bytes[offset] == 122) {
                ++offset;
                Thing childObj = new Thing(null, null, null, false);
                offset = XerCoder.decode(childObj, bytes, offset);
                thing.addChild(childObj);
                continue;
            }
            if (bytes[offset] == 121) {
                ++offset;
                break;
            }
            throw new IOException("Unexception code");
        }
        return offset;
    }

    public static Thing decodeAttributeOnly(byte[] bytes, int offset) throws UnsupportedEncodingException {
        Thing xer;
        block6: {
            block5: {
                xer = new Thing(null, null, null, false);
                while (true) {
                    if (bytes[offset] == 120) {
                        ++offset;
                        break;
                    }
                    ++offset;
                }
                while (bytes[offset] == 123) {
                    byte nameLength = bytes[++offset];
                    byte[] nameBytes = new byte[nameLength];
                    System.arraycopy(bytes, ++offset, nameBytes, 0, nameLength);
                    offset += nameLength;
                    String name = new String(nameBytes, STRING_ENCODING);
                    byte[] valueLS = new byte[4];
                    System.arraycopy(bytes, ++offset, valueLS, 0, 4);
                    offset += 4;
                    int valueLength = XerCoder.decodeInt32(valueLS);
                    byte[] valueBytes = new byte[valueLength];
                    try {
                        System.arraycopy(bytes, offset, valueBytes, 0, valueLength);
                    }
                    catch (Exception e) {
                        return xer;
                    }
                    offset += valueLength;
                    String value = new String(valueBytes, STRING_ENCODING);
                    xer.getAttributes().put(name, value);
                }
                if (bytes[offset] != 122) break block5;
                ++offset;
                break block6;
            }
            if (bytes[offset] != 121) break block6;
            ++offset;
        }
        return xer;
    }

    public static byte[] encodeInt32(int value) {
        byte[] bs = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return bs;
    }

    public static byte[] encodeLong64(long value) {
        byte[] bs = new byte[]{(byte)(value >>> 56 & 0xFFL), (byte)(value >>> 48 & 0xFFL), (byte)(value >>> 40 & 0xFFL), (byte)(value >>> 32 & 0xFFL), (byte)(value >>> 24 & 0xFFL), (byte)(value >>> 16 & 0xFFL), (byte)(value >>> 8 & 0xFFL), (byte)(value & 0xFFL)};
        return bs;
    }

    public static int decodeInt32(byte[] bytes) {
        int v = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
        return v;
    }

    public static long decodeLong64(byte[] bytes) {
        long v = ((long)(bytes[0] & 0xFF) << 56 | (long)((bytes[1] & 0xFF) << 48) | (long)((bytes[2] & 0xFF) << 40) | (long)((bytes[3] & 0xFF) << 32)) << 32 | ((long)(bytes[4] & 0xFF) << 24 | (long)((bytes[5] & 0xFF) << 16) | (long)((bytes[6] & 0xFF) << 8) | (long)(bytes[7] & 0xFF));
        return v;
    }

    private static void encodeName(String aname, ByteBuffer buffer) throws UnsupportedEncodingException {
        byte[] bytes = aname.getBytes(STRING_ENCODING);
        buffer.put((byte)(bytes.length & 0xFF));
        buffer.put(bytes);
    }

    public static void encode(Thing thing, ByteBuffer buffer, Map<Thing, String> context) throws IOException {
        if (context == null) {
            context = new HashMap<Thing, String>();
        }
        if (context.get(thing) != null) {
            return;
        }
        context.put(thing, "abcd");
        ThingMetadata meta = thing.getMetadata();
        buffer.put((byte)125);
        buffer.putShort((short)1);
        byte[] bytes = meta.getId().getBytes(STRING_ENCODING);
        buffer.put((byte)(bytes.length & 0xFF));
        buffer.put(bytes);
        buffer.putLong(meta.getLastModified());
        bytes = thing.getString("descriptors", "").getBytes(STRING_ENCODING);
        buffer.putShort((short)(bytes.length & 0xFFFF));
        buffer.put(bytes);
        bytes = thing.getString("extends", "").getBytes(STRING_ENCODING);
        buffer.putShort((short)(bytes.length & 0xFFFF));
        buffer.put(bytes);
        buffer.put((byte)120);
        List<Thing> fields = thing.getAllAttributesDescriptors();
        for (Thing field : fields) {
            String name = field.getMetadata().getName();
            String type = field.getString("type").toLowerCase();
            try {
                if ("int".equals(type)) {
                    XerCoder.encodeName(name, buffer);
                    buffer.put((byte)7);
                    int value = thing.getInt(name);
                    buffer.putInt(value);
                    continue;
                }
                if ("long".equals(type)) {
                    XerCoder.encodeName(name, buffer);
                    buffer.put((byte)14);
                    long value = thing.getLong(name);
                    buffer.putLong(value);
                    continue;
                }
                if ("double".equals(type)) {
                    XerCoder.encodeName(name, buffer);
                    buffer.put((byte)8);
                    buffer.putDouble(thing.getDouble(name));
                    continue;
                }
                if ("float".equals(type)) {
                    XerCoder.encodeName(name, buffer);
                    buffer.put((byte)9);
                    buffer.putFloat(thing.getFloat(name));
                    continue;
                }
                if ("bigDecimal".equals(type)) {
                    BigDecimal value = thing.getBigDecimal(name);
                    if (value == null) continue;
                    XerCoder.encodeName(name, buffer);
                    buffer.put((byte)2);
                    bytes = value.toString().getBytes();
                    buffer.put((byte)(bytes.length & 0xFF));
                    continue;
                }
                if ("bigInteger".equals(type)) {
                    BigInteger value = thing.getBigInteger(name);
                    if (value == null) continue;
                    XerCoder.encodeName(name, buffer);
                    buffer.put((byte)3);
                    bytes = value.toString().getBytes();
                    buffer.put((byte)(bytes.length & 0xFF));
                    continue;
                }
                if ("boolean".equals(type)) {
                    XerCoder.encodeName(name, buffer);
                    buffer.put((byte)4);
                    buffer.put((byte)(thing.getBoolean(name) ? 1 : 0));
                    continue;
                }
                if ("byte".equals(type)) {
                    XerCoder.encodeName(name, buffer);
                    buffer.put((byte)5);
                    buffer.put(thing.getByte(name));
                    continue;
                }
                if ("bytes".equals(type)) {
                    byte[] value = thing.getBytes(name);
                    if (value == null) continue;
                    XerCoder.encodeName(name, buffer);
                    buffer.put((byte)6);
                    buffer.putInt(value.length);
                    buffer.put(value);
                    continue;
                }
                if ("char".equals(type)) {
                    char value = thing.getChar(name);
                    XerCoder.encodeName(name, buffer);
                    buffer.put((byte)10);
                    buffer.putChar(value);
                    continue;
                }
                if ("short".equals(type)) {
                    XerCoder.encodeName(name, buffer);
                    buffer.put((byte)11);
                    buffer.putShort(thing.getShort(name));
                    continue;
                }
                if ("date".equals(type)) {
                    Date value = thing.getDate(name);
                    if (value == null) continue;
                    XerCoder.encodeName(name, buffer);
                    buffer.put((byte)13);
                    buffer.putLong(value.getTime());
                    continue;
                }
                if ("object".equals(type)) {
                    Object value = thing.getAttribute(name);
                    if (value == null || !(value instanceof Serializable)) continue;
                    XerCoder.encodeName(name, buffer);
                    buffer.put((byte)12);
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    ObjectOutputStream oout = new ObjectOutputStream(bout);
                    oout.writeObject(value);
                    oout.flush();
                    byte[] bs = bout.toByteArray();
                    buffer.putInt(bs.length);
                    buffer.put(bs);
                    continue;
                }
                String value = thing.getString(name);
                if (value == null) continue;
                XerCoder.encodeName(name, buffer);
                buffer.put((byte)1);
                bytes = value.getBytes(STRING_ENCODING);
                buffer.putInt(bytes.length);
                buffer.put(bytes);
            }
            catch (Exception e) {
                throw new ActionException("encoding attribute " + name + " error", e);
            }
        }
        List<Thing> childs = thing.getChilds();
        for (Thing child : childs) {
            buffer.put((byte)122);
            XerCoder.encode(child, buffer, context);
        }
        buffer.put((byte)121);
    }
}

