/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.thingManagers;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.xmeta.Thing;
import org.xmeta.World;

public class FileMonitor
extends TimerTask {
    private static FileMonitor instance = null;
    Map<String, FileEntry> things = new ConcurrentHashMap<String, FileEntry>();
    Timer timer = new Timer("Thing file monitor", true);
    World world = World.getInstance();

    private FileMonitor() {
        this.timer.schedule((TimerTask)this, 0L, 10000L);
    }

    public static FileMonitor getInstance() {
        if (instance == null) {
            instance = new FileMonitor();
        }
        return instance;
    }

    public void addFile(String path, Thing thing, File file, boolean monitor) {
        if (thing != null && (monitor || thing.getBoolean("th_fileMonitor"))) {
            FileEntry entry = new FileEntry();
            entry.path = path;
            entry.check = true;
            entry.thingReference = new WeakReference<Thing>(thing);
            entry.file = file;
            entry.lastModified = entry.file.lastModified();
            this.things.put(path, entry);
        }
    }

    public FileEntry getFileEntry(String path) {
        return this.things.get(path);
    }

    public void updateLastModified(FileEntry entry, long lastmodified) {
        entry.lastModified = lastmodified;
    }

    @Override
    public void run() {
        try {
            ArrayList<FileEntry> removed = new ArrayList<FileEntry>();
            for (String key : this.things.keySet()) {
                FileEntry entry = this.things.get(key);
                Thing entryThing = (Thing)entry.thingReference.get();
                if (!entry.file.exists() || entryThing == null) {
                    removed.add(entry);
                    if (entryThing == null) continue;
                    this.changeRemoved(entryThing);
                    continue;
                }
                Thing worldThing = this.world.getThing(entry.path);
                if (entryThing == worldThing && (!entry.check || entry.file.lastModified() == entry.lastModified)) continue;
                this.changeRemoved(entryThing);
                if (worldThing == null) {
                    removed.add(entry);
                    continue;
                }
                entry.thingReference = new WeakReference<Thing>(worldThing);
                entry.lastModified = entry.file.lastModified();
            }
            for (FileEntry entry : removed) {
                if (entry.file.exists() && entry.thingReference.get() != null) continue;
                this.things.remove(entry.path);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void changeRemoved(Thing thing) {
        thing.getMetadata().setRemoved(true);
    }

    public class FileEntry {
        String path;
        public boolean check;
        public File file;
        public long lastModified;
        WeakReference<Thing> thingReference;
    }
}

