/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.thingManagers;

import java.util.ArrayList;
import java.util.Set;
import org.xmeta.Category;
import org.xmeta.ThingIndex;
import org.xmeta.ThingManager;
import org.xmeta.thingManagers.CachedCategory;
import org.xmeta.thingManagers.RedisThingManager;
import redis.clients.jedis.Jedis;

public class RedisCategory
extends CachedCategory {
    public RedisCategory(String name, ThingManager thingManager, Category parent) {
        super(thingManager, parent, name);
        this.refresh();
    }

    @Override
    public String getFilePath() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Jedis jedis = this.getJedis();
        try {
            boolean have;
            String categoryPath = this.name == null || "".equals(this.name) ? "category|" : "category|" + this.name + ".";
            Set categorys = jedis.keys(categoryPath + "*");
            int index = categoryPath.length();
            ArrayList<String> childNames = new ArrayList<String>();
            for (String path : categorys) {
                Category category2;
                if ((path = path.substring(index)).contains(".")) continue;
                childNames.add(path);
                have = false;
                for (Category category2 : this.childCategorys) {
                    if (!category2.getSimpleName().equals(path)) continue;
                    have = true;
                    break;
                }
                if (have) continue;
                Object newCategoryPath = path;
                if (this.name != null && !"".equals(this.name)) {
                    newCategoryPath = this.name + "." + path;
                }
                category2 = new RedisCategory((String)newCategoryPath, this.getThingManager(), this);
                this.childCategorys.add(category2);
            }
            for (int i = 0; i < this.childCategorys.size(); ++i) {
                Category category = (Category)this.childCategorys.get(i);
                have = false;
                for (String path : childNames) {
                    if (!path.equals(category.getSimpleName())) continue;
                    have = true;
                    break;
                }
                if (have) continue;
                this.childCategorys.remove(i);
                --i;
            }
            String thingPath = this.name == null || "".equals(this.name) ? "thing|" : "thing|" + this.name + ".";
            index = thingPath.length();
            Set things = jedis.keys(thingPath + "*");
            childNames = new ArrayList();
            for (String path : things) {
                String thingCode;
                if ((path = path.substring(index)).contains(".")) continue;
                childNames.add(path);
                boolean have2 = false;
                for (ThingIndex thingIndex : this.thingIndexs) {
                    if (!thingIndex.getName().equals(path)) continue;
                    have2 = true;
                    break;
                }
                if (have2 || (thingCode = jedis.get(thingPath = "thing|" + this.name + "." + path)) == null) continue;
                ThingIndex childIndex = new ThingIndex();
                childIndex.name = path;
                childIndex.path = this.name != null && !"".equals(this.name) ? this.name + "." + path : path;
                childIndex.thingManager = this.thingManager;
                childIndex.lastModified = 0L;
                this.thingIndexs.add(childIndex);
            }
            for (int i = 0; i < this.thingIndexs.size(); ++i) {
                ThingIndex thingIndex = (ThingIndex)this.thingIndexs.get(i);
                boolean have3 = false;
                for (String path : childNames) {
                    if (!path.equals(thingIndex.getName())) continue;
                    have3 = true;
                    break;
                }
                if (have3) continue;
                this.thingIndexs.remove(i);
                --i;
            }
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Jedis getJedis() {
        RedisThingManager th = (RedisThingManager)this.getThingManager();
        return th.getJedis();
    }

    public void releaseJedis(Jedis jedis) {
        RedisThingManager th = (RedisThingManager)this.getThingManager();
        th.releaseJedis(jedis);
    }

    @Override
    public void refresh(boolean includeChild) {
        this.refresh();
        if (includeChild) {
            for (Category child : this.childCategorys) {
                child.refresh(includeChild);
            }
        }
    }
}

