/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xmeta.Action;
import org.xmeta.ActionContext;
import org.xmeta.ActionException;
import org.xmeta.Thing;
import org.xmeta.World;
import org.xmeta.util.OgnlUtil;
import org.xmeta.util.UtilDate;
import org.xmeta.util.UtilString;

public class UtilData {
    public static final String VALUE_BLANK = "";
    public static final String VALUE_ONE = "1";
    public static final String VALUE_ZERO = "0";
    public static final String VALUE_FALSE = "false";
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_CURRENT_DATE = "current_date";
    public static final String VALUE_NOW = "now";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_INT = "int";
    public static final String TYPE_INTEGER = "integer";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_SHORT = "short";
    public static final String TYPE_BYTE = "byte";
    public static final String TYPE_BIGDECIMAL = "bigdecimal";
    public static final String TYPE_BIGINTEGER = "biginteger";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_TIME = "time";
    public static final String TYPE_DATETIME = "datetime";
    public static final String TYPE_BYTES = "bytes";
    public static final String TYPE_OBJECT = "object";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static boolean equalsOne(String str, String[] matchs) {
        if (str == null || matchs == null) {
            return false;
        }
        for (String match : matchs) {
            if (!match.equals(str)) continue;
            return true;
        }
        return false;
    }

    public static String format(Object value, String pattern) {
        if (value == null) {
            return VALUE_BLANK;
        }
        if (value instanceof Number) {
            DecimalFormat df = null;
            df = pattern == null || VALUE_BLANK.equals(pattern) ? new DecimalFormat("#.####################") : new DecimalFormat(pattern);
            return df.format(value, new StringBuffer(), new FieldPosition(0)).toString();
        }
        if (value instanceof Date) {
            SimpleDateFormat sf = null;
            sf = pattern == null || VALUE_BLANK.equals(pattern) ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat(pattern);
            return sf.format(value);
        }
        return value.toString();
    }

    public static Object parse(String value, String valueType, String pattern) throws ParseException {
        if (value == null) {
            return null;
        }
        String type = valueType;
        type = type != null ? type.toLowerCase() : TYPE_STRING;
        if (VALUE_BLANK.equals(type) || TYPE_STRING.equals(type)) {
            return value;
        }
        if (VALUE_BLANK.equals(value)) {
            return null;
        }
        if (TYPE_INTEGER.equals(type) || TYPE_LONG.equals(type) || TYPE_FLOAT.equals(type) || TYPE_DOUBLE.equals(type) || TYPE_SHORT.equals(type) || TYPE_BYTE.equals(type)) {
            DecimalFormat df = pattern == null || VALUE_BLANK.equals(pattern) ? new DecimalFormat("#.####################") : new DecimalFormat(pattern);
            Number n = df.parse(value);
            if (TYPE_INTEGER.equals(type)) {
                return n.intValue();
            }
            if (TYPE_LONG.equals(type)) {
                return n.longValue();
            }
            if (TYPE_FLOAT.equals(type)) {
                return Float.valueOf(n.floatValue());
            }
            if (TYPE_DOUBLE.equals(type)) {
                return n.doubleValue();
            }
            if (TYPE_SHORT.equals(type)) {
                return n.shortValue();
            }
            if (TYPE_BYTE.equals(type)) {
                return n.byteValue();
            }
            return null;
        }
        if (TYPE_BIGDECIMAL.equals(type)) {
            return new BigDecimal(value);
        }
        if (TYPE_BIGINTEGER.equals(type)) {
            return new BigInteger(value);
        }
        if (TYPE_BOOLEAN.equals(type)) {
            return !VALUE_FALSE.equalsIgnoreCase(value) && !VALUE_ZERO.equals(value);
        }
        if (TYPE_DATE.equals(type) || TYPE_TIME.equals(type) || TYPE_DATETIME.equals(type)) {
            if (VALUE_CURRENT_DATE.equals(value) || VALUE_NOW.equals(value)) {
                return new Date();
            }
            DateFormat sf = null;
            sf = pattern == null || VALUE_BLANK.equals(pattern) ? (value.length() == 10 ? new SimpleDateFormat("yyyy-MM-dd") : (TYPE_DATE.equals(type) ? SimpleDateFormat.getDateInstance() : (TYPE_TIME.equals(type) ? SimpleDateFormat.getTimeInstance() : SimpleDateFormat.getDateTimeInstance()))) : new SimpleDateFormat(pattern);
            return sf.parse(value);
        }
        return value;
    }

    public static List<Thing> addToSource(List<Thing> source, List<Thing> forAdd, boolean strict) {
        if (forAdd == null) {
            return source;
        }
        if (source == null) {
            source = new ArrayList<Thing>();
        }
        for (Thing fadd : forAdd) {
            UtilData.addToSource(source, fadd, strict);
        }
        return source;
    }

    public static List<Thing> addToSource(List<Thing> source, Thing forAdd, boolean strict) {
        if (forAdd == null) {
            return source;
        }
        if (source == null) {
            source = new ArrayList<Thing>();
        }
        boolean have = false;
        for (Thing src : source) {
            if (src != forAdd) continue;
            have = true;
            break;
        }
        if (!have) {
            source.add(forAdd);
        }
        return source;
    }

    public static BigDecimal getBigDecimal(Object v, BigDecimal defaultValue) {
        if (v == null || VALUE_BLANK.equals(v)) {
            return null;
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        if (v instanceof String) {
            return new BigDecimal((String)v);
        }
        if (v instanceof Integer) {
            return new BigDecimal((Integer)v);
        }
        if (v instanceof Boolean) {
            return new BigDecimal((Boolean)v != false ? 1 : 0);
        }
        if (v instanceof Byte) {
            return new BigDecimal(((Byte)v).byteValue());
        }
        if (v instanceof BigInteger) {
            return new BigDecimal((BigInteger)v);
        }
        if (v instanceof Double) {
            return BigDecimal.valueOf((Double)v);
        }
        if (v instanceof Float) {
            return BigDecimal.valueOf(((Float)v).floatValue());
        }
        if (v instanceof Short) {
            return new BigDecimal(((Short)v).shortValue());
        }
        return defaultValue;
    }

    public static BigInteger getBigInteger(Object v, BigInteger defaultValue) {
        if (v == null || VALUE_BLANK.equals(v)) {
            return null;
        }
        if (v instanceof BigInteger) {
            return (BigInteger)v;
        }
        if (v instanceof String) {
            return new BigInteger((String)v);
        }
        if (v instanceof Integer) {
            return new BigInteger(v.toString());
        }
        if (v instanceof Boolean) {
            return new BigInteger((Boolean)v != false ? VALUE_ONE : VALUE_ZERO);
        }
        if (v instanceof Byte) {
            return new BigInteger(v.toString());
        }
        if (v instanceof BigDecimal) {
            return new BigInteger(v.toString());
        }
        if (v instanceof Double) {
            return new BigInteger(v.toString());
        }
        if (v instanceof Float) {
            return new BigInteger(v.toString());
        }
        if (v instanceof Short) {
            return new BigInteger(v.toString());
        }
        return defaultValue;
    }

    public static byte getByte(Object v, byte defaultValue) {
        if (v == null || VALUE_BLANK.equals(v)) {
            return defaultValue;
        }
        if (v instanceof Number) {
            return ((Number)v).byteValue();
        }
        if (v instanceof String) {
            try {
                return Byte.parseByte((String)v);
            }
            catch (Exception e) {
                if (VALUE_TRUE.equals(v) || "TRUE".equals(v)) {
                    return 1;
                }
                return 0;
            }
        }
        if (v instanceof Boolean) {
            return (byte)((Boolean)v != false ? 1 : 0);
        }
        if (v instanceof BigInteger) {
            return ((BigInteger)v).byteValue();
        }
        if (v instanceof BigDecimal) {
            return ((BigDecimal)v).byteValue();
        }
        return defaultValue;
    }

    public static byte[] getBytes(Object v, byte[] defaultValue) {
        if (v == null || VALUE_BLANK.equals(v)) {
            return null;
        }
        if (v instanceof byte[]) {
            return (byte[])v;
        }
        if (v instanceof String) {
            return ((String)v).getBytes();
        }
        if (v instanceof Serializable) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oout = new ObjectOutputStream(bout);
                oout.writeObject(v);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bout.toByteArray();
        }
        return defaultValue;
    }

    public static char getChar(Object v, char defaultValue) {
        if (v == null || VALUE_BLANK.equals(v)) {
            return defaultValue;
        }
        if (v instanceof Number) {
            return (char)((Number)v).intValue();
        }
        if (v instanceof BigInteger) {
            return (char)((BigInteger)v).intValue();
        }
        if (v instanceof String) {
            return (char)new Integer((String)v).intValue();
        }
        if (v instanceof Boolean) {
            return (char)((Boolean)v != false ? 1 : 0);
        }
        if (v instanceof BigDecimal) {
            return (char)((BigDecimal)v).intValue();
        }
        return defaultValue;
    }

    public static Date getDate(Object v, Date defaultValue) {
        if (v == null || VALUE_BLANK.equals(v)) {
            return null;
        }
        if (v instanceof Date) {
            return (Date)v;
        }
        if (v instanceof Long) {
            return new Date((Long)v);
        }
        if (v instanceof String) {
            String dateStr = (String)v;
            SimpleDateFormat sf = UtilData.getSimpleDateFormat(dateStr);
            try {
                if (sf != null) {
                    return sf.parse((String)v);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            Date date = UtilData.getDateDefault((String)v);
            if (date != null) {
                return date;
            }
        }
        return defaultValue;
    }

    public static Date getDateDefault(String defaultValue) {
        Date date;
        String dateStr = defaultValue = defaultValue.toLowerCase();
        String numberStr = VALUE_BLANK;
        int index = defaultValue.indexOf("+");
        if (index != -1) {
            dateStr = defaultValue.substring(0, index).trim();
            numberStr = defaultValue.substring(index).trim();
        } else {
            index = defaultValue.indexOf("-");
            if (index != -1) {
                dateStr = defaultValue.substring(0, index).trim();
                numberStr = defaultValue.substring(index).trim();
            }
        }
        switch (dateStr) {
            case "now": 
            case "sysdate": {
                date = new Date();
                break;
            }
            case "tomorrow": {
                date = UtilDate.getTomorrow();
                break;
            }
            case "yesterday": {
                date = UtilDate.getYesterday();
                break;
            }
            case "weekstart": {
                date = UtilDate.getWeekStart();
                break;
            }
            case "weekend": {
                date = UtilDate.getWeekEnd();
                break;
            }
            case "monthstart": {
                date = UtilDate.getMonthStart();
                break;
            }
            case "monthend": {
                date = UtilDate.getMonthEnd();
                break;
            }
            case "yearstart": {
                date = UtilDate.getYearStart();
                break;
            }
            case "yearend": {
                date = UtilDate.getYearEnd();
                break;
            }
            default: {
                date = new Date();
                try {
                    double d = Double.parseDouble(dateStr);
                    date = UtilDate.getDate(date, d);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!numberStr.equals(VALUE_BLANK)) {
            try {
                double d = (Double)OgnlUtil.getValue(numberStr, null);
                date = UtilDate.getDate(date, d);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return date;
    }

    public static Date getDate(Object v, Date defaultValue, String pattern) {
        if (v == null || VALUE_BLANK.equals(v)) {
            return null;
        }
        if (v instanceof Date) {
            return (Date)v;
        }
        if (v instanceof String) {
            String value = v.toString().replace("T", " ");
            SimpleDateFormat sf = pattern == null || pattern.equals(VALUE_BLANK) ? UtilData.getSimpleDateFormat(value) : new SimpleDateFormat(pattern);
            try {
                if (sf != null) {
                    return sf.parse(value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                long time = Long.parseLong(value);
                return new Date(time);
            }
            catch (Exception exception) {}
        } else if (v instanceof Long) {
            return new Date((Long)v);
        }
        return defaultValue;
    }

    public static SimpleDateFormat getSimpleDateFormat(String dateStr) {
        if (dateStr.length() == 10) {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
        if (dateStr.length() == 19) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        if (dateStr.length() == 23) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        }
        if (dateStr.length() == 12) {
            return new SimpleDateFormat("HH:mm:ss.SSS");
        }
        if (dateStr.length() == 8) {
            return new SimpleDateFormat("HH:mm:ss");
        }
        if (dateStr.length() == 5) {
            return new SimpleDateFormat("HH:mm");
        }
        if (dateStr.length() == 7) {
            return new SimpleDateFormat("yyyy-MM");
        }
        return null;
    }

    public static double getDouble(Object v, double defaultValue) {
        if (v == null || VALUE_BLANK.equals(v)) {
            return defaultValue;
        }
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        if (v instanceof BigInteger) {
            return ((BigInteger)v).doubleValue();
        }
        if (v instanceof String) {
            return Double.parseDouble((String)v);
        }
        if (v instanceof Boolean) {
            return (byte)((Boolean)v != false ? 1 : 0);
        }
        if (v instanceof BigDecimal) {
            return ((BigDecimal)v).doubleValue();
        }
        return defaultValue;
    }

    public static float getFloat(Object v, float defaultValue) {
        if (v == null || VALUE_BLANK.equals(v)) {
            return defaultValue;
        }
        if (v instanceof Number) {
            return ((Number)v).floatValue();
        }
        if (v instanceof BigInteger) {
            return ((BigInteger)v).floatValue();
        }
        if (v instanceof String) {
            return Float.parseFloat((String)v);
        }
        if (v instanceof Boolean) {
            return (byte)((Boolean)v != false ? 1 : 0);
        }
        if (v instanceof BigDecimal) {
            return ((BigDecimal)v).floatValue();
        }
        return defaultValue;
    }

    public static long getLong(Object v, long defaultValue) {
        if (v == null || VALUE_BLANK.equals(v)) {
            return defaultValue;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        if (v instanceof Number) {
            return ((Number)v).longValue();
        }
        if (v instanceof BigInteger) {
            return ((BigInteger)v).longValue();
        }
        if (v instanceof String) {
            return Long.parseLong((String)v);
        }
        if (v instanceof Integer) {
            return ((Integer)v).longValue();
        }
        if (v instanceof Boolean) {
            return (byte)((Boolean)v != false ? 1 : 0);
        }
        if (v instanceof BigDecimal) {
            return ((BigDecimal)v).longValue();
        }
        return defaultValue;
    }

    public static int getInt(Object v, int defaultValue) {
        if (v == null || VALUE_BLANK.equals(v)) {
            return defaultValue;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        if (v instanceof BigInteger) {
            return ((BigInteger)v).intValue();
        }
        if (v instanceof String) {
            try {
                return Integer.parseInt((String)v);
            }
            catch (Exception e) {
                String vs = ((String)v).toLowerCase();
                if (VALUE_FALSE.equals(vs)) {
                    return 0;
                }
                if (VALUE_TRUE.equals(vs)) {
                    return 1;
                }
                throw new ActionException("Get int error", e);
            }
        }
        if (v instanceof Boolean) {
            return (Boolean)v != false ? 1 : 0;
        }
        if (v instanceof BigDecimal) {
            return ((BigDecimal)v).intValue();
        }
        return defaultValue;
    }

    public static short getShort(Object v, short defaultValue) {
        if (v == null || VALUE_BLANK.equals(v)) {
            return defaultValue;
        }
        if (v instanceof Short) {
            return (Short)v;
        }
        if (v instanceof Number) {
            return ((Number)v).shortValue();
        }
        if (v instanceof BigInteger) {
            return (short)((BigInteger)v).intValue();
        }
        if (v instanceof String) {
            return Short.parseShort((String)v);
        }
        if (v instanceof Boolean) {
            return (short)((Boolean)v != false ? 1 : 0);
        }
        if (v instanceof BigDecimal) {
            return ((BigDecimal)v).shortValue();
        }
        return defaultValue;
    }

    public static boolean getBoolean(Object v, boolean defaultValue) {
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            String value = (String)v;
            if (VALUE_TRUE.equals(value)) {
                return true;
            }
            return VALUE_ONE.equals(value);
        }
        if (v instanceof Number) {
            return ((Number)v).doubleValue() != 0.0;
        }
        if (v != null) {
            return true;
        }
        return defaultValue;
    }

    public static String getString(Object v, String defaultValue) {
        if (v != null) {
            if (v instanceof String) {
                return (String)v;
            }
            return v.toString();
        }
        return defaultValue;
    }

    public static String getSizeInfo(double size) {
        DecimalFormat sf = new DecimalFormat("#.##");
        if (size < 1024.0) {
            return String.valueOf(size) + "B";
        }
        if (size < 1048576.0) {
            return sf.format(size / 1024.0) + "KB";
        }
        return sf.format(size / 1024.0 / 1024.0) + "MB";
    }

    public static byte[] hexStringToByteArray(String hex) {
        if (hex == null) {
            return null;
        }
        int stringLength = hex.length();
        if (stringLength % 2 != 0) {
            throw new IllegalArgumentException("Hex String must have even number of characters!");
        }
        byte[] result = new byte[stringLength / 2];
        int j = 0;
        for (int i = 0; i < result.length; ++i) {
            char hi = Character.toLowerCase(hex.charAt(j++));
            char lo = Character.toLowerCase(hex.charAt(j++));
            result[i] = (byte)(Character.digit(hi, 16) << 4 | Character.digit(lo, 16));
        }
        return result;
    }

    public static String bytesToHexString(byte[] bytes) {
        char[] buf = new char[bytes.length * 2];
        int radix = 16;
        int mask = radix - 1;
        for (int i = 0; i < bytes.length; ++i) {
            buf[2 * i] = hexDigit[bytes[i] >>> 4 & mask];
            buf[2 * i + 1] = hexDigit[bytes[i] & mask];
        }
        return new String(buf);
    }

    public static Object transfer(Object sourceValue, String targetType, String pattern, String patternType, String patternAction) throws ParseException {
        if (pattern != null && !VALUE_BLANK.equals(pattern) && sourceValue != null && !VALUE_BLANK.equals(sourceValue)) {
            if ("parse".equals(patternAction)) {
                return UtilData.parse(sourceValue.toString(), targetType, pattern);
            }
            sourceValue = UtilData.format(sourceValue, pattern);
        }
        Object targetValue = sourceValue;
        if (targetType != null && !VALUE_BLANK.equals(targetType)) {
            switch (targetType) {
                case "byte": {
                    targetValue = UtilData.getByte(sourceValue, (byte)0);
                    break;
                }
                case "short": {
                    targetValue = UtilData.getShort(sourceValue, (short)0);
                    break;
                }
                case "int": {
                    targetValue = (int)UtilData.getLong(sourceValue, 0L);
                    break;
                }
                case "long": {
                    targetValue = UtilData.getLong(sourceValue, 0L);
                    break;
                }
                case "float": {
                    targetValue = Float.valueOf(UtilData.getFloat(sourceValue, 0.0f));
                    break;
                }
                case "double": {
                    targetValue = UtilData.getDouble(sourceValue, 0.0);
                    break;
                }
                case "boolean": {
                    targetValue = UtilData.getBoolean(sourceValue, false);
                    break;
                }
                case "byte[]": {
                    if (sourceValue instanceof String) {
                        targetValue = UtilString.hexStringToByteArray((String)sourceValue);
                        break;
                    }
                    if (sourceValue instanceof byte[]) {
                        targetValue = sourceValue;
                        break;
                    }
                    targetValue = null;
                    break;
                }
                case "hex_byte[]": {
                    if (sourceValue instanceof byte[]) {
                        targetValue = UtilString.toHexString((byte[])sourceValue);
                        break;
                    }
                    if (sourceValue instanceof String) {
                        targetValue = sourceValue;
                        break;
                    }
                    targetValue = null;
                    break;
                }
                default: {
                    targetValue = sourceValue;
                }
            }
        }
        return targetValue;
    }

    public static Object getObject(Thing thing, String attributeName, ActionContext actionContext) {
        Object obj = UtilData.getData(thing, attributeName, actionContext);
        if (obj instanceof String) {
            obj = actionContext.get((String)obj);
        }
        return obj;
    }

    public static <T> T get(Thing thing, String attributeName, ActionContext actionContext) {
        Object obj = UtilData.getData(thing, attributeName, actionContext);
        if (obj instanceof String) {
            obj = actionContext.get((String)obj);
        }
        return (T)obj;
    }

    public static <T> T getObjectByType(Thing thing, String attributeName, Class<T> t, ActionContext actionContext) {
        Object obj = UtilData.getObject(thing, attributeName, actionContext);
        if (t.isInstance(obj)) {
            return (T)obj;
        }
        return null;
    }

    public static Thing getThing(Thing thing, String attributeName, ActionContext actionContext) {
        Object obj = UtilData.getData(thing, attributeName, actionContext);
        if (obj instanceof Thing) {
            return (Thing)obj;
        }
        if (obj instanceof String) {
            return World.getInstance().getThing((String)obj);
        }
        if (obj != null) {
            return World.getInstance().getThing(obj.toString());
        }
        return null;
    }

    public static Thing getThing(Thing thing, String attributeName, String childThingPath, ActionContext actionContext) {
        Thing th = UtilData.getThing(thing, attributeName, actionContext);
        if (th == null && childThingPath != null) {
            return thing.getThing(childThingPath);
        }
        return th;
    }

    public static Object getData(Thing thing, String attributeName, ActionContext actionContext) {
        Object value = thing.get(attributeName);
        if (value instanceof String) {
            String str = (String)value;
            if (str.startsWith("var:")) {
                return actionContext.get(str.substring(4));
            }
            if (str.startsWith("ognl:")) {
                return OgnlUtil.getValue(thing, attributeName, actionContext);
            }
            if (str.startsWith("thing:")) {
                String thingPath = str.substring(6);
                return World.getInstance().getThing(thingPath);
            }
            if (str.startsWith("action:")) {
                String thingPath = str.substring(7);
                Action action = World.getInstance().getAction(thingPath);
                if (action != null) {
                    return action.run(actionContext);
                }
                return null;
            }
            if (VALUE_BLANK.equals(str)) {
                return null;
            }
            return UtilString.getString(str, actionContext);
        }
        return value;
    }

    public static Object getData(String value, ActionContext actionContext) {
        if (value.startsWith("var:")) {
            return actionContext.get(value.substring(4));
        }
        if (value.startsWith("ognl:")) {
            return OgnlUtil.getValue(value.substring(5), (Object)actionContext);
        }
        if (value.startsWith("thing:")) {
            String thingPath = value.substring(6);
            return World.getInstance().getThing(thingPath);
        }
        if (value.startsWith("int:")) {
            return Integer.parseInt(value.substring(4));
        }
        if (value.startsWith("byte:")) {
            return Byte.parseByte(value.substring(5));
        }
        if (value.startsWith("float:")) {
            return Float.valueOf(Float.parseFloat(value.substring(6)));
        }
        if (value.startsWith("double:")) {
            return Double.parseDouble(value.substring(7));
        }
        if (value.startsWith("string:")) {
            return value.substring(7);
        }
        if (value.startsWith("long:")) {
            return Long.parseLong(value.substring(5));
        }
        if (value.startsWith("bool:")) {
            return Boolean.parseBoolean(value.substring(5));
        }
        if (value.startsWith("char:")) {
            return Character.valueOf((char)Short.parseShort(value.substring(5)));
        }
        if (value.startsWith("short:")) {
            return Short.parseShort(value.substring(6));
        }
        if (VALUE_BLANK.equals(value)) {
            return null;
        }
        return UtilString.getString(value, actionContext);
    }

    public static boolean isTrue(Object condition) {
        return UtilData.isTrue(condition, false);
    }

    public static boolean isTrue(Object condition, boolean defaultValue) {
        boolean ok = false;
        if (condition != null) {
            if (condition instanceof Boolean) {
                ok = (Boolean)condition;
            } else if (condition instanceof String) {
                String str = ((String)condition).toLowerCase().trim();
                ok = VALUE_TRUE.equals(str) | VALUE_ONE.equals(str);
            } else {
                Number n;
                ok = condition instanceof Number ? (n = (Number)condition).intValue() == 1 : true;
            }
        } else {
            ok = defaultValue;
        }
        return ok;
    }

    public static String getString(Thing thing, String attributeName, ActionContext actionContext) {
        return UtilString.getString(thing, attributeName, actionContext);
    }

    public static void resetAttributeByType(Thing thing, String name, String type) {
        if (TYPE_INT.equals(type)) {
            try {
                thing.getAttributes().put(name, thing.getInt(name));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (TYPE_LONG.equals(type)) {
            try {
                thing.getAttributes().put(name, thing.getLong(name));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (TYPE_DOUBLE.equals(type)) {
            try {
                thing.getAttributes().put(name, thing.getDouble(name));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (TYPE_FLOAT.equals(type)) {
            try {
                thing.getAttributes().put(name, Float.valueOf(thing.getFloat(name)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("bigDecimal".equals(type)) {
            try {
                thing.getAttributes().put(name, thing.getBigDecimal(name));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("bigInteger".equals(type)) {
            try {
                thing.getAttributes().put(name, thing.getBigInteger(name));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (TYPE_BOOLEAN.equals(type)) {
            try {
                thing.getAttributes().put(name, thing.getBoolean(name));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (TYPE_BYTE.equals(type)) {
            try {
                thing.getAttributes().put(name, thing.getByte(name));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (TYPE_BYTES.equals(type)) {
            try {
                thing.getAttributes().put(name, thing.getBytes(name));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("char".equals(type)) {
            try {
                thing.getAttributes().put(name, Character.valueOf(thing.getChar(name)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (TYPE_SHORT.equals(type)) {
            try {
                thing.getAttributes().put(name, thing.getShort(name));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (TYPE_DATE.equals(type) || TYPE_DATETIME.equals(type) || TYPE_TIME.equals(type)) {
            try {
                thing.getAttributes().put(name, thing.getDate(name));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

