package org.xmeta.ui.session;

import java.io.Serializable;
import java.util.*;

public class DefaultSession extends AbstractSession {
	Map<Object, Object> values = new HashMap<>();
	Date startTimestamp = new Date();
	Date lastAccessTime = new Date();
	long timeout = 30 * 3600000;

	public Object getAttribute(Object name) {
		return values.get(name);
	}

	public void setAttribute(Object name, Object value) {
		values.put(name, value);
	}

	@Override
	public Object removeAttribute(Object key) {
		return values.remove(key);
	}

	@Override
	public boolean hasRole(String role) {
		return true;
	}

	@Override
	public boolean hasAllRoles(Collection<String> roleIdentifiers) {
		return true;
	}

	@Override
	public boolean[] hasRoles(List<String> roleIdentifiers) {
		boolean[] bs =  new boolean[roleIdentifiers.size()];
		Arrays.fill(bs, true);

		return bs;
	}

	@Override
	public boolean[] isPermitted(String... permissions) {
		boolean[] bs =  new boolean[permissions.length];
		Arrays.fill(bs, true);

		return bs;
	}

	@Override
	public boolean[] isPermitted(List<String> permissions) {
		boolean[] bs =  new boolean[permissions.size()];
		Arrays.fill(bs, true);

		return bs;
	}

	@Override
	public boolean isPermittedAll(String... permissions) {
		return true;
	}

	@Override
	public boolean isPermittedAll(Collection<String> permissions) {
		return true;
	}

	@Override
	public boolean isPermitted(String permission) {
		return true;
	}

	@Override
	public <T> T getPrincipal() {
		return null;
	}

	@Override
	public Serializable getId() {
		return 0;
	}

	@Override
	public Date getStartTimestamp() {
		return startTimestamp;
	}

	@Override
	public Date getLastAccessTime() {
		return lastAccessTime;
	}

	@Override
	public long getTimeout() {
		return timeout;
	}

	@Override
	public void setTimeout(long maxIdleTimeInMillis) {
		this.timeout = maxIdleTimeInMillis;
	}

	@Override
	public String getHost() {
		return "127.0.0.1";
	}

	@Override
	public void touch() {
		lastAccessTime = new Date();
	}

	@Override
	public void stop() {

	}

	@Override
	public Collection<Object> getAttributeKeys() {
		return values.keySet();
	}
}
