/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.xmeta.Category;
import org.xmeta.Thing;
import org.xmeta.ThingManager;
import org.xmeta.index.WorldIndex;

public abstract class Index {
    private static Index index = null;
    public static final String TYPE_WORLD = "world";
    public static final String TYPE_PROJECTS = "projects";
    public static final String TYPE_PLUGINS = "plugins";
    public static final String TYPE_CHILDWORLDS = "childWorlds";
    public static final String TYPE_PROJECT = "project";
    public static final String TYPE_THINGMANAGER = "thingManager";
    public static final String TYPE_CATEGORY = "category";
    public static final String TYPE_THING = "thing";
    public static final String TYPE_WORKING_SET = "workingSet";
    public static final String TYPE_FILE = "file";
    protected boolean indexed = false;
    private static String workingSetThing = "_local.xworker.worldExplorer.WorkingSet";

    public static synchronized Index getInstance() {
        if (index == null) {
            index = new WorldIndex();
        }
        return index;
    }

    public static String getIndexId(Index index) {
        StringBuilder id = new StringBuilder(index.getType() + "|" + index.getName());
        for (Index parent = index.getParent(); parent != null; parent = parent.getParent()) {
            id.insert(0, parent.getType() + "|" + parent.getName() + ".");
        }
        return id.toString();
    }

    public static Index getIndexById(String id) {
        Index parent = Index.getInstance();
        if (id == null || "".equals(id)) {
            return parent;
        }
        String path = parent.getType() + "|" + parent.getName();
        while (parent != null) {
            if (id.equals(path)) {
                return parent;
            }
            boolean have = false;
            for (Index child : parent.getChilds()) {
                String childPath = path + "." + child.getType() + "|" + child.getName();
                if (id.equals(childPath)) {
                    return child;
                }
                if (!id.startsWith(childPath + ".")) continue;
                path = childPath;
                parent = child;
                have = true;
                break;
            }
            if (have) continue;
            break;
        }
        return null;
    }

    public static Index getIndex(String type, String path) {
        return Index.getIndex(Index.getInstance(), type, path);
    }

    public static Index getIndex(Index index, String type, String path) {
        if (index == null || type == null || path == null) {
            return null;
        }
        if (index.getType().equals(type) && index.getPath().equals(path)) {
            return index;
        }
        for (Index child : index.getChilds()) {
            Index result = Index.getIndex(child, type, path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public abstract Object getIndexObject();

    public abstract Index getParent();

    public abstract List<Index> getChilds();

    public abstract String getDescription();

    public abstract String getLabel();

    public abstract String getName();

    public abstract String getPath();

    public abstract String getType();

    public abstract boolean refresh();

    public long getLastModified() {
        return 0L;
    }

    public String getLastDate() {
        long time = this.getLastModified();
        if (time == 0L) {
            return "";
        }
        Date date = new Date(time);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sf.format(date);
    }

    public static String getWorkingSetThing() {
        return workingSetThing;
    }

    public static void setWorkingSetThing(String workingSetThing) {
        Index.workingSetThing = workingSetThing;
    }

    public static Index findIndex(Thing thing) {
        String[] paths;
        Index index = Index.findIndex(thing.getMetadata().getThingManager());
        if (index == null) {
            return null;
        }
        String path = thing.getMetadata().getPath();
        int offset = path.lastIndexOf(".");
        if (offset != -1) {
            path = path.substring(0, offset);
        }
        block0: for (String name : paths = path.split("[.]")) {
            for (Index child : index.getChilds()) {
                if (!child.getType().equals(TYPE_CATEGORY) || !child.getName().equals(name)) continue;
                index = child;
                continue block0;
            }
        }
        return index;
    }

    public static Index findIndex(ThingManager thingManager) {
        Index index = Index.getInstance();
        for (Index child : index.getChilds()) {
            if (child.getIndexObject() == thingManager) {
                return child;
            }
            for (Index cchild : child.getChilds()) {
                if (cchild.getIndexObject() != thingManager) continue;
                return cchild;
            }
        }
        return null;
    }

    public static Index findIndex(Category category) {
        String[] paths;
        Index index = Index.findIndex(category.getThingManager());
        if (index == null) {
            return null;
        }
        String path = category.getName();
        block0: for (String name : paths = path.split("[.]")) {
            for (Index child : index.getChilds()) {
                if (!child.getType().equals(TYPE_CATEGORY) || !child.getName().equals(name)) continue;
                index = child;
                continue block0;
            }
        }
        return index;
    }
}

