/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.cache;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xmeta.Thing;

public class ThingCache {
    private static final Map<String, SoftReference<Thing>> cache = new ConcurrentHashMap<String, SoftReference<Thing>>(600);
    private static final Map<String, Map<String, String>> labelCache = new HashMap<String, Map<String, String>>();
    private static final Map<String, Map<String, String>> descCache = new HashMap<String, Map<String, String>>();

    public static String getLabel(String thingPath, String lang) {
        Map<String, String> lcache = labelCache.get(lang);
        if (lcache != null) {
            return lcache.get(thingPath);
        }
        return null;
    }

    public static void putLabel(String thingPath, String lang, String label) {
        Map lcache = labelCache.computeIfAbsent(lang, k -> new HashMap());
        lcache.put(thingPath, label);
    }

    public static String getDesc(String thingPath, String lang) {
        Map<String, String> lcache = descCache.get(lang);
        if (lcache != null) {
            return lcache.get(thingPath);
        }
        return null;
    }

    public static void putDesc(String thingPath, String lang, String desc) {
        Map lcache = descCache.computeIfAbsent(lang, k -> new HashMap());
        lcache.put(thingPath, desc);
    }

    public static Thing get(String path) {
        SoftReference<Thing> wr = cache.get(path);
        if (wr == null) {
            return null;
        }
        Thing thing = wr.get();
        if (thing == null) {
            cache.remove(path);
        } else if (thing.getMetadata().isRemoved()) {
            cache.remove(path);
            thing = null;
        }
        return thing;
    }

    public static void put(String path, Thing thing) {
        SoftReference<Thing> wr = cache.get(path);
        if (wr == null || wr.get() == null) {
            wr = new SoftReference<Thing>(thing);
            cache.put(path, wr);
        }
    }

    public static void remove(String path) {
        if (path != null) {
            cache.remove(path);
        }
    }

    public static void clear() {
        cache.clear();
    }
}

