/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.codes;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmeta.Thing;
import org.xmeta.ThingCoder;
import org.xmeta.ThingIndex;
import org.xmeta.XMetaException;
import org.xmeta.codes.CoderUtils;
import org.xmeta.codes.XmlCoder;

public class JsonThingCoder
implements ThingCoder {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String codeType = "xer.js";

    @Override
    public void encode(Thing thing, OutputStream out) {
        try {
            mapper.writeValue(out, (Object)thing);
        }
        catch (Exception e) {
            throw new XMetaException("Encode thing to json error", e);
        }
    }

    @Override
    public void decode(Thing thing, InputStream in, long lastModifyed) {
        try {
            Thing readThing = (Thing)mapper.readValue(in, Thing.class);
            thing.getAttributes().putAll(readThing.getAttributes());
            for (Thing child : readThing.getChilds()) {
                thing.addChild(child);
            }
            XmlCoder.initDefaultValues(thing);
            XmlCoder.setLastModified(thing, lastModifyed);
        }
        catch (Exception e) {
            throw new XMetaException("decode json thing error", e);
        }
    }

    @Override
    public void decodeIndex(ThingIndex thingIndex, InputStream in, long lastModifyed) {
        try {
            Thing thing = (Thing)mapper.readValue(in, Thing.class);
            thingIndex.name = thing.getMetadata().getName();
            thingIndex.description = thing.getString("description");
            thingIndex.descriptors = thing.getString("descriptors");
            thingIndex.extendsStr = thing.getString("extends");
            thingIndex.label = thing.getString("label");
            thingIndex.lastModified = lastModifyed;
        }
        catch (Exception e) {
            throw new XMetaException("decode json thing error", e);
        }
    }

    @Override
    public String getType() {
        return codeType;
    }

    @Override
    public boolean acceptType(String type) {
        return codeType.equals(type);
    }

    @Override
    public String[] getCodeTypes() {
        return new String[]{codeType};
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Thing.class, (JsonDeserializer)new JsonDeserializer<Thing>(){

            public Thing deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
                Map valueMap = (Map)deserializationContext.readValue(jsonParser, HashMap.class);
                return this.createThing(valueMap);
            }

            private Thing createThing(Map<String, Object> valueMap) {
                Thing thing = new Thing();
                String id = (String)valueMap.remove("_xmeta_id_");
                List children = (List)valueMap.remove("_xmeta_children_");
                thing.getAttributes().putAll(valueMap);
                if (thing.valueExists("_xmtea_last_modified_")) {
                    thing.getMetadata().setLastModified(thing.getLong("_xmtea_last_modified_"));
                }
                if (children != null && children.size() > 0) {
                    for (Map childMap : children) {
                        Thing child = this.createThing(childMap);
                        thing.addChild(child);
                    }
                }
                if (id != null && !id.isEmpty()) {
                    thing.getMetadata().setId(id);
                } else {
                    thing.getMetadata().setId(thing.getMetadata().getName());
                }
                return thing;
            }
        });
        module.addSerializer(Thing.class, (JsonSerializer)new JsonSerializer<Thing>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serialize(Thing thing, JsonGenerator jgen, SerializerProvider pro) throws IOException {
                jgen.writeStartObject();
                try {
                    List<Thing> children;
                    String idValue;
                    String value;
                    boolean descriptorsWrited = false;
                    boolean extendsWrited = false;
                    List<Thing> attributes = thing.getAllAttributesDescriptors();
                    for (Thing attribute : attributes) {
                        String key = attribute.getMetadata().getName();
                        if ("descriptors".equals(key)) {
                            descriptorsWrited = true;
                        } else if ("extends".equals(key)) {
                            extendsWrited = true;
                        }
                        Object value2 = thing.getAttribute(key);
                        String defaultValue = attribute.getStringBlankAsNull("default");
                        if (defaultValue == null && (value2 == null || "".equals(value2)) || defaultValue != null && CoderUtils.isDefault(attribute, value2 == null ? null : value2.toString()) || value2 == null) continue;
                        jgen.writeFieldName(key);
                        pro.defaultSerializeValue(value2, jgen);
                    }
                    if (!descriptorsWrited && (value = thing.getStringBlankAsNull("descriptors")) != null) {
                        jgen.writeFieldName("descriptors");
                        pro.defaultSerializeValue((Object)value, jgen);
                    }
                    if (!extendsWrited && (value = thing.getStringBlankAsNull("extends")) != null) {
                        jgen.writeFieldName("extends");
                        pro.defaultSerializeValue((Object)value, jgen);
                    }
                    if ((idValue = thing.getMetadata().getId()) != null && !idValue.equals(thing.getMetadata().getName())) {
                        jgen.writeFieldName("_xmeta_id_");
                        pro.defaultSerializeValue((Object)idValue, jgen);
                    }
                    if ((children = thing.getChilds()).size() > 0) {
                        jgen.writeFieldName("_xmeta_children_");
                        pro.defaultSerializeValue(thing.getChilds(), jgen);
                    }
                }
                finally {
                    jgen.writeEndObject();
                }
            }
        });
        mapper.registerModule((Module)module);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    }
}

