/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmeta.Index;
import org.xmeta.Thing;
import org.xmeta.ThingManager;
import org.xmeta.World;
import org.xmeta.index.IndexFactory;
import org.xmeta.index.ThingManagerIndex;
import org.xmeta.index.WorkingSetIndex;
import org.xmeta.thingManagers.TransientThingManager;

public class WorldIndex
extends Index {
    List<Index> childs = null;
    public boolean showWorkingSet = true;

    public List<Index> getThingManagerIndexs() {
        ArrayList<Index> thlist = new ArrayList<Index>();
        HashMap<String, String> context = new HashMap<String, String>();
        this.getThingManagerIndexs(context, this, thlist);
        return thlist;
    }

    private void getThingManagerIndexs(Map<String, String> context, Index index, List<Index> list) {
        block6: {
            block5: {
                if (!"thingManager".equals(index.getType())) break block5;
                if (context.get(index.getPath()) != null) break block6;
                list.add(index);
                context.put(index.getPath(), index.getPath());
                break block6;
            }
            if ("world".equals(index.getType())) {
                for (Index child : index.getChilds()) {
                    this.getThingManagerIndexs(context, child, list);
                }
            } else if ("workingSet".equals(index.getType())) {
                for (Index child : index.getChilds()) {
                    this.getThingManagerIndexs(context, child, list);
                }
            }
        }
    }

    public WorldIndex() {
        this.refresh();
    }

    @Override
    public Object getIndexObject() {
        return World.getInstance();
    }

    @Override
    public Index getParent() {
        return null;
    }

    @Override
    public List<Index> getChilds() {
        if (!this.indexed) {
            this.refresh();
        }
        return this.childs;
    }

    @Override
    public String getDescription() {
        return "Projects";
    }

    @Override
    public String getLabel() {
        return "Project";
    }

    @Override
    public String getName() {
        return "Projects";
    }

    @Override
    public String getPath() {
        return "";
    }

    @Override
    public String getType() {
        return "world";
    }

    @Override
    public boolean refresh() {
        this.indexed = true;
        if (this.childs == null) {
            this.childs = new ArrayList<Index>();
        }
        World.getInstance().refresh();
        if (this.showWorkingSet) {
            Thing workingSet = World.getInstance().getThing(Index.getWorkingSetThing());
            if (workingSet != null) {
                IndexFactory.addOrRemoveChilds(this, this.childs, workingSet.getChilds(), IndexFactory.workingSetIndexFactory, "workingSet");
            } else {
                IndexFactory.addOrRemoveChilds(this, this.childs, Collections.emptyList(), IndexFactory.workingSetIndexFactory, "workingSet");
            }
        } else {
            IndexFactory.addOrRemoveChilds(this, this.childs, Collections.emptyList(), IndexFactory.workingSetIndexFactory, "workingSet");
        }
        HashMap<String, Index> context = new HashMap<String, Index>();
        for (Index childIndex : this.childs) {
            this.initWorkingSetThingManagers(childIndex, context);
        }
        ArrayList<ThingManager> thingManagers = new ArrayList<ThingManager>();
        for (ThingManager thingManager : World.getInstance().getThingManagers()) {
            if (context.get(thingManager.getName()) != null || thingManager instanceof TransientThingManager) continue;
            thingManagers.add(thingManager);
        }
        IndexFactory.addOrRemoveChilds(this, this.childs, thingManagers, IndexFactory.thingManagerIndexFactory, "thingManager");
        WorldIndex.sort(this.childs);
        return true;
    }

    private void initWorkingSetThingManagers(Index workingSetIndex, Map<String, Index> thingManagers) {
        if (workingSetIndex instanceof WorkingSetIndex) {
            WorkingSetIndex wsetIndex = (WorkingSetIndex)workingSetIndex;
            for (Index childIndex : wsetIndex.getChilds()) {
                if (childIndex instanceof ThingManagerIndex) {
                    thingManagers.put(childIndex.getName(), childIndex);
                    continue;
                }
                if (!(childIndex instanceof WorkingSetIndex)) continue;
                this.initWorkingSetThingManagers(childIndex, thingManagers);
            }
        }
    }

    public static void sort(List<Index> indexs) {
        indexs.sort((o1, o2) -> {
            if ("workingSet".equals(o1.getType()) && "thingManager".equals(o2.getType())) {
                return -1;
            }
            if ("thingManager".equals(o1.getType()) && "workingSet".equals(o2.getType())) {
                return 1;
            }
            if ("category".equals(o1.getType()) && "thing".equals(o2.getType())) {
                return -1;
            }
            if ("category".equals(o2.getType()) && "thing".equals(o1.getType())) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        });
    }
}

