/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.thingManagers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.xmeta.Category;
import org.xmeta.Thing;
import org.xmeta.ThingIndex;
import org.xmeta.ThingManager;
import org.xmeta.World;
import org.xmeta.XMetaException;
import org.xmeta.thingManagers.IteratorStackEntry;
import org.xmeta.util.ThingClassLoader;

public abstract class CachedCategory
implements Category {
    protected List<Category> childCategorys = new ArrayList<Category>();
    protected List<ThingIndex> thingIndexs = new ArrayList<ThingIndex>();
    protected Category parent;
    protected String name;
    protected ThingManager thingManager;
    protected boolean refreshed = false;
    protected ThingClassLoader classLoader = null;

    public CachedCategory(ThingManager thingManager, Category parent, String name) {
        this.thingManager = thingManager;
        this.parent = parent;
        this.name = name;
    }

    private void checkRefresh() {
        if (!this.refreshed) {
            this.refreshed = true;
            this.refresh(false);
        }
    }

    @Override
    public Category getCategory(String name) {
        this.checkRefresh();
        for (Category child : this.childCategorys) {
            if (!child.getSimpleName().equals(name)) continue;
            return child;
        }
        return null;
    }

    @Override
    public List<Category> getCategorys() {
        this.checkRefresh();
        return this.childCategorys;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Category getParent() {
        return this.parent;
    }

    @Override
    public String getSimpleName() {
        if (this.name == null) {
            return null;
        }
        int index = this.name.lastIndexOf(".");
        if (index == -1) {
            return this.name;
        }
        return this.name.substring(index + 1, this.name.length());
    }

    @Override
    public Thing getThing(String thingName) {
        this.checkRefresh();
        if (this.name != null && !this.name.equals("")) {
            return World.getInstance().getThing(this.name + "." + thingName);
        }
        return World.getInstance().getThing(thingName);
    }

    @Override
    public List<ThingIndex> getThingIndexs() {
        this.checkRefresh();
        return this.thingIndexs;
    }

    @Override
    public List<ThingIndex> getThingIndexs(String descriptor) {
        this.checkRefresh();
        if (descriptor == null || "".equals(descriptor)) {
            return this.thingIndexs;
        }
        ArrayList<ThingIndex> indexs = new ArrayList<ThingIndex>();
        block0: for (ThingIndex index : this.thingIndexs) {
            if (index.descriptors == null) continue;
            for (String desc : index.descriptors.split("[,]")) {
                if (!desc.equals(descriptor)) continue;
                indexs.add(index);
                continue block0;
            }
        }
        return indexs;
    }

    @Override
    public ThingManager getThingManager() {
        return this.thingManager;
    }

    @Override
    public List<Thing> getThings() {
        this.checkRefresh();
        ArrayList<Thing> things = new ArrayList<Thing>();
        for (ThingIndex index : this.thingIndexs) {
            Thing thing = World.getInstance().getThing(index.path);
            if (thing == null) continue;
            things.add(thing);
        }
        return things;
    }

    @Override
    public List<Thing> getThings(String descriptor) {
        this.checkRefresh();
        ArrayList<Thing> things = new ArrayList<Thing>();
        block0: for (ThingIndex index : this.thingIndexs) {
            if (index.descriptors == null) continue;
            for (String desc : index.descriptors.split("[,]")) {
                if (!desc.equals(descriptor)) continue;
                Thing thing = World.getInstance().getThing(index.path);
                if (thing == null) continue block0;
                things.add(thing);
                continue block0;
            }
        }
        return things;
    }

    @Override
    public Iterator<Thing> iterator(boolean includeChildCategory) {
        return this.iterator(null, includeChildCategory);
    }

    @Override
    public Iterator<Thing> iterator(final String descriptorPath, boolean includeChildCategory) {
        this.checkRefresh();
        final CachedCategory category = this;
        return new Iterator<Thing>(){
            Thing current;
            Stack<IteratorStackEntry> stacks = new Stack();
            {
                IteratorStackEntry root = new IteratorStackEntry();
                root.category = category;
                root.thingIndex = 0;
                root.categoryIndex = 0;
                this.stacks.push(root);
            }

            private void initNextThing() {
                while (this.stacks.size() > 0 && this.current == null) {
                    IteratorStackEntry entry = this.stacks.peek();
                    List<ThingIndex> thingIndexs = entry.thingIndexs;
                    if (thingIndexs == null) {
                        entry.thingIndexs = thingIndexs = entry.category.getThingIndexs(descriptorPath);
                    }
                    if (entry.thingIndex < thingIndexs.size()) {
                        this.current = World.getInstance().getThing(thingIndexs.get((int)entry.thingIndex).path);
                        ++entry.thingIndex;
                        return;
                    }
                    List<Category> categorys = entry.categorys;
                    if (categorys == null) {
                        entry.categorys = categorys = entry.category.getCategorys();
                    }
                    if (entry.categoryIndex < categorys.size()) {
                        Category category2 = categorys.get(entry.categoryIndex);
                        IteratorStackEntry aentry = new IteratorStackEntry();
                        aentry.category = category2;
                        aentry.thingIndex = 0;
                        aentry.categoryIndex = 0;
                        ++entry.categoryIndex;
                        this.stacks.push(aentry);
                        continue;
                    }
                    this.stacks.pop();
                }
            }

            @Override
            public boolean hasNext() {
                if (this.current != null) {
                    return true;
                }
                this.initNextThing();
                return this.current != null;
            }

            @Override
            public Thing next() {
                if (this.current == null) {
                    this.initNextThing();
                }
                Thing temp = this.current;
                this.current = null;
                return temp;
            }

            @Override
            public void remove() {
                throw new XMetaException("not supported");
            }
        };
    }

    public void addCategory(Category category) {
        this.childCategorys.add(category);
    }

    public void addThingIndex(ThingIndex thingIndex) {
        this.thingIndexs.add(thingIndex);
    }

    @Override
    public ThingClassLoader getClassLoader() {
        if (this.classLoader == null) {
            Category parent = this.getParent();
            if (parent == null) {
                if (this.thingManager != null) {
                    return this.thingManager.getClassLoader();
                }
                return World.getInstance().getClassLoader();
            }
            return parent.getClassLoader();
        }
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ThingClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

