/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Map;
import ognl.AbstractMemberAccess;
import ognl.ClassResolver;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlException;
import org.xmeta.ActionException;
import org.xmeta.Thing;
import org.xmeta.util.OgnlClassResolver;

public class OgnlUtil {
    private static final String CACHE = "__ognl_attrPathCache_";
    private static final ThreadLocal<Map<?, ?>> ognlContextLocal = new ThreadLocal();

    private static Map<?, ?> getOgnlContext() {
        Map ognlContext = ognlContextLocal.get();
        if (ognlContext == null) {
            AbstractMemberAccess memberAccess = new AbstractMemberAccess(){

                public boolean isAccessible(Map context, Object target, Member member, String propertyName) {
                    int modifiers = member.getModifiers();
                    return Modifier.isPublic(modifiers);
                }
            };
            ognlContext = Ognl.createDefaultContext(null, (MemberAccess)memberAccess, (ClassResolver)new OgnlClassResolver(), null);
            ognlContextLocal.set(ognlContext);
        }
        return ognlContext;
    }

    public static Object getValue(Object tree, Object root) {
        try {
            return Ognl.getValue((Object)tree, OgnlUtil.getOgnlContext(), (Object)root);
        }
        catch (OgnlException e) {
            throw new ActionException(e);
        }
    }

    public static Object getValue(String expression, Object root) {
        try {
            return Ognl.getValue((String)expression, OgnlUtil.getOgnlContext(), (Object)root);
        }
        catch (OgnlException e) {
            throw new ActionException(e);
        }
    }

    public static void setValue(Object tree, Object root, Object value) {
        try {
            Ognl.setValue((Object)tree, OgnlUtil.getOgnlContext(), (Object)root, (Object)value);
        }
        catch (OgnlException e) {
            throw new ActionException(e);
        }
    }

    public static void setValue(String expression, Object root, Object value) {
        try {
            Ognl.setValue((String)expression, OgnlUtil.getOgnlContext(), (Object)root, (Object)value);
        }
        catch (OgnlException e) {
            throw new ActionException(e);
        }
    }

    public static Object getValue(Thing thing, String pathAttributeName, Object root) {
        PathCache pathCache = OgnlUtil.getPathCache(thing, pathAttributeName);
        if (pathCache == null) {
            return null;
        }
        return OgnlUtil.getValue(pathCache.expression, root);
    }

    public static Object getValue(Thing thing, String pathAttributeName, String pathAttributeValue, Object root) {
        PathCache pathCache = OgnlUtil.getPathCache(thing, pathAttributeName);
        if (pathCache == null) {
            return null;
        }
        return OgnlUtil.getValue(pathCache.expression, root);
    }

    public static PathCache getPathCache(Thing thing, String attributeName) {
        String key = CACHE + attributeName;
        PathCache pathCache = (PathCache)thing.getData(key);
        if (pathCache == null || pathCache.lastModified != thing.getMetadata().getLastModified()) {
            String path = thing.getStringBlankAsNull(attributeName);
            if (path == null) {
                return null;
            }
            if (pathCache == null) {
                pathCache = new PathCache();
            }
            pathCache.lastModified = thing.getMetadata().getLastModified();
            if (path.startsWith("ognl:")) {
                path = path.substring(5);
            }
            try {
                pathCache.expression = Ognl.parseExpression((String)path);
            }
            catch (OgnlException e) {
                throw new ActionException(e);
            }
            thing.setData(key, pathCache);
        }
        return pathCache;
    }

    public static Object getCachedExpression(Thing thing, String attributeName) {
        PathCache pathCache = OgnlUtil.getPathCache(thing, attributeName);
        return pathCache.expression;
    }

    public static void setValue(Thing thing, String pathAttributeName, String pathAttributeValue, Object value, Object root) {
        if (pathAttributeValue == null || "".equals(pathAttributeValue)) {
            return;
        }
        String key = CACHE + pathAttributeName;
        PathCache pathCache = (PathCache)thing.getData(key);
        if (pathCache == null || pathCache.lastModified != thing.getMetadata().getLastModified()) {
            if (pathCache == null) {
                pathCache = new PathCache();
                thing.setData(key, pathCache);
            }
            pathCache.lastModified = thing.getMetadata().getLastModified();
            try {
                pathCache.expression = Ognl.parseExpression((String)pathAttributeValue);
            }
            catch (OgnlException e) {
                throw new ActionException(e);
            }
        }
        OgnlUtil.setValue(pathCache.expression, root, value);
    }

    static class PathCache {
        long lastModified;
        Object expression;

        PathCache() {
        }
    }
}

