/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.xmeta.util.Resources;

public class UtilResource {
    static Map<String, UtilResource> resouceCache = new HashMap<String, UtilResource>();
    Map<String, Resources> cache = new HashMap<String, Resources>();
    Locale locale = null;

    public static UtilResource getInstance(Locale locale) {
        UtilResource res;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((res = resouceCache.get(locale.toString())) == null) {
            res = new UtilResource(locale);
            resouceCache.put(locale.toString(), res);
        }
        return res;
    }

    public static UtilResource getDefaultInstance() {
        Locale locale = Locale.getDefault();
        return UtilResource.getInstance(locale);
    }

    public UtilResource(Locale locale) {
        this.locale = locale;
    }

    public Resources get(String name) {
        Resources rs = this.cache.get(name);
        if (rs == null) {
            try {
                rs = new Resources(name, this.locale);
                this.cache.put(name, rs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rs;
    }

    public String get(String resourceName, String name, String defaultValue) {
        Resources rs = this.get(resourceName);
        if (rs == null) {
            return defaultValue;
        }
        return rs.get(name, defaultValue);
    }

    public static void clear() {
        try {
            for (String key : resouceCache.keySet()) {
                UtilResource ur = resouceCache.get(key);
                ur.clearCache();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearCache() {
        for (String key : this.cache.keySet()) {
            Resources r = this.cache.get(key);
            r.clear();
        }
    }
}

