package org.xmeta;

import org.xmeta.thingManagers.FileThingManager;
import org.xmeta.util.UtilFile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

/**
 * 当模型引擎作为系统全局引擎时，代表引擎外执行的模型应用。
 */
public class Application {
    private static Application instance;

    File rootDirectory;

    File sourceDirectory;

    Properties properties;

    private Application(){

    }

    public File getRootDirectory() {
        return rootDirectory;
    }

    public File getSourceDirectory() {
        return sourceDirectory;
    }

    public Properties getProperties() {
        return properties;
    }

    public static Application getInstance(){
        return instance;
    }

    /**
     * 初始化。如果之前已经初始化，忽略。在file所在目录或父目录（递归)找.dml文件，如果存在那么初始化，如果不存在使用file所在目录初始化。
     *
     * @param file 模型文件或目录
     */
    public static Application init(File file) throws IOException {
        if(instance != null){
            return instance;
        }

        File root = getRoot(file);
        if(root == null){
            if(file.isDirectory()){
                root = file;
            } else {
                root = file.getParentFile();
            }
        }

        Properties properties1 = new Properties();
        File dmlFile = new File(root, ".dml");
        if(dmlFile.exists()){
            try(FileInputStream fin = new FileInputStream(dmlFile)){
                properties1.load(fin);
            }
        }

        File sourceDir = root;
        String source = properties1.getProperty("source");
        if(source != null){
            File sourceD = new File(root, source);
            if(sourceD.exists()){
                sourceDir = sourceD;
            }
        }

        instance = new Application();
        instance.properties = properties1;
        instance.rootDirectory = root;
        instance.sourceDirectory = sourceDir;

        //把模型项目添加到XWorker中，作为第一个项目
        String projectName = properties1.getProperty("projectName");
        if(projectName == null){
            //模型项目配置.dml没有配置项目名，使用根目录生成一个，为避免重复生成一个复杂的
            projectName = UtilFile.getThingManagerNameByDir(root);
        }
        FileThingManager thingManager = new FileThingManager(projectName, sourceDir, false);
        World.getInstance().addThingManagerFirst(thingManager);

        return instance;
    }

    /**
     * 通过文件获取指定模型的路径。
     *
     * @param thingFile 模型文件
     * @return 路径
     */
    public String getThingPath(File thingFile) throws IOException {
        String source = sourceDirectory.getCanonicalPath();
        String thingPath = thingFile.getCanonicalPath();

        if(thingPath.startsWith(source)){
            if(thingPath.equals(source)){
                return "";
            }

            thingPath = thingPath.substring(source.length() + 1);
            int index = thingPath.lastIndexOf(".");
            if(index != -1){
                thingPath = thingPath.substring(0, index);
            }
            thingPath = thingPath.replace('/', '.');
            thingPath = thingPath.replace('\\', '.');

            return thingPath;
        } else {
            //不在应用的目录下
            return null;
        }
    }

    static File getRoot(File file){
        if(file.isDirectory()){
            File dml = new File(file, ".dml");
            if(dml.exists()){
                return file;
            } else {
                File parent = file.getParentFile();
                if(parent != null && parent.isDirectory()){
                    return getRoot(parent);
                } else {
                    return null;
                }
            }
        } else {
            return getRoot(file.getParentFile());
        }
    }
}
