package org.xmeta;

import java.util.ArrayList;
import java.util.List;

/**
 * 为上下文提供变量的。比如提供数据库数据源，自动提交和释放数据源等。
 */
public abstract class ContextVarProvider implements ActionListener{
    /**
     * 查找是否之前的ContextProvider已经提供了相同key的变量了。比如同一个数据源应该只需要设置一次，不用重复获取。
     *
     * @param id 变量的ID
     * @param executor 动作监听的执行器
     * @return 如果存在返回该变量，否则返回Null
     */
    public Object findPreContextVar(String id, ActionListenerExecutor executor) {
        for (int i=0; i<executor.getCurrentIndex(); i++) {
            ActionListener listener = executor.getActionListener(i);
            if (listener instanceof ContextVarProvider) {
                ContextVarProvider provider = (ContextVarProvider) listener;
                Object var = provider.getContextVarById(id);
                if (var != null) {
                    return var;
                }
            }
        }

        return null;
    }

    public Object getContextVarById(String id) {
        String varId = getId();
        if (varId != null && varId.equalsIgnoreCase(id)) {
            return getVar();
        }

        return null;
    }

    public abstract String getId();

    public abstract Object getVar();
}
