/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.xmeta.Action;
import org.xmeta.ActionListener;
import org.xmeta.ActionListenerExecutor;
import org.xmeta.ActionListenerProvider;
import org.xmeta.Bindings;
import org.xmeta.Thing;
import org.xmeta.ThingActionListenerProvider;
import org.xmeta.World;
import org.xmeta.util.UtilData;

public class ActionContext
implements Map<String, Object> {
    public static final int RUNNING = 0;
    public static final int RETURN = 1;
    public static final int CANCEL = 2;
    public static final int BREAK = 3;
    public static final int CONTINUE = 4;
    public static final int EXCEPTION = 5;
    public static final String RESULT_SUCCESS = "success";
    public static final String RESULT_FAILURE = "failure";
    public static final String RUNTYPE_DEFAULT = "DEFAULT";
    public static final String RUNTYPE_SUCCESS = "SUCCESS";
    public static final String RUNTYPE_RANDOM = "RANDOM";
    public static final String RUNTYPE_RANDOM_ONE = "RANDOM_ONE";
    public static final String RUNTYPE_RANDOM_RANDOM = "RANDOM_RANDOM";
    public static final String RUNTYPE_RANDOM_SUCCESS = "RANDOM_SUCCESS";
    public static final String RUNTYPE_RANDOM_RATE = "RANDOM_RATE";
    public static final String PARENT_CONTEXT = "parentContext";
    private static final ThreadLocal<Map<ActionContext, ActionContext>> toStringContextLocal = new ThreadLocal();
    private final ThreadLocal<Stack<Bindings>> threadStacks = new ThreadLocal();
    private final ThreadLocal<Integer> threadStatus = new ThreadLocal();
    private final ThreadLocal<Object> threadThrownObject = new ThreadLocal();
    private final Stack<Bindings> baseStacks = new Stack();
    private Thread createThread = null;
    private int dummyScopeCount = 0;
    private final ThreadLocal<Stack<Action>> actionStacks = new ThreadLocal();
    private String label = null;

    public ActionContext() {
        this((Bindings)null);
    }

    public ActionContext(boolean managedByPool) {
        this((Bindings)null);
    }

    public ActionContext(ActionContext actionContext) {
        this.createThread = Thread.currentThread();
        for (Bindings binding : actionContext.getScopes()) {
            this.baseStacks.push(binding);
            ++this.dummyScopeCount;
        }
        Bindings bindings = this.push(null);
        bindings.put("actionContext", this);
        bindings.put("_g", bindings);
    }

    public ActionContext(Bindings bindings) {
        this.createThread = Thread.currentThread();
        Bindings bds = this.push(bindings);
        bds.put("actionContext", this);
        bds.put("_g", bds);
    }

    private Stack<Action> getActionStack() {
        Stack<Action> actionStack = this.actionStacks.get();
        if (actionStack == null) {
            actionStack = new Stack();
            this.actionStacks.set(actionStack);
        }
        return actionStack;
    }

    public void pushAction(Action action) {
        this.getActionStack().push(action);
    }

    public void popAction() {
        this.getActionStack().pop();
    }

    public Action getAction() {
        return this.getActionStack().peek();
    }

    public boolean exists(String ... vars) {
        if (vars != null) {
            for (String var : vars) {
                if (this.get(var) != null) continue;
                return false;
            }
        }
        return true;
    }

    public void initActionListener(ActionListenerExecutor executor) {
        Stack<Bindings> stack = this.threadStacks.get();
        if (stack == null) {
            for (Bindings bindings : this.baseStacks) {
                ActionListener listener;
                ActionListenerProvider provider = bindings.getActionListenerProvider();
                if (provider == null || (listener = provider.createActionListener(this)) == null) continue;
                executor.addListener(listener);
            }
        } else {
            for (Bindings bindings : stack) {
                ActionListener listener;
                ActionListenerProvider provider = bindings.getActionListenerProvider();
                if (provider == null || (listener = provider.createActionListener(this)) == null) continue;
                executor.addListener(listener);
            }
        }
    }

    private Stack<Bindings> getBindingStack() {
        Stack<Bindings> stack = this.threadStacks.get();
        if (stack == null) {
            if (this.createThread == Thread.currentThread()) {
                return this.baseStacks;
            }
            stack = new Stack();
            for (int i = 0; i < this.dummyScopeCount + 1; ++i) {
                stack.push((Bindings)this.baseStacks.get(i));
            }
            this.threadStacks.set(stack);
        }
        return stack;
    }

    public int getStatus() {
        Integer status = this.threadStatus.get();
        if (status == null) {
            return 0;
        }
        return status;
    }

    public boolean isDisableGlobalContext() {
        for (Bindings bindings : this.getBindingStack()) {
            if (!bindings.disableGlobalContext) continue;
            return true;
        }
        return false;
    }

    public void setStatus(int status) {
        this.threadStatus.set(status);
    }

    public void _break() {
        this.setStatus(3);
    }

    public void _continue() {
        this.setStatus(4);
    }

    public void _return(Object obj) {
        this.setStatus(1);
    }

    public void _exception(Object throwedObject) {
        this.setStatus(5);
        this.setThrowedObject(throwedObject);
    }

    public Bindings push() {
        return this.push(null);
    }

    public Bindings push(Bindings bindings) {
        if (bindings == null) {
            bindings = new Bindings();
        }
        Stack<Bindings> stacks = this.getBindingStack();
        stacks.push(bindings);
        return bindings;
    }

    public Bindings pushPoolBindings() {
        return this.push(new Bindings());
    }

    public Bindings peek() {
        return this.getBindingStack().peek();
    }

    public Bindings pop() {
        return this.getBindingStack().pop();
    }

    public List<Bindings> getScopes() {
        ArrayList<Bindings> bindings = new ArrayList<Bindings>();
        Stack<Bindings> bindingsStack = this.getBindingStack();
        for (int i = 0; i < bindingsStack.size(); ++i) {
            bindings.add((Bindings)bindingsStack.get(i));
        }
        return bindings;
    }

    public Bindings getScope() {
        Stack<Bindings> bindingsStack = this.getBindingStack();
        for (int i = bindingsStack.size() - 1; i >= 0; --i) {
            Bindings bindings = (Bindings)bindingsStack.get(i);
            if (!bindings.isVarScopeFlag()) continue;
            return bindings;
        }
        return null;
    }

    public Bindings getLocalScope() {
        return this.getScope();
    }

    public Bindings getGlobalScope() {
        return this.getScope(0);
    }

    public Bindings g() {
        return this.getScope(0);
    }

    public Bindings l() {
        return this.getScope();
    }

    public Bindings l(int index) {
        int c = 0;
        Stack<Bindings> bindingsStack = this.getBindingStack();
        for (int i = bindingsStack.size() - 1; i >= 0; --i) {
            Bindings bindings = (Bindings)bindingsStack.get(i);
            if (!bindings.isVarScopeFlag()) continue;
            if (c == index) {
                return bindings;
            }
            ++c;
        }
        return null;
    }

    public void trace() {
        Thing thing = World.getInstance().getThing("xworker.lang.context.DebugContext");
        if (thing != null) {
            this.peek().setActionListenerProvider(new ThingActionListenerProvider(thing));
        }
    }

    public String getStackTrace() {
        Stack<Bindings> bindingsStack = this.getBindingStack();
        StringBuilder content = new StringBuilder("ActionContext stacktrace, thread=" + Thread.currentThread().getName() + ":");
        for (int i = bindingsStack.size() - 1; i >= 0; --i) {
            String method;
            String stack = "";
            Bindings bindings = (Bindings)bindingsStack.get(i);
            if (bindings.getCaller() != null) {
                Object caller = bindings.getCaller();
                stack = caller instanceof Thing ? stack + "thing: " + ((Thing)caller).getMetadata().getPath() : (caller instanceof Action ? stack + "action: " + ((Action)caller).getThing().getMetadata().getPath() : stack + "object: " + caller.getClass());
            }
            if ((method = bindings.getCallerMethod()) != null && !method.isEmpty()) {
                stack = stack + ", method: " + method;
            }
            if (bindings.getContexts() != null) {
                StringBuilder values = new StringBuilder();
                for (Thing key : bindings.getContexts().keySet()) {
                    values.append(key.getMetadata().getPath()).append(",");
                }
                if (values.length() > 0) {
                    stack = stack + ", contexts: " + values;
                }
            }
            if (stack.isEmpty()) continue;
            content.append("\n    ").append(stack);
        }
        return content.toString();
    }

    public void printStackTrace() {
        System.out.println(this.getStackTrace());
    }

    public Bindings getScope(int index) {
        return (Bindings)this.getBindingStack().get(index + this.dummyScopeCount);
    }

    public Bindings getScope(String actionThingPath) {
        if (actionThingPath == null) {
            return null;
        }
        if ("Global".equals(actionThingPath)) {
            return this.getScope(0);
        }
        if ("Local".equals(actionThingPath)) {
            Stack<Bindings> bindingsStack = this.getBindingStack();
            return bindingsStack.peek();
        }
        try {
            int stack = Integer.parseInt(actionThingPath);
            return this.getScope(stack);
        }
        catch (Exception e) {
            Stack<Bindings> bindingsStack = this.getBindingStack();
            for (int i = bindingsStack.size() - 1; i >= 0; --i) {
                Thing thing;
                Action action;
                while (i >= bindingsStack.size()) {
                    --i;
                }
                Bindings bindings = (Bindings)bindingsStack.get(i);
                if (!(bindings.getCaller() instanceof Action ? actionThingPath.equals((action = (Action)bindings.getCaller()).getThing().getMetadata().getPath()) || actionThingPath.equals(action.getThing().getMetadata().getName()) : bindings.getCaller() instanceof Thing && ((thing = (Thing)bindings.getCaller()) != null && actionThingPath.equals(thing.getMetadata().getPath()) || actionThingPath.equals(thing.getMetadata().getName())))) continue;
                return bindings;
            }
            return null;
        }
    }

    public int getScopesSize() {
        return this.getBindingStack().size() - this.dummyScopeCount;
    }

    public int getScopesSizeAll() {
        return this.getBindingStack().size();
    }

    @Override
    public void clear() {
        this.getBindingStack().peek().clear();
    }

    @Override
    public boolean containsKey(Object key) {
        boolean ck = false;
        Stack<Bindings> bindingsStack = this.getBindingStack();
        for (int i = bindingsStack.size() - 1; i >= 0; --i) {
            while (i >= bindingsStack.size()) {
                --i;
            }
            if (!((Bindings)bindingsStack.get(i)).containsKey(key)) continue;
            ck = true;
            break;
        }
        return ck;
    }

    @Override
    public boolean containsValue(Object value) {
        Stack<Bindings> bindingsStack = this.getBindingStack();
        for (int i = bindingsStack.size() - 1; i >= 0; --i) {
            while (i >= bindingsStack.size()) {
                --i;
            }
            if (!((Bindings)bindingsStack.get(i)).containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashMap map = new HashMap();
        Stack<Bindings> bindingsStack = this.getBindingStack();
        for (int i = 0; i < bindingsStack.size(); ++i) {
            map.putAll((Map)bindingsStack.get(i));
        }
        return map.entrySet();
    }

    @Override
    public Object get(Object key) {
        if (key == null || "".equals(key)) {
            return null;
        }
        Object value = null;
        Stack<Bindings> bindingsStack = this.getBindingStack();
        for (int i = bindingsStack.size() - 1; i >= 0; --i) {
            while (i >= bindingsStack.size()) {
                --i;
            }
            Map map = (Map)bindingsStack.get(i);
            value = map.get(key);
            if (value != null || map.containsKey(key)) break;
        }
        return value;
    }

    public Object getParameter(Object key) {
        if (key == null || "".equals(key)) {
            return null;
        }
        Object value = null;
        Stack<Bindings> bindingsStack = this.getBindingStack();
        for (int i = bindingsStack.size() - 1; i >= 0; --i) {
            Map map;
            while (i >= bindingsStack.size()) {
                --i;
            }
            if (((Bindings)bindingsStack.get(i)).isParameterScope() && ((value = (map = (Map)bindingsStack.get(i)).get(key)) != null || map.containsKey(key))) break;
        }
        return value;
    }

    public Object get(Object key, String scopeThingPath) {
        Stack<Bindings> bindingsStack = this.getBindingStack();
        for (int i = bindingsStack.size() - 1; i >= 0; --i) {
            while (i >= bindingsStack.size()) {
                --i;
            }
            Bindings bindings = (Bindings)bindingsStack.get(i);
            Thing currentThing = null;
            if (bindings.getCaller() instanceof Action) {
                currentThing = ((Action)bindings.getCaller()).getThing();
            }
            if (currentThing == null || !scopeThingPath.equals(currentThing.getMetadata().getPath())) continue;
            return bindings.get(key);
        }
        return null;
    }

    public List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Bindings bindings : this.getBindingStack()) {
            if (!(bindings.getCaller() instanceof Action)) continue;
            actions.add((Action)bindings.getCaller());
        }
        return actions;
    }

    public List<Thing> getThings() {
        ArrayList<Thing> things = new ArrayList<Thing>();
        for (Bindings bindings : this.getBindingStack()) {
            if (!(bindings.getCaller() instanceof Thing)) continue;
            things.add((Thing)bindings.getCaller());
        }
        return things;
    }

    @Override
    public boolean isEmpty() {
        Stack<Bindings> bindingsStack = this.getBindingStack();
        for (int i = bindingsStack.size() - 1; i >= 0; --i) {
            if (((Bindings)bindingsStack.get(i)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> aset = new HashSet<String>();
        for (int i = this.getBindingStack().size() - 1; i >= 0; --i) {
            aset.addAll(((Bindings)this.getBindingStack().get(i)).keySet());
        }
        return aset;
    }

    @Override
    public Object put(String key, Object value) {
        Stack<Bindings> bindingsStack = this.getBindingStack();
        for (int i = bindingsStack.size() - 1; i >= this.dummyScopeCount; --i) {
            Bindings bindings = (Bindings)bindingsStack.get(i);
            if (!bindings.containsKey(key)) continue;
            return bindings.put(key, value);
        }
        Object v = this.getScope(0).put(key, value);
        return v;
    }

    public Object put(String key, Object value, String scopeThingPath) {
        Stack<Bindings> bindingsStack = this.getBindingStack();
        for (int i = bindingsStack.size() - 1; i >= this.dummyScopeCount; --i) {
            Bindings bindings = (Bindings)bindingsStack.get(i);
            Thing currentThing = null;
            if (bindings.getCaller() instanceof Action) {
                currentThing = ((Action)bindings.getCaller()).getThing();
            }
            if (currentThing == null || !scopeThingPath.equals(currentThing.getMetadata().getPath())) continue;
            return bindings.put(key, value);
        }
        return null;
    }

    public Object putTo(String key, String scopeThingPath) {
        Object value = this.get(key);
        return this.put(key, value, scopeThingPath);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (String string : m.keySet()) {
            this.put(string, m.get(string));
        }
    }

    @Override
    public Object remove(Object key) {
        return this.getBindingStack().peek().remove(key);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String key : this.keySet()) {
            list.add(this.get(key));
        }
        return list;
    }

    public void setThrowedObject(Object obj) {
        this.threadThrownObject.set(obj);
    }

    public Object getThrowedObject() {
        return this.threadThrownObject.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        HashMap context = new HashMap();
        toStringContextLocal.set(context);
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getStackTrace());
            sb.append("\n");
            sb.append("ActionContext [hashCode=" + this.hashCode() + "]\n");
            this.initVarsString(sb, "");
            String string = sb.toString();
            return string;
        }
        finally {
            toStringContextLocal.set(null);
        }
    }

    private void initVarsString(StringBuffer sb, String ident) {
        Map<ActionContext, ActionContext> context = toStringContextLocal.get();
        if (context.get(this) != null) {
            return;
        }
        context.put(this, this);
        for (String key : this.keySet()) {
            Object value = this.get(key);
            sb.append(ident + "  ");
            sb.append(key + "=");
            if (value instanceof ActionContext) {
                ActionContext ac = (ActionContext)value;
                sb.append("ActionContext [hashCode=" + this.hashCode() + "]");
                ac.initVarsString(sb, ident + "  ");
            } else {
                sb.append(String.valueOf(value));
            }
            sb.append("\n");
            if (sb.length() <= 0x100000) continue;
            sb.append(ident + ".....");
            break;
        }
    }

    public String getString(String key) {
        return UtilData.getString(this.get(key), null);
    }

    public byte getByte(String key) {
        return UtilData.getByte(this.get(key), (byte)0);
    }

    public short getShort(String key) {
        return UtilData.getShort(this.get(key), (short)0);
    }

    public int getInt(String key) {
        return UtilData.getInt(this.get(key), 0);
    }

    public long getLong(String key) {
        return UtilData.getLong(this.get(key), 0L);
    }

    public boolean getBoolean(String key) {
        return UtilData.getBoolean(this.get(key), false);
    }

    public byte[] getBytes(String key) {
        return UtilData.getBytes(this.get(key), null);
    }

    public Date getDate(String key) {
        return UtilData.getDate(this.get(key), null);
    }

    public double getDouble(String key) {
        return UtilData.getDouble(this.get(key), 0.0);
    }

    public float getFloat(String key) {
        return UtilData.getFloat(this.get(key), 0.0f);
    }

    public BigDecimal getBigDecimal(String key) {
        return UtilData.getBigDecimal(this.get(key), null);
    }

    public BigInteger getBigInteger(String key) {
        return UtilData.getBigInteger(this.get(key), null);
    }

    public <T> T getObject(String key) {
        Object obj = this.get(key);
        return (T)obj;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

