/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmeta.Action;
import org.xmeta.ActionContext;
import org.xmeta.ActionListener;
import org.xmeta.Thing;

public class ActionListenerExecutor {
    private static final Logger log = Logger.getLogger(ActionListenerExecutor.class.getName());
    private final List<ActionListener> listenerList = new ArrayList<ActionListener>();
    private int index = -1;

    protected void addListener(ActionListener actionListener) {
        this.listenerList.add(actionListener);
    }

    protected void addListener(List<ActionListener> actionListeners) {
        this.listenerList.addAll(actionListeners);
    }

    public int getCurrentIndex() {
        return this.index;
    }

    public int getListenerCount() {
        return this.listenerList.size();
    }

    public ActionListener getActionListener(int index) {
        return this.listenerList.get(index);
    }

    protected void doOnDoAction(Thing thing, String actionName, Action action, ActionContext actionContext, Map<String, Object> params) throws Exception {
        while (this.index < this.listenerList.size() - 1) {
            ++this.index;
            ActionListener listener = this.listenerList.get(this.index);
            listener.onDoAction(thing, actionName, action, actionContext, params, this);
        }
    }

    protected void doOnDoActionFinished(Thing thing, String actionName, Action action, ActionContext actionContext, Map<String, Object> params, Object result) throws Exception {
        while (this.index >= 0) {
            ActionListener listener = this.listenerList.get(this.index);
            try {
                listener.onDoActionFinished(thing, actionName, action, actionContext, params, this, result);
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "ActionListener onDoActionFinished exception, name=" + listener.getName(), t);
            }
            --this.index;
        }
    }

    protected void doOnInit(Action action, Object caller, ActionContext actionContext, Map<String, Object> params) throws Exception {
        while (this.index < this.listenerList.size() - 1) {
            ++this.index;
            ActionListener listener = this.listenerList.get(this.index);
            listener.onInit(action, caller, actionContext, params, this);
        }
    }

    protected Throwable doOnSuccess(Action action, Object caller, ActionContext actionContext, Object result) {
        while (this.index >= 0) {
            ActionListener listener = this.listenerList.get(this.index);
            try {
                listener.onSuccess(action, caller, actionContext, result, this);
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "ActionListener onSuccess exception, name=" + listener.getName(), t);
                --this.index;
                return this.doOnException(action, caller, actionContext, t);
            }
            --this.index;
        }
        return null;
    }

    protected Throwable doOnException(Action action, Object caller, ActionContext actionContext, Throwable t) {
        Throwable throwable = t;
        while (this.index >= 0) {
            ActionListener listener = this.listenerList.get(this.index);
            try {
                listener.onException(action, caller, actionContext, throwable, this);
            }
            catch (Throwable tt) {
                log.log(Level.WARNING, "ActionListener doOnException exception, name=" + listener.getName(), t);
                throwable = tt;
            }
            --this.index;
        }
        return throwable;
    }
}

