/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.xmeta.World;
import org.xmeta.thingManagers.FileThingManager;
import org.xmeta.util.UtilFile;

public class Application {
    private static Application instance;
    File rootDirectory;
    File sourceDirectory;
    Properties properties;

    private Application() {
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static Application getInstance() {
        return instance;
    }

    public static Application init(File file) throws IOException {
        File sourceD;
        if (instance != null) {
            return instance;
        }
        File root = Application.getRoot(file);
        if (root == null) {
            root = file.isDirectory() ? file : file.getParentFile();
        }
        Properties properties1 = new Properties();
        File dmlFile = new File(root, ".dml");
        if (dmlFile.exists()) {
            try (FileInputStream fin = new FileInputStream(dmlFile);){
                properties1.load(fin);
            }
        }
        File sourceDir = root;
        String source = properties1.getProperty("source");
        if (source != null && (sourceD = new File(root, source)).exists()) {
            sourceDir = sourceD;
        }
        instance = new Application();
        Application.instance.properties = properties1;
        Application.instance.rootDirectory = root;
        Application.instance.sourceDirectory = sourceDir;
        String projectName = properties1.getProperty("projectName");
        if (projectName == null) {
            projectName = UtilFile.getThingManagerNameByDir(root);
        }
        FileThingManager thingManager = new FileThingManager(projectName, sourceDir, false);
        World.getInstance().addThingManagerFirst(thingManager);
        return instance;
    }

    public String getThingPath(File thingFile) throws IOException {
        String source = this.sourceDirectory.getCanonicalPath();
        String thingPath = thingFile.getCanonicalPath();
        if (thingPath.startsWith(source)) {
            if (thingPath.equals(source)) {
                return "";
            }
            int index = (thingPath = thingPath.substring(source.length() + 1)).lastIndexOf(".");
            if (index != -1) {
                thingPath = thingPath.substring(0, index);
            }
            thingPath = thingPath.replace('/', '.');
            thingPath = thingPath.replace('\\', '.');
            return thingPath;
        }
        return null;
    }

    static File getRoot(File file) {
        if (file.isDirectory()) {
            File dml = new File(file, ".dml");
            if (dml.exists()) {
                return file;
            }
            File parent = file.getParentFile();
            if (parent != null && parent.isDirectory()) {
                return Application.getRoot(parent);
            }
            return null;
        }
        return Application.getRoot(file.getParentFile());
    }
}

