/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.index;

import java.util.HashMap;
import java.util.List;
import org.xmeta.Category;
import org.xmeta.Index;
import org.xmeta.Thing;
import org.xmeta.ThingIndex;
import org.xmeta.ThingManager;
import org.xmeta.index.CategoryIndex;
import org.xmeta.index.ThingIndexIndex;
import org.xmeta.index.ThingManagerIndex;
import org.xmeta.index.WorkingSetIndex;

public abstract class IndexFactory {
    public static IndexFactory thingIndexFactory = new IndexFactory(){

        @Override
        public Index createIndex(Index parent, Object obj) {
            return new ThingIndexIndex(parent, (ThingIndex)obj);
        }

        @Override
        public String getName(Object obj) {
            return ((ThingIndex)obj).name;
        }
    };
    public static IndexFactory categoryIndexFactory = new IndexFactory(){

        @Override
        public Index createIndex(Index parent, Object obj) {
            return new CategoryIndex(parent, (Category)obj);
        }

        @Override
        public String getName(Object obj) {
            return ((Category)obj).getSimpleName();
        }
    };
    public static IndexFactory workingSetIndexFactory = new IndexFactory(){

        @Override
        public Index createIndex(Index parent, Object obj) {
            return new WorkingSetIndex(parent, (Thing)obj);
        }

        @Override
        public String getName(Object obj) {
            return ((Thing)obj).getMetadata().getName();
        }
    };
    public static IndexFactory thingManagerIndexFactory = new IndexFactory(){

        @Override
        public Index createIndex(Index parent, Object obj) {
            return new ThingManagerIndex(parent, (ThingManager)obj);
        }

        @Override
        public String getName(Object obj) {
            return ((ThingManager)obj).getName();
        }
    };

    public abstract Index createIndex(Index var1, Object var2);

    public abstract String getName(Object var1);

    /*
     * WARNING - void declaration
     */
    public static void addOrRemoveChilds(Index parent, List<Index> childs, List indexObjects, IndexFactory indexFactory, String type) {
        void var7_10;
        HashMap<String, Index> existsMap = new HashMap<String, Index>();
        for (Index index : childs) {
            existsMap.put(index.getName(), index);
        }
        HashMap<String, Index> context = new HashMap<String, Index>();
        for (Object obj : indexObjects) {
            String name = indexFactory.getName(obj);
            Index index = (Index)existsMap.get(name);
            if (index == null) {
                index = indexFactory.createIndex(parent, obj);
                existsMap.put(name, index);
                childs.add(index);
            }
            context.put(name, index);
        }
        boolean bl = false;
        while (var7_10 < childs.size()) {
            Index child = childs.get((int)var7_10);
            if (type.equals(child.getType()) && context.get(child.getName()) == null) {
                childs.remove((int)var7_10);
                --var7_10;
            }
            ++var7_10;
        }
    }
}

