/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.ui.session;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.Callable;
import org.xmeta.ActionContext;
import org.xmeta.ui.session.DefaultSessionManager;
import org.xmeta.ui.session.Session;

public abstract class SessionManager {
    private static SessionManager defaultSessionManager;
    private static final List<SessionManager> sessionManagers;
    private static final ThreadLocal<Stack<SessionManager>> sessionManagerLocal;

    public static Session getSession(ActionContext actionContext) {
        Session session = SessionManager.getSessionManager(actionContext).get(actionContext);
        if (session != null) {
            return session;
        }
        return defaultSessionManager.get(actionContext);
    }

    public static Session remove(ActionContext actionContext) {
        return SessionManager.getSessionManager(actionContext).delete(actionContext);
    }

    public static void registSessionManager(SessionManager sessionManager) {
        if (!sessionManagers.contains(sessionManager)) {
            sessionManagers.add(sessionManager);
        }
    }

    public static List<SessionManager> getSessionManagers() {
        return sessionManagers;
    }

    public static SessionManager getSessionManager(ActionContext actionContext) {
        Stack<SessionManager> stackSessionManagers = sessionManagerLocal.get();
        if (stackSessionManagers != null && stackSessionManagers.size() > 0) {
            return stackSessionManagers.peek();
        }
        for (SessionManager sm : sessionManagers) {
            if (!sm.accept(actionContext)) continue;
            return sm;
        }
        return SessionManager.getDefaultSessionManager();
    }

    public static void pushLocalSessionManager(SessionManager sessionManager) {
        Stack<SessionManager> sessionManagers = SessionManager.getLocalSessionManagerStack();
        sessionManagers.push(sessionManager);
    }

    private static Stack<SessionManager> getLocalSessionManagerStack() {
        Stack<SessionManager> sessionManagers = sessionManagerLocal.get();
        if (sessionManagers == null) {
            sessionManagers = new Stack();
            sessionManagerLocal.set(sessionManagers);
        }
        return sessionManagers;
    }

    public static Runnable associateWith(Runnable runnable) {
        SessionManager sessionManager;
        Stack<SessionManager> sessionManagers = SessionManager.getLocalSessionManagerStack();
        SessionManager sessionManager2 = sessionManager = sessionManagers.size() > 0 ? sessionManagers.peek() : null;
        if (sessionManager == null) {
            return runnable;
        }
        return () -> {
            try {
                SessionManager.pushLocalSessionManager(sessionManager);
                runnable.run();
            }
            finally {
                SessionManager.popLocalSessionManager();
            }
        };
    }

    public static Callable<?> associateWith(Callable<?> callable) {
        SessionManager sessionManager;
        Stack<SessionManager> sessionManagers = SessionManager.getLocalSessionManagerStack();
        SessionManager sessionManager2 = sessionManager = sessionManagers.size() > 0 ? sessionManagers.peek() : null;
        if (sessionManager == null) {
            return callable;
        }
        return () -> {
            try {
                SessionManager.pushLocalSessionManager(sessionManager);
                Object v = callable.call();
                return v;
            }
            finally {
                SessionManager.popLocalSessionManager();
            }
        };
    }

    public static void popLocalSessionManager() {
        Stack<SessionManager> sessionManagers = sessionManagerLocal.get();
        if (sessionManagers != null) {
            sessionManagers.pop();
        }
    }

    public static SessionManager getDefaultSessionManager() {
        if (defaultSessionManager == null) {
            defaultSessionManager = new DefaultSessionManager();
        }
        return defaultSessionManager;
    }

    public abstract Session get(ActionContext var1);

    public abstract Session delete(ActionContext var1);

    public abstract boolean accept(ActionContext var1);

    static {
        sessionManagers = new ArrayList<SessionManager>();
        sessionManagerLocal = new ThreadLocal();
    }
}

